/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownEnderpearl
extends ThrowableItemProjectile {
    private long ticketTimer = 0L;

    public ThrownEnderpearl(EntityType<? extends ThrownEnderpearl> p_37491_, Level p_37492_) {
        super((EntityType<? extends ThrowableItemProjectile>)p_37491_, p_37492_);
    }

    public ThrownEnderpearl(Level p_37499_, LivingEntity p_37500_, ItemStack p_360657_) {
        super(EntityType.ENDER_PEARL, p_37500_, p_37499_, p_360657_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void setOwnerThroughUUID(UUID p_373083_) {
        this.deregisterFromCurrentOwner();
        super.setOwnerThroughUUID(p_373083_);
        this.registerToCurrentOwner();
    }

    @Override
    public void setOwner(@Nullable Entity p_372876_) {
        this.deregisterFromCurrentOwner();
        super.setOwner(p_372876_);
        this.registerToCurrentOwner();
    }

    private void deregisterFromCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer $$0 = (ServerPlayer)entity;
            $$0.deregisterEnderPearl(this);
        }
    }

    private void registerToCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer $$0 = (ServerPlayer)entity;
            $$0.registerEnderPearl(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Entity findOwner(UUID p_360307_) {
        void $$2;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel $$1 = (ServerLevel)level;
        Entity $$3 = super.findOwner(p_360307_);
        if ($$3 != null) {
            return $$3;
        }
        for (ServerLevel $$4 : $$2.getServer().getAllLevels()) {
            if ($$4 == $$2 || ($$3 = $$4.getEntity(p_360307_)) == null) continue;
            return $$3;
        }
        return null;
    }

    @Override
    protected void onHitEntity(EntityHitResult p_37502_) {
        super.onHitEntity(p_37502_);
        p_37502_.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onHit(HitResult p_37504_) {
        void $$3;
        block15: {
            block14: {
                super.onHit(p_37504_);
                for (int $$1 = 0; $$1 < 32; ++$$1) {
                    this.level().addParticle(ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
                }
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block14;
                ServerLevel $$2 = (ServerLevel)level;
                if (!this.isRemoved()) break block15;
            }
            return;
        }
        Entity $$4 = this.getOwner();
        if ($$4 == null || !ThrownEnderpearl.isAllowedToTeleportOwner($$4, (Level)$$3)) {
            this.discard();
            return;
        }
        if ($$4.isPassenger()) {
            $$4.unRide();
        }
        Vec3 $$5 = this.oldPosition();
        if ($$4 instanceof ServerPlayer) {
            ServerPlayer $$6 = (ServerPlayer)$$4;
            if ($$6.connection.isAcceptingMessages()) {
                ServerPlayer $$8;
                Endermite $$7;
                if (this.random.nextFloat() < 0.05f && $$3.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && ($$7 = EntityType.ENDERMITE.create((Level)$$3, EntitySpawnReason.TRIGGERED)) != null) {
                    $$7.moveTo($$4.getX(), $$4.getY(), $$4.getZ(), $$4.getYRot(), $$4.getXRot());
                    $$3.addFreshEntity($$7);
                }
                if (this.isOnPortalCooldown()) {
                    $$4.setPortalCooldown();
                }
                if (($$8 = $$6.teleport(new TeleportTransition((ServerLevel)$$3, $$5, Vec3.ZERO, 0.0f, 0.0f, Relative.union(Relative.ROTATION, Relative.DELTA), TeleportTransition.DO_NOTHING))) != null) {
                    $$8.resetFallDistance();
                    $$8.resetCurrentImpulseContext();
                    $$8.hurtServer($$6.serverLevel(), this.damageSources().enderPearl(), 5.0f);
                }
                this.playSound((Level)$$3, $$5);
            }
        } else {
            Entity $$9 = $$4.teleport(new TeleportTransition((ServerLevel)$$3, $$5, $$4.getDeltaMovement(), $$4.getYRot(), $$4.getXRot(), TeleportTransition.DO_NOTHING));
            if ($$9 != null) {
                $$9.resetFallDistance();
            }
            this.playSound((Level)$$3, $$5);
        }
        this.discard();
    }

    private static boolean isAllowedToTeleportOwner(Entity p_352055_, Level p_352453_) {
        if (p_352055_.level().dimension() == p_352453_.dimension()) {
            if (p_352055_ instanceof LivingEntity) {
                LivingEntity $$2 = (LivingEntity)p_352055_;
                return $$2.isAlive() && !$$2.isSleeping();
            }
            return p_352055_.isAlive();
        }
        return p_352055_.canUsePortal(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick() {
        $$0 = SectionPos.blockToSectionCoord(this.position().x());
        $$1 = SectionPos.blockToSectionCoord(this.position().z());
        $$2 = this.getOwner();
        if (!($$2 instanceof ServerPlayer)) ** GOTO lbl-1000
        $$3 = (ServerPlayer)$$2;
        if (!$$2.isAlive() && $$3.serverLevel().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else lbl-1000:
        // 2 sources

        {
            super.tick();
        }
        if (!this.isAlive()) {
            return;
        }
        $$4 = BlockPos.containing(this.position());
        if ((--this.ticketTimer <= 0L || $$0 != SectionPos.blockToSectionCoord($$4.getX()) || $$1 != SectionPos.blockToSectionCoord($$4.getZ())) && $$2 instanceof ServerPlayer) {
            $$5 = (ServerPlayer)$$2;
            this.ticketTimer = $$5.registerAndUpdateEnderPearlTicket(this);
        }
    }

    private void playSound(Level p_350706_, Vec3 p_350543_) {
        p_350706_.playSound(null, p_350543_.x, p_350543_.y, p_350543_.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition p_379805_) {
        Entity $$1 = super.teleport(p_379805_);
        if ($$1 != null) {
            $$1.placePortalTicket(BlockPos.containing($$1.position()));
        }
        return $$1;
    }

    @Override
    public boolean canTeleport(Level p_352941_, Level p_352929_) {
        Entity entity;
        if (p_352941_.dimension() == Level.END && p_352929_.dimension() == Level.OVERWORLD && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$2 = (ServerPlayer)entity;
            return super.canTeleport(p_352941_, p_352929_) && $$2.seenCredits;
        }
        return super.canTeleport(p_352941_, p_352929_);
    }

    @Override
    protected void onInsideBlock(BlockState p_353066_) {
        Entity entity;
        super.onInsideBlock(p_353066_);
        if (p_353066_.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)entity;
            $$1.onInsideBlock(p_353066_);
        }
    }

    @Override
    public void onRemoval(Entity.RemovalReason p_379730_) {
        if (p_379730_ != Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            this.deregisterFromCurrentOwner();
        }
        super.onRemoval(p_379730_);
    }
}

