/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownPotion
extends ThrowableItemProjectile {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<LivingEntity> WATER_SENSITIVE_OR_ON_FIRE = p_375962_ -> p_375962_.isSensitiveToWater() || p_375962_.isOnFire();

    public ThrownPotion(EntityType<? extends ThrownPotion> p_37527_, Level p_37528_) {
        super((EntityType<? extends ThrowableItemProjectile>)p_37527_, p_37528_);
    }

    public ThrownPotion(Level p_37535_, LivingEntity p_37536_, ItemStack p_364103_) {
        super(EntityType.POTION, p_37536_, p_37535_, p_364103_);
    }

    public ThrownPotion(Level p_37530_, double p_37531_, double p_37532_, double p_37533_, ItemStack p_364640_) {
        super(EntityType.POTION, p_37531_, p_37532_, p_37533_, p_37530_, p_364640_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(BlockHitResult p_37541_) {
        super.onHitBlock(p_37541_);
        if (this.level().isClientSide) {
            return;
        }
        ItemStack $$1 = this.getItem();
        Direction $$2 = p_37541_.getDirection();
        BlockPos $$3 = p_37541_.getBlockPos();
        BlockPos $$4 = $$3.relative($$2);
        PotionContents $$5 = $$1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if ($$5.is(Potions.WATER)) {
            this.dowseFire($$4);
            this.dowseFire($$4.relative($$2.getOpposite()));
            for (Direction $$6 : Direction.Plane.HORIZONTAL) {
                this.dowseFire($$4.relative($$6));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onHit(HitResult p_37543_) {
        void $$2;
        super.onHit(p_37543_);
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$1 = (ServerLevel)level;
        ItemStack $$3 = this.getItem();
        PotionContents $$4 = $$3.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if ($$4.is(Potions.WATER)) {
            this.applyWater((ServerLevel)$$2);
        } else if ($$4.hasEffects()) {
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud($$4);
            } else {
                this.applySplash((ServerLevel)$$2, $$4.getAllEffects(), p_37543_.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)p_37543_).getEntity() : null);
            }
        }
        int $$5 = $$4.potion().isPresent() && $$4.potion().get().value().hasInstantEffects() ? 2007 : 2002;
        $$2.levelEvent($$5, this.blockPosition(), $$4.getColor());
        this.discard();
    }

    private void applyWater(ServerLevel p_376630_) {
        AABB $$1 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<LivingEntity> $$2 = this.level().getEntitiesOfClass(LivingEntity.class, $$1, WATER_SENSITIVE_OR_ON_FIRE);
        for (LivingEntity $$3 : $$2) {
            double $$4 = this.distanceToSqr($$3);
            if (!($$4 < 16.0)) continue;
            if ($$3.isSensitiveToWater()) {
                $$3.hurtServer(p_376630_, this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!$$3.isOnFire() || !$$3.isAlive()) continue;
            $$3.extinguishFire();
        }
        List<Axolotl> $$5 = this.level().getEntitiesOfClass(Axolotl.class, $$1);
        for (Axolotl $$6 : $$5) {
            $$6.rehydrate();
        }
    }

    private void applySplash(ServerLevel p_376391_, Iterable<MobEffectInstance> p_330815_, @Nullable Entity p_37549_) {
        AABB $$3 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<LivingEntity> $$4 = p_376391_.getEntitiesOfClass(LivingEntity.class, $$3);
        if (!$$4.isEmpty()) {
            Entity $$5 = this.getEffectSource();
            for (LivingEntity $$6 : $$4) {
                double $$9;
                double $$7;
                if (!$$6.isAffectedByPotions() || !(($$7 = this.distanceToSqr($$6)) < 16.0)) continue;
                if ($$6 == p_37549_) {
                    double $$8 = 1.0;
                } else {
                    $$9 = 1.0 - Math.sqrt($$7) / 4.0;
                }
                for (MobEffectInstance $$10 : p_330815_) {
                    Holder<MobEffect> $$11 = $$10.getEffect();
                    if ($$11.value().isInstantenous()) {
                        $$11.value().applyInstantenousEffect(p_376391_, this, this.getOwner(), $$6, $$10.getAmplifier(), $$9);
                        continue;
                    }
                    int $$12 = $$10.mapDuration(p_267930_ -> (int)($$9 * (double)p_267930_ + 0.5));
                    MobEffectInstance $$13 = new MobEffectInstance($$11, $$12, $$10.getAmplifier(), $$10.isAmbient(), $$10.isVisible());
                    if ($$13.endsWithin(20)) continue;
                    $$6.addEffect($$13, $$5);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(PotionContents p_332124_) {
        AreaEffectCloud $$1 = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity $$2 = (LivingEntity)entity;
            $$1.setOwner($$2);
        }
        $$1.setRadius(3.0f);
        $$1.setRadiusOnUse(-0.5f);
        $$1.setWaitTime(10);
        $$1.setRadiusPerTick(-$$1.getRadius() / (float)$$1.getDuration());
        $$1.setPotionContents(p_332124_);
        this.level().addFreshEntity($$1);
    }

    private boolean isLingering() {
        return this.getItem().is(Items.LINGERING_POTION);
    }

    private void dowseFire(BlockPos p_150193_) {
        BlockState $$1 = this.level().getBlockState(p_150193_);
        if ($$1.is(BlockTags.FIRE)) {
            this.level().destroyBlock(p_150193_, false, this);
        } else if (AbstractCandleBlock.isLit($$1)) {
            AbstractCandleBlock.extinguish(null, $$1, this.level(), p_150193_);
        } else if (CampfireBlock.isLitCampfire($$1)) {
            this.level().levelEvent(null, 1009, p_150193_, 0);
            CampfireBlock.dowse(this.getOwner(), this.level(), p_150193_, $$1);
            this.level().setBlockAndUpdate(p_150193_, (BlockState)$$1.setValue(CampfireBlock.LIT, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity p_345103_, DamageSource p_345887_) {
        double $$2 = p_345103_.position().x - this.position().x;
        double $$3 = p_345103_.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)$$2, (double)$$3);
    }
}

