/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class Raid {
    public static final SpawnPlacementType RAVAGER_SPAWN_PLACEMENT_TYPE = SpawnPlacements.getPlacementType(EntityType.RAVAGER);
    private static final int ALLOW_SPAWNING_WITHIN_VILLAGE_SECONDS_THRESHOLD = 7;
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 5;
    private static final Component OMINOUS_BANNER_PATTERN_NAME = Component.translatable("block.minecraft.ominous_banner");
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int TICKS_PER_DAY = 24000;
    public static final int DEFAULT_MAX_RAID_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final Component RAID_NAME_COMPONENT = Component.translatable("event.minecraft.raid");
    private static final Component RAID_BAR_VICTORY_COMPONENT = Component.translatable("event.minecraft.raid.victory.full");
    private static final Component RAID_BAR_DEFEAT_COMPONENT = Component.translatable("event.minecraft.raid.defeat.full");
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    private static final int VALID_RAID_RADIUS = 96;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, Raider> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<Raider>> groupRaiderMap = Maps.newHashMap();
    private final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    private long ticksActive;
    private BlockPos center;
    private final ServerLevel level;
    private boolean started;
    private final int id;
    private float totalHealth;
    private int raidOmenLevel;
    private boolean active;
    private int groupsSpawned;
    private final ServerBossEvent raidEvent = new ServerBossEvent(RAID_NAME_COMPONENT, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random = RandomSource.create();
    private final int numGroups;
    private RaidStatus status;
    private int celebrationTicks;
    private Optional<BlockPos> waveSpawnPos = Optional.empty();

    public Raid(int p_37692_, ServerLevel p_37693_, BlockPos p_37694_) {
        this.id = p_37692_;
        this.level = p_37693_;
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.setProgress(0.0f);
        this.center = p_37694_;
        this.numGroups = this.getNumGroups(p_37693_.getDifficulty());
        this.status = RaidStatus.ONGOING;
    }

    public Raid(ServerLevel p_37696_, CompoundTag p_37697_) {
        this.level = p_37696_;
        this.id = p_37697_.getInt("Id");
        this.started = p_37697_.getBoolean("Started");
        this.active = p_37697_.getBoolean("Active");
        this.ticksActive = p_37697_.getLong("TicksActive");
        this.raidOmenLevel = p_37697_.getInt("BadOmenLevel");
        this.groupsSpawned = p_37697_.getInt("GroupsSpawned");
        this.raidCooldownTicks = p_37697_.getInt("PreRaidTicks");
        this.postRaidTicks = p_37697_.getInt("PostRaidTicks");
        this.totalHealth = p_37697_.getFloat("TotalHealth");
        this.center = new BlockPos(p_37697_.getInt("CX"), p_37697_.getInt("CY"), p_37697_.getInt("CZ"));
        this.numGroups = p_37697_.getInt("NumGroups");
        this.status = RaidStatus.getByName(p_37697_.getString("Status"));
        this.heroesOfTheVillage.clear();
        if (p_37697_.contains("HeroesOfTheVillage", 9)) {
            ListTag $$2 = p_37697_.getList("HeroesOfTheVillage", 11);
            for (Tag $$3 : $$2) {
                this.heroesOfTheVillage.add(NbtUtils.loadUUID($$3));
            }
        }
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == RaidStatus.STOPPED;
    }

    public boolean isVictory() {
        return this.status == RaidStatus.VICTORY;
    }

    public boolean isLoss() {
        return this.status == RaidStatus.LOSS;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<Raider> getAllRaiders() {
        HashSet $$0 = Sets.newHashSet();
        for (Set<Raider> $$1 : this.groupRaiderMap.values()) {
            $$0.addAll($$1);
        }
        return $$0;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<ServerPlayer> validPlayer() {
        return p_381554_ -> {
            BlockPos $$1 = p_381554_.blockPosition();
            return p_381554_.isAlive() && this.level.getRaidAt($$1) == this;
        };
    }

    private void updatePlayers() {
        HashSet $$0 = Sets.newHashSet(this.raidEvent.getPlayers());
        List<ServerPlayer> $$1 = this.level.getPlayers(this.validPlayer());
        for (ServerPlayer $$2 : $$1) {
            if ($$0.contains($$2)) continue;
            this.raidEvent.addPlayer($$2);
        }
        for (ServerPlayer $$3 : $$0) {
            if ($$1.contains($$3)) continue;
            this.raidEvent.removePlayer($$3);
        }
    }

    public int getMaxRaidOmenLevel() {
        return 5;
    }

    public int getRaidOmenLevel() {
        return this.raidOmenLevel;
    }

    public void setRaidOmenLevel(int p_338727_) {
        this.raidOmenLevel = p_338727_;
    }

    public boolean absorbRaidOmen(ServerPlayer p_338621_) {
        MobEffectInstance $$1 = p_338621_.getEffect(MobEffects.RAID_OMEN);
        if ($$1 == null) {
            return false;
        }
        this.raidOmenLevel += $$1.getAmplifier() + 1;
        this.raidOmenLevel = Mth.clamp(this.raidOmenLevel, 0, this.getMaxRaidOmenLevel());
        if (!this.hasFirstWaveSpawned()) {
            p_338621_.awardStat(Stats.RAID_TRIGGER);
            CriteriaTriggers.RAID_OMEN.trigger(p_338621_);
        }
        return true;
    }

    public void stop() {
        this.active = false;
        this.raidEvent.removeAllPlayers();
        this.status = RaidStatus.STOPPED;
    }

    public void tick() {
        if (this.isStopped()) {
            return;
        }
        if (this.status == RaidStatus.ONGOING) {
            boolean $$0 = this.active;
            this.active = this.level.hasChunkAt(this.center);
            if (this.level.getDifficulty() == Difficulty.PEACEFUL) {
                this.stop();
                return;
            }
            if ($$0 != this.active) {
                this.raidEvent.setVisible(this.active);
            }
            if (!this.active) {
                return;
            }
            if (!this.level.isVillage(this.center)) {
                this.moveRaidCenterToNearbyVillageSection();
            }
            if (!this.level.isVillage(this.center)) {
                if (this.groupsSpawned > 0) {
                    this.status = RaidStatus.LOSS;
                } else {
                    this.stop();
                }
            }
            ++this.ticksActive;
            if (this.ticksActive >= 48000L) {
                this.stop();
                return;
            }
            int $$1 = this.getTotalRaidersAlive();
            if ($$1 == 0 && this.hasMoreWaves()) {
                if (this.raidCooldownTicks > 0) {
                    boolean $$3;
                    boolean $$2 = this.waveSpawnPos.isPresent();
                    boolean bl = $$3 = !$$2 && this.raidCooldownTicks % 5 == 0;
                    if ($$2 && !this.level.isPositionEntityTicking(this.waveSpawnPos.get())) {
                        $$3 = true;
                    }
                    if ($$3) {
                        this.waveSpawnPos = this.getValidSpawnPos();
                    }
                    if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                        this.updatePlayers();
                    }
                    --this.raidCooldownTicks;
                    this.raidEvent.setProgress(Mth.clamp((float)(300 - this.raidCooldownTicks) / 300.0f, 0.0f, 1.0f));
                } else if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                    this.raidCooldownTicks = 300;
                    this.raidEvent.setName(RAID_NAME_COMPONENT);
                    return;
                }
            }
            if (this.ticksActive % 20L == 0L) {
                this.updatePlayers();
                this.updateRaiders();
                if ($$1 > 0) {
                    if ($$1 <= 2) {
                        this.raidEvent.setName(RAID_NAME_COMPONENT.copy().append(" - ").append(Component.translatable(RAIDERS_REMAINING, $$1)));
                    } else {
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                    }
                } else {
                    this.raidEvent.setName(RAID_NAME_COMPONENT);
                }
            }
            boolean $$4 = false;
            int $$5 = 0;
            while (this.shouldSpawnGroup()) {
                BlockPos $$6 = this.waveSpawnPos.orElseGet(() -> this.findRandomSpawnPos(20));
                if ($$6 != null) {
                    this.started = true;
                    this.spawnGroup($$6);
                    if (!$$4) {
                        this.playSound($$6);
                        $$4 = true;
                    }
                } else {
                    ++$$5;
                }
                if ($$5 <= 5) continue;
                this.stop();
                break;
            }
            if (this.isStarted() && !this.hasMoreWaves() && $$1 == 0) {
                if (this.postRaidTicks < 40) {
                    ++this.postRaidTicks;
                } else {
                    this.status = RaidStatus.VICTORY;
                    for (UUID $$7 : this.heroesOfTheVillage) {
                        Entity $$8 = this.level.getEntity($$7);
                        if (!($$8 instanceof LivingEntity)) continue;
                        LivingEntity $$9 = (LivingEntity)$$8;
                        if ($$8.isSpectator()) continue;
                        $$9.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 48000, this.raidOmenLevel - 1, false, false, true));
                        if (!($$9 instanceof ServerPlayer)) continue;
                        ServerPlayer $$10 = (ServerPlayer)$$9;
                        $$10.awardStat(Stats.RAID_WIN);
                        CriteriaTriggers.RAID_WIN.trigger($$10);
                    }
                }
            }
            this.setDirty();
        } else if (this.isOver()) {
            ++this.celebrationTicks;
            if (this.celebrationTicks >= 600) {
                this.stop();
                return;
            }
            if (this.celebrationTicks % 20 == 0) {
                this.updatePlayers();
                this.raidEvent.setVisible(true);
                if (this.isVictory()) {
                    this.raidEvent.setProgress(0.0f);
                    this.raidEvent.setName(RAID_BAR_VICTORY_COMPONENT);
                } else {
                    this.raidEvent.setName(RAID_BAR_DEFEAT_COMPONENT);
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection() {
        Stream<SectionPos> $$0 = SectionPos.cube(SectionPos.of(this.center), 2);
        $$0.filter(this.level::isVillage).map(SectionPos::center).min(Comparator.comparingDouble(p_37766_ -> p_37766_.distSqr(this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPos> getValidSpawnPos() {
        BlockPos $$0 = this.findRandomSpawnPos(8);
        if ($$0 != null) {
            return Optional.of($$0);
        }
        return Optional.empty();
    }

    private boolean hasMoreWaves() {
        if (this.hasBonusWave()) {
            return !this.hasSpawnedBonusWave();
        }
        return !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.raidOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders() {
        Iterator<Set<Raider>> $$0 = this.groupRaiderMap.values().iterator();
        HashSet $$1 = Sets.newHashSet();
        while ($$0.hasNext()) {
            Set<Raider> $$2 = $$0.next();
            for (Raider $$3 : $$2) {
                BlockPos $$4 = $$3.blockPosition();
                if ($$3.isRemoved() || $$3.level().dimension() != this.level.dimension() || this.center.distSqr($$4) >= 12544.0) {
                    $$1.add($$3);
                    continue;
                }
                if ($$3.tickCount <= 600) continue;
                if (this.level.getEntity($$3.getUUID()) == null) {
                    $$1.add($$3);
                }
                if (!this.level.isVillage($$4) && $$3.getNoActionTime() > 2400) {
                    $$3.setTicksOutsideRaid($$3.getTicksOutsideRaid() + 1);
                }
                if ($$3.getTicksOutsideRaid() < 30) continue;
                $$1.add($$3);
            }
        }
        for (Raider $$5 : $$1) {
            this.removeFromRaid($$5, true);
            if (!$$5.isPatrolLeader()) continue;
            this.removeLeader($$5.getWave());
        }
    }

    private void playSound(BlockPos p_37744_) {
        float $$1 = 13.0f;
        int $$2 = 64;
        Collection<ServerPlayer> $$3 = this.raidEvent.getPlayers();
        long $$4 = this.random.nextLong();
        for (ServerPlayer $$5 : this.level.players()) {
            Vec3 $$6 = $$5.position();
            Vec3 $$7 = Vec3.atCenterOf(p_37744_);
            double $$8 = Math.sqrt(($$7.x - $$6.x) * ($$7.x - $$6.x) + ($$7.z - $$6.z) * ($$7.z - $$6.z));
            double $$9 = $$6.x + 13.0 / $$8 * ($$7.x - $$6.x);
            double $$10 = $$6.z + 13.0 / $$8 * ($$7.z - $$6.z);
            if (!($$8 <= 64.0) && !$$3.contains($$5)) continue;
            $$5.connection.send(new ClientboundSoundPacket(SoundEvents.RAID_HORN, SoundSource.NEUTRAL, $$9, $$5.getY(), $$10, 64.0f, 1.0f, $$4));
        }
    }

    private void spawnGroup(BlockPos p_37756_) {
        boolean $$1 = false;
        int $$2 = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyInstance $$3 = this.level.getCurrentDifficultyAt(p_37756_);
        boolean $$4 = this.shouldSpawnBonusGroup();
        for (RaiderType $$5 : RaiderType.VALUES) {
            Raider $$9;
            int $$6 = this.getDefaultNumSpawns($$5, $$2, $$4) + this.getPotentialBonusSpawns($$5, this.random, $$2, $$3, $$4);
            int $$7 = 0;
            for (int $$8 = 0; $$8 < $$6 && ($$9 = $$5.entityType.create(this.level, EntitySpawnReason.EVENT)) != null; ++$$8) {
                if (!$$1 && $$9.canBeLeader()) {
                    $$9.setPatrolLeader(true);
                    this.setLeader($$2, $$9);
                    $$1 = true;
                }
                this.joinRaid($$2, $$9, p_37756_, false);
                if ($$5.entityType != EntityType.RAVAGER) continue;
                Raider $$10 = null;
                if ($$2 == this.getNumGroups(Difficulty.NORMAL)) {
                    $$10 = EntityType.PILLAGER.create(this.level, EntitySpawnReason.EVENT);
                } else if ($$2 >= this.getNumGroups(Difficulty.HARD)) {
                    $$10 = $$7 == 0 ? (Raider)EntityType.EVOKER.create(this.level, EntitySpawnReason.EVENT) : (Raider)EntityType.VINDICATOR.create(this.level, EntitySpawnReason.EVENT);
                }
                ++$$7;
                if ($$10 == null) continue;
                this.joinRaid($$2, $$10, p_37756_, false);
                $$10.moveTo(p_37756_, 0.0f, 0.0f);
                $$10.startRiding($$9);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty();
    }

    public void joinRaid(int p_37714_, Raider p_37715_, @Nullable BlockPos p_37716_, boolean p_37717_) {
        boolean $$4 = this.addWaveMob(p_37714_, p_37715_);
        if ($$4) {
            p_37715_.setCurrentRaid(this);
            p_37715_.setWave(p_37714_);
            p_37715_.setCanJoinRaid(true);
            p_37715_.setTicksOutsideRaid(0);
            if (!p_37717_ && p_37716_ != null) {
                p_37715_.setPos((double)p_37716_.getX() + 0.5, (double)p_37716_.getY() + 1.0, (double)p_37716_.getZ() + 0.5);
                p_37715_.finalizeSpawn(this.level, this.level.getCurrentDifficultyAt(p_37716_), EntitySpawnReason.EVENT, null);
                p_37715_.applyRaidBuffs(this.level, p_37714_, false);
                p_37715_.setOnGround(true);
                this.level.addFreshEntityWithPassengers(p_37715_);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.setProgress(Mth.clamp(this.getHealthOfLivingRaiders() / this.totalHealth, 0.0f, 1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float $$0 = 0.0f;
        for (Set<Raider> $$1 : this.groupRaiderMap.values()) {
            for (Raider $$2 : $$1) {
                $$0 += $$2.getHealth();
            }
        }
        return $$0;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(Raider p_37741_, boolean p_37742_) {
        boolean $$3;
        Set<Raider> $$2 = this.groupRaiderMap.get(p_37741_.getWave());
        if ($$2 != null && ($$3 = $$2.remove(p_37741_))) {
            if (p_37742_) {
                this.totalHealth -= p_37741_.getHealth();
            }
            p_37741_.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty();
        }
    }

    private void setDirty() {
        this.level.getRaids().setDirty();
    }

    public static ItemStack getOminousBannerInstance(HolderGetter<BannerPattern> p_361191_) {
        ItemStack $$1 = new ItemStack(Items.WHITE_BANNER);
        BannerPatternLayers $$2 = new BannerPatternLayers.Builder().addIfRegistered(p_361191_, BannerPatterns.RHOMBUS_MIDDLE, DyeColor.CYAN).addIfRegistered(p_361191_, BannerPatterns.STRIPE_BOTTOM, DyeColor.LIGHT_GRAY).addIfRegistered(p_361191_, BannerPatterns.STRIPE_CENTER, DyeColor.GRAY).addIfRegistered(p_361191_, BannerPatterns.BORDER, DyeColor.LIGHT_GRAY).addIfRegistered(p_361191_, BannerPatterns.STRIPE_MIDDLE, DyeColor.BLACK).addIfRegistered(p_361191_, BannerPatterns.HALF_HORIZONTAL, DyeColor.LIGHT_GRAY).addIfRegistered(p_361191_, BannerPatterns.CIRCLE_MIDDLE, DyeColor.LIGHT_GRAY).addIfRegistered(p_361191_, BannerPatterns.BORDER, DyeColor.BLACK).build();
        $$1.set(DataComponents.BANNER_PATTERNS, $$2);
        $$1.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
        $$1.set(DataComponents.ITEM_NAME, OMINOUS_BANNER_PATTERN_NAME);
        $$1.set(DataComponents.RARITY, Rarity.UNCOMMON);
        return $$1;
    }

    @Nullable
    public Raider getLeader(int p_37751_) {
        return this.groupToLeaderMap.get(p_37751_);
    }

    @Nullable
    private BlockPos findRandomSpawnPos(int p_37708_) {
        int $$1 = this.raidCooldownTicks / 20;
        float $$2 = 0.22f * (float)$$1 - 0.24f;
        BlockPos.MutableBlockPos $$3 = new BlockPos.MutableBlockPos();
        float $$4 = this.level.random.nextFloat() * ((float)Math.PI * 2);
        for (int $$5 = 0; $$5 < p_37708_; ++$$5) {
            int $$8;
            float $$6 = $$4 + (float)Math.PI * (float)$$5 / 8.0f;
            int $$7 = this.center.getX() + Mth.floor(Mth.cos($$6) * 32.0f * $$2) + this.level.random.nextInt(3) * Mth.floor($$2);
            int $$9 = this.level.getHeight(Heightmap.Types.WORLD_SURFACE, $$7, $$8 = this.center.getZ() + Mth.floor(Mth.sin($$6) * 32.0f * $$2) + this.level.random.nextInt(3) * Mth.floor($$2));
            if (Mth.abs($$9 - this.center.getY()) > 96) continue;
            $$3.set($$7, $$9, $$8);
            if (this.level.isVillage($$3) && $$1 > 7) continue;
            int $$10 = 10;
            if (!this.level.hasChunksAt($$3.getX() - 10, $$3.getZ() - 10, $$3.getX() + 10, $$3.getZ() + 10) || !this.level.isPositionEntityTicking($$3) || !RAVAGER_SPAWN_PLACEMENT_TYPE.isSpawnPositionOk(this.level, $$3, EntityType.RAVAGER) && (!this.level.getBlockState((BlockPos)$$3.below()).is(Blocks.SNOW) || !this.level.getBlockState($$3).isAir())) continue;
            return $$3;
        }
        return null;
    }

    private boolean addWaveMob(int p_37753_, Raider p_37754_) {
        return this.addWaveMob(p_37753_, p_37754_, true);
    }

    public boolean addWaveMob(int p_37719_, Raider p_37720_, boolean p_37721_) {
        this.groupRaiderMap.computeIfAbsent(p_37719_, p_37746_ -> Sets.newHashSet());
        Set<Raider> $$3 = this.groupRaiderMap.get(p_37719_);
        Raider $$4 = null;
        for (Raider $$5 : $$3) {
            if (!$$5.getUUID().equals(p_37720_.getUUID())) continue;
            $$4 = $$5;
            break;
        }
        if ($$4 != null) {
            $$3.remove($$4);
            $$3.add(p_37720_);
        }
        $$3.add(p_37720_);
        if (p_37721_) {
            this.totalHealth += p_37720_.getHealth();
        }
        this.updateBossbar();
        this.setDirty();
        return true;
    }

    public void setLeader(int p_37711_, Raider p_37712_) {
        this.groupToLeaderMap.put(p_37711_, p_37712_);
        p_37712_.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance(p_37712_.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        p_37712_.setDropChance(EquipmentSlot.HEAD, 2.0f);
    }

    public void removeLeader(int p_37759_) {
        this.groupToLeaderMap.remove(p_37759_);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    private void setCenter(BlockPos p_37761_) {
        this.center = p_37761_;
    }

    public int getId() {
        return this.id;
    }

    private int getDefaultNumSpawns(RaiderType p_37731_, int p_37732_, boolean p_37733_) {
        return p_37733_ ? p_37731_.spawnsPerWaveBeforeBonus[this.numGroups] : p_37731_.spawnsPerWaveBeforeBonus[p_37732_];
    }

    /*
     * WARNING - void declaration
     */
    private int getPotentialBonusSpawns(RaiderType p_219829_, RandomSource p_219830_, int p_219831_, DifficultyInstance p_219832_, boolean p_219833_) {
        void $$13;
        Difficulty $$5 = p_219832_.getDifficulty();
        boolean $$6 = $$5 == Difficulty.EASY;
        boolean $$7 = $$5 == Difficulty.NORMAL;
        switch (p_219829_.ordinal()) {
            case 3: {
                if (!$$6 && p_219831_ > 2 && p_219831_ != 4) {
                    boolean $$8 = true;
                    break;
                }
                return 0;
            }
            case 0: 
            case 2: {
                if ($$6) {
                    int $$9 = p_219830_.nextInt(2);
                    break;
                }
                if ($$7) {
                    boolean $$10 = true;
                    break;
                }
                int $$11 = 2;
                break;
            }
            case 4: {
                boolean $$12 = !$$6 && p_219833_;
                break;
            }
            default: {
                return 0;
            }
        }
        return $$13 > 0 ? p_219830_.nextInt((int)($$13 + true)) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public CompoundTag save(CompoundTag p_37748_) {
        p_37748_.putInt("Id", this.id);
        p_37748_.putBoolean("Started", this.started);
        p_37748_.putBoolean("Active", this.active);
        p_37748_.putLong("TicksActive", this.ticksActive);
        p_37748_.putInt("BadOmenLevel", this.raidOmenLevel);
        p_37748_.putInt("GroupsSpawned", this.groupsSpawned);
        p_37748_.putInt("PreRaidTicks", this.raidCooldownTicks);
        p_37748_.putInt("PostRaidTicks", this.postRaidTicks);
        p_37748_.putFloat("TotalHealth", this.totalHealth);
        p_37748_.putInt("NumGroups", this.numGroups);
        p_37748_.putString("Status", this.status.getName());
        p_37748_.putInt("CX", this.center.getX());
        p_37748_.putInt("CY", this.center.getY());
        p_37748_.putInt("CZ", this.center.getZ());
        ListTag $$1 = new ListTag();
        for (UUID $$2 : this.heroesOfTheVillage) {
            $$1.add(NbtUtils.createUUID($$2));
        }
        p_37748_.put("HeroesOfTheVillage", $$1);
        return p_37748_;
    }

    public int getNumGroups(Difficulty p_37725_) {
        switch (p_37725_) {
            case EASY: {
                return 3;
            }
            case NORMAL: {
                return 5;
            }
            case HARD: {
                return 7;
            }
        }
        return 0;
    }

    public float getEnchantOdds() {
        int $$0 = this.getRaidOmenLevel();
        if ($$0 == 2) {
            return 0.1f;
        }
        if ($$0 == 3) {
            return 0.25f;
        }
        if ($$0 == 4) {
            return 0.5f;
        }
        if ($$0 == 5) {
            return 0.75f;
        }
        return 0.0f;
    }

    public void addHeroOfTheVillage(Entity p_37727_) {
        this.heroesOfTheVillage.add(p_37727_.getUUID());
    }

    static enum RaidStatus {
        ONGOING,
        VICTORY,
        LOSS,
        STOPPED;

        private static final RaidStatus[] VALUES;

        static RaidStatus getByName(String p_37804_) {
            for (RaidStatus $$1 : VALUES) {
                if (!p_37804_.equalsIgnoreCase($$1.name())) continue;
                return $$1;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = RaidStatus.values();
        }
    }

    static enum RaiderType {
        VINDICATOR(EntityType.VINDICATOR, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        EVOKER(EntityType.EVOKER, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        PILLAGER(EntityType.PILLAGER, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        WITCH(EntityType.WITCH, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        RAVAGER(EntityType.RAVAGER, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        static final RaiderType[] VALUES;
        final EntityType<? extends Raider> entityType;
        final int[] spawnsPerWaveBeforeBonus;

        private RaiderType(EntityType<? extends Raider> p_37821_, int[] p_37822_) {
            this.entityType = p_37821_;
            this.spawnsPerWaveBeforeBonus = p_37822_;
        }

        static {
            VALUES = RaiderType.values();
        }
    }
}

