/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class MinecartTNT
extends AbstractMinecart {
    private static final byte EVENT_PRIME = 10;
    private static final String TAG_EXPLOSION_POWER = "explosion_power";
    private static final float DEFAULT_EXPLOSION_POWER_BASE = 4.0f;
    private int fuse = -1;
    private float explosionPowerBase = 4.0f;

    public MinecartTNT(EntityType<? extends MinecartTNT> p_38649_, Level p_38650_) {
        super(p_38649_, p_38650_);
    }

    @Override
    public BlockState getDefaultDisplayBlockState() {
        return Blocks.TNT.defaultBlockState();
    }

    @Override
    public void tick() {
        double $$0;
        super.tick();
        if (this.fuse > 0) {
            --this.fuse;
            this.level().addParticle(ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.getDeltaMovement().horizontalDistanceSqr());
        }
        if (this.horizontalCollision && ($$0 = this.getDeltaMovement().horizontalDistanceSqr()) >= (double)0.01f) {
            this.explode($$0);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel p_376867_, DamageSource p_376821_, float p_376614_) {
        AbstractArrow $$4;
        Entity $$3 = p_376821_.getDirectEntity();
        if ($$3 instanceof AbstractArrow && ($$4 = (AbstractArrow)$$3).isOnFire()) {
            DamageSource $$5 = this.damageSources().explosion(this, p_376821_.getEntity());
            this.explode($$5, $$4.getDeltaMovement().lengthSqr());
        }
        return super.hurtServer(p_376867_, p_376821_, p_376614_);
    }

    @Override
    public void destroy(ServerLevel p_376428_, DamageSource p_38664_) {
        double $$2 = this.getDeltaMovement().horizontalDistanceSqr();
        if (MinecartTNT.damageSourceIgnitesTnt(p_38664_) || $$2 >= (double)0.01f) {
            if (this.fuse < 0) {
                this.primeFuse();
                this.fuse = this.random.nextInt(20) + this.random.nextInt(20);
            }
            return;
        }
        this.destroy(p_376428_, this.getDropItem());
    }

    @Override
    protected Item getDropItem() {
        return Items.TNT_MINECART;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.TNT_MINECART);
    }

    protected void explode(double p_38689_) {
        this.explode(null, p_38689_);
    }

    protected void explode(@Nullable DamageSource p_259539_, double p_260287_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            double $$3 = Math.min(Math.sqrt(p_260287_), 5.0);
            $$2.explode(this, p_259539_, null, this.getX(), this.getY(), this.getZ(), (float)((double)this.explosionPowerBase + this.random.nextDouble() * 1.5 * $$3), false, Level.ExplosionInteraction.TNT);
            this.discard();
        }
    }

    @Override
    public boolean causeFallDamage(float p_150347_, float p_150348_, DamageSource p_150349_) {
        if (p_150347_ >= 3.0f) {
            float $$3 = p_150347_ / 10.0f;
            this.explode($$3 * $$3);
        }
        return super.causeFallDamage(p_150347_, p_150348_, p_150349_);
    }

    @Override
    public void activateMinecart(int p_38659_, int p_38660_, int p_38661_, boolean p_38662_) {
        if (p_38662_ && this.fuse < 0) {
            this.primeFuse();
        }
    }

    @Override
    public void handleEntityEvent(byte p_38657_) {
        if (p_38657_ == 10) {
            this.primeFuse();
        } else {
            super.handleEntityEvent(p_38657_);
        }
    }

    public void primeFuse() {
        this.fuse = 80;
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent(this, (byte)10);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    @Override
    public float getBlockExplosionResistance(Explosion p_38675_, BlockGetter p_38676_, BlockPos p_38677_, BlockState p_38678_, FluidState p_38679_, float p_38680_) {
        if (this.isPrimed() && (p_38678_.is(BlockTags.RAILS) || p_38676_.getBlockState(p_38677_.above()).is(BlockTags.RAILS))) {
            return 0.0f;
        }
        return super.getBlockExplosionResistance(p_38675_, p_38676_, p_38677_, p_38678_, p_38679_, p_38680_);
    }

    @Override
    public boolean shouldBlockExplode(Explosion p_38669_, BlockGetter p_38670_, BlockPos p_38671_, BlockState p_38672_, float p_38673_) {
        if (this.isPrimed() && (p_38672_.is(BlockTags.RAILS) || p_38670_.getBlockState(p_38671_.above()).is(BlockTags.RAILS))) {
            return false;
        }
        return super.shouldBlockExplode(p_38669_, p_38670_, p_38671_, p_38672_, p_38673_);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_38682_) {
        super.readAdditionalSaveData(p_38682_);
        if (p_38682_.contains("TNTFuse", 99)) {
            this.fuse = p_38682_.getInt("TNTFuse");
        }
        if (p_38682_.contains(TAG_EXPLOSION_POWER, 99)) {
            this.explosionPowerBase = Mth.clamp(p_38682_.getFloat(TAG_EXPLOSION_POWER), 0.0f, 128.0f);
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_38687_) {
        super.addAdditionalSaveData(p_38687_);
        p_38687_.putInt("TNTFuse", this.fuse);
        if (this.explosionPowerBase != 4.0f) {
            p_38687_.putFloat(TAG_EXPLOSION_POWER, this.explosionPowerBase);
        }
    }

    @Override
    boolean shouldSourceDestroy(DamageSource p_312558_) {
        return MinecartTNT.damageSourceIgnitesTnt(p_312558_);
    }

    private static boolean damageSourceIgnitesTnt(DamageSource p_312109_) {
        return p_312109_.is(DamageTypeTags.IS_FIRE) || p_312109_.is(DamageTypeTags.IS_EXPLOSION);
    }
}

