/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;

public abstract class AbstractContainerMenu {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SLOT_CLICKED_OUTSIDE = -999;
    public static final int QUICKCRAFT_TYPE_CHARITABLE = 0;
    public static final int QUICKCRAFT_TYPE_GREEDY = 1;
    public static final int QUICKCRAFT_TYPE_CLONE = 2;
    public static final int QUICKCRAFT_HEADER_START = 0;
    public static final int QUICKCRAFT_HEADER_CONTINUE = 1;
    public static final int QUICKCRAFT_HEADER_END = 2;
    public static final int CARRIED_SLOT_SIZE = Integer.MAX_VALUE;
    public static final int SLOTS_PER_ROW = 9;
    public static final int SLOT_SIZE = 18;
    private final NonNullList<ItemStack> lastSlots = NonNullList.create();
    public final NonNullList<Slot> slots = NonNullList.create();
    private final List<DataSlot> dataSlots = Lists.newArrayList();
    private ItemStack carried = ItemStack.EMPTY;
    private final NonNullList<ItemStack> remoteSlots = NonNullList.create();
    private final IntList remoteDataSlots = new IntArrayList();
    private ItemStack remoteCarried = ItemStack.EMPTY;
    private int stateId;
    @Nullable
    private final MenuType<?> menuType;
    public final int containerId;
    private int quickcraftType = -1;
    private int quickcraftStatus;
    private final Set<Slot> quickcraftSlots = Sets.newHashSet();
    private final List<ContainerListener> containerListeners = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer synchronizer;
    private boolean suppressRemoteUpdates;

    protected AbstractContainerMenu(@Nullable MenuType<?> p_38851_, int p_38852_) {
        this.menuType = p_38851_;
        this.containerId = p_38852_;
    }

    protected void addInventoryHotbarSlots(Container p_363100_, int p_362615_, int p_365310_) {
        for (int $$3 = 0; $$3 < 9; ++$$3) {
            this.addSlot(new Slot(p_363100_, $$3, p_362615_ + $$3 * 18, p_365310_));
        }
    }

    protected void addInventoryExtendedSlots(Container p_360848_, int p_361259_, int p_361419_) {
        for (int $$3 = 0; $$3 < 3; ++$$3) {
            for (int $$4 = 0; $$4 < 9; ++$$4) {
                this.addSlot(new Slot(p_360848_, $$4 + ($$3 + 1) * 9, p_361259_ + $$4 * 18, p_361419_ + $$3 * 18));
            }
        }
    }

    protected void addStandardInventorySlots(Container p_362897_, int p_364704_, int p_361176_) {
        this.addInventoryExtendedSlots(p_362897_, p_364704_, p_361176_);
        int $$3 = 4;
        int $$4 = 58;
        this.addInventoryHotbarSlots(p_362897_, p_364704_, p_361176_ + 58);
    }

    protected static boolean stillValid(ContainerLevelAccess p_38890_, Player p_38891_, Block p_38892_) {
        return p_38890_.evaluate((p_339522_, p_339523_) -> {
            if (!p_339522_.getBlockState((BlockPos)p_339523_).is(p_38892_)) {
                return false;
            }
            return p_38891_.canInteractWithBlock((BlockPos)p_339523_, 4.0);
        }, true);
    }

    public MenuType<?> getType() {
        if (this.menuType == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.menuType;
    }

    protected static void checkContainerSize(Container p_38870_, int p_38871_) {
        int $$2 = p_38870_.getContainerSize();
        if ($$2 < p_38871_) {
            throw new IllegalArgumentException("Container size " + $$2 + " is smaller than expected " + p_38871_);
        }
    }

    protected static void checkContainerDataCount(ContainerData p_38887_, int p_38888_) {
        int $$2 = p_38887_.getCount();
        if ($$2 < p_38888_) {
            throw new IllegalArgumentException("Container data count " + $$2 + " is smaller than expected " + p_38888_);
        }
    }

    public boolean isValidSlotIndex(int p_207776_) {
        return p_207776_ == -1 || p_207776_ == -999 || p_207776_ < this.slots.size();
    }

    protected Slot addSlot(Slot p_38898_) {
        p_38898_.index = this.slots.size();
        this.slots.add(p_38898_);
        this.lastSlots.add(ItemStack.EMPTY);
        this.remoteSlots.add(ItemStack.EMPTY);
        return p_38898_;
    }

    protected DataSlot addDataSlot(DataSlot p_38896_) {
        this.dataSlots.add(p_38896_);
        this.remoteDataSlots.add(0);
        return p_38896_;
    }

    protected void addDataSlots(ContainerData p_38885_) {
        for (int $$1 = 0; $$1 < p_38885_.getCount(); ++$$1) {
            this.addDataSlot(DataSlot.forContainer(p_38885_, $$1));
        }
    }

    public void addSlotListener(ContainerListener p_38894_) {
        if (this.containerListeners.contains(p_38894_)) {
            return;
        }
        this.containerListeners.add(p_38894_);
        this.broadcastChanges();
    }

    public void setSynchronizer(ContainerSynchronizer p_150417_) {
        this.synchronizer = p_150417_;
        this.sendAllDataToRemote();
    }

    public void sendAllDataToRemote() {
        int $$1 = this.slots.size();
        for (int $$0 = 0; $$0 < $$1; ++$$0) {
            this.remoteSlots.set($$0, this.slots.get($$0).getItem().copy());
        }
        this.remoteCarried = this.getCarried().copy();
        int $$3 = this.dataSlots.size();
        for (int $$2 = 0; $$2 < $$3; ++$$2) {
            this.remoteDataSlots.set($$2, this.dataSlots.get($$2).get());
        }
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData(this, this.remoteSlots, this.remoteCarried, this.remoteDataSlots.toIntArray());
        }
    }

    public void removeSlotListener(ContainerListener p_38944_) {
        this.containerListeners.remove(p_38944_);
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList<ItemStack> $$0 = NonNullList.create();
        for (Slot $$1 : this.slots) {
            $$0.add($$1.getItem());
        }
        return $$0;
    }

    public void broadcastChanges() {
        for (int $$0 = 0; $$0 < this.slots.size(); ++$$0) {
            ItemStack $$1 = this.slots.get($$0).getItem();
            com.google.common.base.Supplier $$2 = Suppliers.memoize($$1::copy);
            this.triggerSlotListeners($$0, $$1, (Supplier<ItemStack>)$$2);
            this.synchronizeSlotToRemote($$0, $$1, (Supplier<ItemStack>)$$2);
        }
        this.synchronizeCarriedToRemote();
        for (int $$3 = 0; $$3 < this.dataSlots.size(); ++$$3) {
            DataSlot $$4 = this.dataSlots.get($$3);
            int $$5 = $$4.get();
            if ($$4.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners($$3, $$5);
            }
            this.synchronizeDataSlotToRemote($$3, $$5);
        }
    }

    public void broadcastFullState() {
        for (int $$0 = 0; $$0 < this.slots.size(); ++$$0) {
            ItemStack $$1 = this.slots.get($$0).getItem();
            this.triggerSlotListeners($$0, $$1, $$1::copy);
        }
        for (int $$2 = 0; $$2 < this.dataSlots.size(); ++$$2) {
            DataSlot $$3 = this.dataSlots.get($$2);
            if (!$$3.checkAndClearUpdateFlag()) continue;
            this.updateDataSlotListeners($$2, $$3.get());
        }
        this.sendAllDataToRemote();
    }

    private void updateDataSlotListeners(int p_182421_, int p_182422_) {
        for (ContainerListener $$2 : this.containerListeners) {
            $$2.dataChanged(this, p_182421_, p_182422_);
        }
    }

    private void triggerSlotListeners(int p_150408_, ItemStack p_150409_, Supplier<ItemStack> p_150410_) {
        ItemStack $$3 = this.lastSlots.get(p_150408_);
        if (!ItemStack.matches($$3, p_150409_)) {
            ItemStack $$4 = p_150410_.get();
            this.lastSlots.set(p_150408_, $$4);
            for (ContainerListener $$5 : this.containerListeners) {
                $$5.slotChanged(this, p_150408_, $$4);
            }
        }
    }

    private void synchronizeSlotToRemote(int p_150436_, ItemStack p_150437_, Supplier<ItemStack> p_150438_) {
        if (this.suppressRemoteUpdates) {
            return;
        }
        ItemStack $$3 = this.remoteSlots.get(p_150436_);
        if (!ItemStack.matches($$3, p_150437_)) {
            ItemStack $$4 = p_150438_.get();
            this.remoteSlots.set(p_150436_, $$4);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange(this, p_150436_, $$4);
            }
        }
    }

    private void synchronizeDataSlotToRemote(int p_150441_, int p_150442_) {
        if (this.suppressRemoteUpdates) {
            return;
        }
        int $$2 = this.remoteDataSlots.getInt(p_150441_);
        if ($$2 != p_150442_) {
            this.remoteDataSlots.set(p_150441_, p_150442_);
            if (this.synchronizer != null) {
                this.synchronizer.sendDataChange(this, p_150441_, p_150442_);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        if (this.suppressRemoteUpdates) {
            return;
        }
        if (!ItemStack.matches(this.getCarried(), this.remoteCarried)) {
            this.remoteCarried = this.getCarried().copy();
            if (this.synchronizer != null) {
                this.synchronizer.sendCarriedChange(this, this.remoteCarried);
            }
        }
    }

    public void setRemoteSlot(int p_150405_, ItemStack p_150406_) {
        this.remoteSlots.set(p_150405_, p_150406_.copy());
    }

    public void setRemoteSlotNoCopy(int p_182415_, ItemStack p_182416_) {
        if (p_182415_ < 0 || p_182415_ >= this.remoteSlots.size()) {
            LOGGER.debug("Incorrect slot index: {} available slots: {}", (Object)p_182415_, (Object)this.remoteSlots.size());
            return;
        }
        this.remoteSlots.set(p_182415_, p_182416_);
    }

    public void setRemoteCarried(ItemStack p_150423_) {
        this.remoteCarried = p_150423_.copy();
    }

    public boolean clickMenuButton(Player p_38875_, int p_38876_) {
        return false;
    }

    public Slot getSlot(int p_38854_) {
        return this.slots.get(p_38854_);
    }

    public abstract ItemStack quickMoveStack(Player var1, int var2);

    public void setSelectedBundleItemIndex(int p_362514_, int p_360988_) {
        if (p_362514_ >= 0 && p_362514_ < this.slots.size()) {
            ItemStack $$2 = this.slots.get(p_362514_).getItem();
            BundleItem.toggleSelectedItem($$2, p_360988_);
        }
    }

    public void clicked(int p_150400_, int p_150401_, ClickType p_150402_, Player p_150403_) {
        try {
            this.doClick(p_150400_, p_150401_, p_150402_, p_150403_);
        }
        catch (Exception $$4) {
            CrashReport $$5 = CrashReport.forThrowable($$4, "Container click");
            CrashReportCategory $$6 = $$5.addCategory("Click info");
            $$6.setDetail("Menu Type", () -> this.menuType != null ? BuiltInRegistries.MENU.getKey(this.menuType).toString() : "<no type>");
            $$6.setDetail("Menu Class", () -> this.getClass().getCanonicalName());
            $$6.setDetail("Slot Count", this.slots.size());
            $$6.setDetail("Slot", p_150400_);
            $$6.setDetail("Button", p_150401_);
            $$6.setDetail("Type", (Object)p_150402_);
            throw new ReportedException($$5);
        }
    }

    private void doClick(int p_150431_, int p_150432_, ClickType p_150433_, Player p_150434_) {
        block40: {
            block52: {
                int $$35;
                block51: {
                    block47: {
                        ItemStack $$29;
                        Slot $$28;
                        ItemStack $$27;
                        Inventory $$4;
                        block50: {
                            block49: {
                                block48: {
                                    block45: {
                                        ClickAction $$16;
                                        block46: {
                                            block44: {
                                                block38: {
                                                    block43: {
                                                        ItemStack $$7;
                                                        block42: {
                                                            block41: {
                                                                block39: {
                                                                    $$4 = p_150434_.getInventory();
                                                                    if (p_150433_ != ClickType.QUICK_CRAFT) break block38;
                                                                    int $$5 = this.quickcraftStatus;
                                                                    this.quickcraftStatus = AbstractContainerMenu.getQuickcraftHeader(p_150432_);
                                                                    if ($$5 == 1 && this.quickcraftStatus == 2 || $$5 == this.quickcraftStatus) break block39;
                                                                    this.resetQuickCraft();
                                                                    break block40;
                                                                }
                                                                if (!this.getCarried().isEmpty()) break block41;
                                                                this.resetQuickCraft();
                                                                break block40;
                                                            }
                                                            if (this.quickcraftStatus != 0) break block42;
                                                            this.quickcraftType = AbstractContainerMenu.getQuickcraftType(p_150432_);
                                                            if (AbstractContainerMenu.isValidQuickcraftType(this.quickcraftType, p_150434_)) {
                                                                this.quickcraftStatus = 1;
                                                                this.quickcraftSlots.clear();
                                                            } else {
                                                                this.resetQuickCraft();
                                                            }
                                                            break block40;
                                                        }
                                                        if (this.quickcraftStatus != 1) break block43;
                                                        Slot $$6 = this.slots.get(p_150431_);
                                                        if (!AbstractContainerMenu.canItemQuickReplace($$6, $$7 = this.getCarried(), true) || !$$6.mayPlace($$7) || this.quickcraftType != 2 && $$7.getCount() <= this.quickcraftSlots.size() || !this.canDragTo($$6)) break block40;
                                                        this.quickcraftSlots.add($$6);
                                                        break block40;
                                                    }
                                                    if (this.quickcraftStatus == 2) {
                                                        if (!this.quickcraftSlots.isEmpty()) {
                                                            if (this.quickcraftSlots.size() == 1) {
                                                                int $$8 = this.quickcraftSlots.iterator().next().index;
                                                                this.resetQuickCraft();
                                                                this.doClick($$8, this.quickcraftType, ClickType.PICKUP, p_150434_);
                                                                return;
                                                            }
                                                            ItemStack $$9 = this.getCarried().copy();
                                                            if ($$9.isEmpty()) {
                                                                this.resetQuickCraft();
                                                                return;
                                                            }
                                                            int $$10 = this.getCarried().getCount();
                                                            for (Slot $$11 : this.quickcraftSlots) {
                                                                ItemStack $$12 = this.getCarried();
                                                                if ($$11 == null || !AbstractContainerMenu.canItemQuickReplace($$11, $$12, true) || !$$11.mayPlace($$12) || this.quickcraftType != 2 && $$12.getCount() < this.quickcraftSlots.size() || !this.canDragTo($$11)) continue;
                                                                int $$13 = $$11.hasItem() ? $$11.getItem().getCount() : 0;
                                                                int $$14 = Math.min($$9.getMaxStackSize(), $$11.getMaxStackSize($$9));
                                                                int $$15 = Math.min(AbstractContainerMenu.getQuickCraftPlaceCount(this.quickcraftSlots, this.quickcraftType, $$9) + $$13, $$14);
                                                                $$10 -= $$15 - $$13;
                                                                $$11.setByPlayer($$9.copyWithCount($$15));
                                                            }
                                                            $$9.setCount($$10);
                                                            this.setCarried($$9);
                                                        }
                                                        this.resetQuickCraft();
                                                    } else {
                                                        this.resetQuickCraft();
                                                    }
                                                    break block40;
                                                }
                                                if (this.quickcraftStatus == 0) break block44;
                                                this.resetQuickCraft();
                                                break block40;
                                            }
                                            if (p_150433_ != ClickType.PICKUP && p_150433_ != ClickType.QUICK_MOVE || p_150432_ != 0 && p_150432_ != 1) break block45;
                                            ClickAction clickAction = $$16 = p_150432_ == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                            if (p_150431_ != -999) break block46;
                                            if (this.getCarried().isEmpty()) break block40;
                                            if ($$16 == ClickAction.PRIMARY) {
                                                p_150434_.drop(this.getCarried(), true);
                                                this.setCarried(ItemStack.EMPTY);
                                            } else {
                                                p_150434_.drop(this.getCarried().split(1), true);
                                            }
                                            break block40;
                                        }
                                        if (p_150433_ == ClickType.QUICK_MOVE) {
                                            if (p_150431_ < 0) {
                                                return;
                                            }
                                            Slot $$17 = this.slots.get(p_150431_);
                                            if (!$$17.mayPickup(p_150434_)) {
                                                return;
                                            }
                                            ItemStack $$18 = this.quickMoveStack(p_150434_, p_150431_);
                                            while (!$$18.isEmpty() && ItemStack.isSameItem($$17.getItem(), $$18)) {
                                                $$18 = this.quickMoveStack(p_150434_, p_150431_);
                                            }
                                        } else {
                                            if (p_150431_ < 0) {
                                                return;
                                            }
                                            Slot $$19 = this.slots.get(p_150431_);
                                            ItemStack $$20 = $$19.getItem();
                                            ItemStack $$21 = this.getCarried();
                                            p_150434_.updateTutorialInventoryAction($$21, $$19.getItem(), $$16);
                                            if (!this.tryItemClickBehaviourOverride(p_150434_, $$16, $$19, $$20, $$21)) {
                                                if ($$20.isEmpty()) {
                                                    if (!$$21.isEmpty()) {
                                                        int $$22 = $$16 == ClickAction.PRIMARY ? $$21.getCount() : 1;
                                                        this.setCarried($$19.safeInsert($$21, $$22));
                                                    }
                                                } else if ($$19.mayPickup(p_150434_)) {
                                                    if ($$21.isEmpty()) {
                                                        int $$23 = $$16 == ClickAction.PRIMARY ? $$20.getCount() : ($$20.getCount() + 1) / 2;
                                                        Optional<ItemStack> $$24 = $$19.tryRemove($$23, Integer.MAX_VALUE, p_150434_);
                                                        $$24.ifPresent(p_150421_ -> {
                                                            this.setCarried((ItemStack)p_150421_);
                                                            $$19.onTake(p_150434_, (ItemStack)p_150421_);
                                                        });
                                                    } else if ($$19.mayPlace($$21)) {
                                                        if (ItemStack.isSameItemSameComponents($$20, $$21)) {
                                                            int $$25 = $$16 == ClickAction.PRIMARY ? $$21.getCount() : 1;
                                                            this.setCarried($$19.safeInsert($$21, $$25));
                                                        } else if ($$21.getCount() <= $$19.getMaxStackSize($$21)) {
                                                            this.setCarried($$20);
                                                            $$19.setByPlayer($$21);
                                                        }
                                                    } else if (ItemStack.isSameItemSameComponents($$20, $$21)) {
                                                        Optional<ItemStack> $$26 = $$19.tryRemove($$20.getCount(), $$21.getMaxStackSize() - $$21.getCount(), p_150434_);
                                                        $$26.ifPresent(p_150428_ -> {
                                                            $$21.grow(p_150428_.getCount());
                                                            $$19.onTake(p_150434_, (ItemStack)p_150428_);
                                                        });
                                                    }
                                                }
                                            }
                                            $$19.setChanged();
                                        }
                                        break block40;
                                    }
                                    if (p_150433_ != ClickType.SWAP || (p_150432_ < 0 || p_150432_ >= 9) && p_150432_ != 40) break block47;
                                    $$27 = $$4.getItem(p_150432_);
                                    $$28 = this.slots.get(p_150431_);
                                    $$29 = $$28.getItem();
                                    if ($$27.isEmpty() && $$29.isEmpty()) break block40;
                                    if (!$$27.isEmpty()) break block48;
                                    if (!$$28.mayPickup(p_150434_)) break block40;
                                    $$4.setItem(p_150432_, $$29);
                                    $$28.onSwapCraft($$29.getCount());
                                    $$28.setByPlayer(ItemStack.EMPTY);
                                    $$28.onTake(p_150434_, $$29);
                                    break block40;
                                }
                                if (!$$29.isEmpty()) break block49;
                                if (!$$28.mayPlace($$27)) break block40;
                                int $$30 = $$28.getMaxStackSize($$27);
                                if ($$27.getCount() > $$30) {
                                    $$28.setByPlayer($$27.split($$30));
                                } else {
                                    $$4.setItem(p_150432_, ItemStack.EMPTY);
                                    $$28.setByPlayer($$27);
                                }
                                break block40;
                            }
                            if (!$$28.mayPickup(p_150434_) || !$$28.mayPlace($$27)) break block40;
                            int $$31 = $$28.getMaxStackSize($$27);
                            if ($$27.getCount() <= $$31) break block50;
                            $$28.setByPlayer($$27.split($$31));
                            $$28.onTake(p_150434_, $$29);
                            if ($$4.add($$29)) break block40;
                            p_150434_.drop($$29, true);
                            break block40;
                        }
                        $$4.setItem(p_150432_, $$29);
                        $$28.setByPlayer($$27);
                        $$28.onTake(p_150434_, $$29);
                        break block40;
                    }
                    if (p_150433_ != ClickType.CLONE || !p_150434_.hasInfiniteMaterials() || !this.getCarried().isEmpty() || p_150431_ < 0) break block51;
                    Slot $$32 = this.slots.get(p_150431_);
                    if (!$$32.hasItem()) break block40;
                    ItemStack $$33 = $$32.getItem();
                    this.setCarried($$33.copyWithCount($$33.getMaxStackSize()));
                    break block40;
                }
                if (p_150433_ != ClickType.THROW || !this.getCarried().isEmpty() || p_150431_ < 0) break block52;
                Slot $$34 = this.slots.get(p_150431_);
                int n = $$35 = p_150432_ == 0 ? 1 : $$34.getItem().getCount();
                if (!p_150434_.canDropItems()) {
                    return;
                }
                ItemStack $$36 = $$34.safeTake($$35, Integer.MAX_VALUE, p_150434_);
                p_150434_.drop($$36, true);
                p_150434_.handleCreativeModeItemDrop($$36);
                if (p_150432_ != 1) break block40;
                while (!$$36.isEmpty() && ItemStack.isSameItem($$34.getItem(), $$36)) {
                    if (!p_150434_.canDropItems()) {
                        return;
                    }
                    $$36 = $$34.safeTake($$35, Integer.MAX_VALUE, p_150434_);
                    p_150434_.drop($$36, true);
                    p_150434_.handleCreativeModeItemDrop($$36);
                }
                break block40;
            }
            if (p_150433_ == ClickType.PICKUP_ALL && p_150431_ >= 0) {
                Slot $$37 = this.slots.get(p_150431_);
                ItemStack $$38 = this.getCarried();
                if (!($$38.isEmpty() || $$37.hasItem() && $$37.mayPickup(p_150434_))) {
                    int $$39 = p_150432_ == 0 ? 0 : this.slots.size() - 1;
                    int $$40 = p_150432_ == 0 ? 1 : -1;
                    for (int $$41 = 0; $$41 < 2; ++$$41) {
                        for (int $$42 = $$39; $$42 >= 0 && $$42 < this.slots.size() && $$38.getCount() < $$38.getMaxStackSize(); $$42 += $$40) {
                            Slot $$43 = this.slots.get($$42);
                            if (!$$43.hasItem() || !AbstractContainerMenu.canItemQuickReplace($$43, $$38, true) || !$$43.mayPickup(p_150434_) || !this.canTakeItemForPickAll($$38, $$43)) continue;
                            ItemStack $$44 = $$43.getItem();
                            if ($$41 == 0 && $$44.getCount() == $$44.getMaxStackSize()) continue;
                            ItemStack $$45 = $$43.safeTake($$44.getCount(), $$38.getMaxStackSize() - $$38.getCount(), p_150434_);
                            $$38.grow($$45.getCount());
                        }
                    }
                }
            }
        }
    }

    private boolean tryItemClickBehaviourOverride(Player p_249615_, ClickAction p_250300_, Slot p_249384_, ItemStack p_251073_, ItemStack p_252026_) {
        FeatureFlagSet $$5 = p_249615_.level().enabledFeatures();
        if (p_252026_.isItemEnabled($$5) && p_252026_.overrideStackedOnOther(p_249384_, p_250300_, p_249615_)) {
            return true;
        }
        return p_251073_.isItemEnabled($$5) && p_251073_.overrideOtherStackedOnMe(p_252026_, p_249384_, p_250300_, p_249615_, this.createCarriedSlotAccess());
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return AbstractContainerMenu.this.getCarried();
            }

            @Override
            public boolean set(ItemStack p_150452_) {
                AbstractContainerMenu.this.setCarried(p_150452_);
                return true;
            }
        };
    }

    public boolean canTakeItemForPickAll(ItemStack p_38908_, Slot p_38909_) {
        return true;
    }

    public void removed(Player p_38940_) {
        if (!(p_38940_ instanceof ServerPlayer)) {
            return;
        }
        ItemStack $$1 = this.getCarried();
        if (!$$1.isEmpty()) {
            AbstractContainerMenu.dropOrPlaceInInventory(p_38940_, $$1);
            this.setCarried(ItemStack.EMPTY);
        }
    }

    private static void dropOrPlaceInInventory(Player p_372867_, ItemStack p_372930_) {
        ServerPlayer $$3;
        boolean $$4;
        boolean $$2 = p_372867_.isRemoved() && p_372867_.getRemovalReason() != Entity.RemovalReason.CHANGED_DIMENSION;
        boolean bl = $$4 = p_372867_ instanceof ServerPlayer && ($$3 = (ServerPlayer)p_372867_).hasDisconnected();
        if ($$2 || $$4) {
            p_372867_.drop(p_372930_, false);
        } else if (p_372867_ instanceof ServerPlayer) {
            p_372867_.getInventory().placeItemBackInInventory(p_372930_);
        }
    }

    protected void clearContainer(Player p_150412_, Container p_150413_) {
        for (int $$2 = 0; $$2 < p_150413_.getContainerSize(); ++$$2) {
            AbstractContainerMenu.dropOrPlaceInInventory(p_150412_, p_150413_.removeItemNoUpdate($$2));
        }
    }

    public void slotsChanged(Container p_38868_) {
        this.broadcastChanges();
    }

    public void setItem(int p_182407_, int p_182408_, ItemStack p_182409_) {
        this.getSlot(p_182407_).set(p_182409_);
        this.stateId = p_182408_;
    }

    public void initializeContents(int p_182411_, List<ItemStack> p_182412_, ItemStack p_182413_) {
        for (int $$3 = 0; $$3 < p_182412_.size(); ++$$3) {
            this.getSlot($$3).set(p_182412_.get($$3));
        }
        this.carried = p_182413_;
        this.stateId = p_182411_;
    }

    public void setData(int p_38855_, int p_38856_) {
        this.dataSlots.get(p_38855_).set(p_38856_);
    }

    public abstract boolean stillValid(Player var1);

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean $$4 = false;
        int $$5 = p_38905_;
        if (p_38907_) {
            $$5 = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? $$5 >= p_38905_ : $$5 < p_38906_)) {
                Slot $$6 = this.slots.get($$5);
                ItemStack $$7 = $$6.getItem();
                if (!$$7.isEmpty() && ItemStack.isSameItemSameComponents(p_38904_, $$7)) {
                    int $$9;
                    int $$8 = $$7.getCount() + p_38904_.getCount();
                    if ($$8 <= ($$9 = $$6.getMaxStackSize($$7))) {
                        p_38904_.setCount(0);
                        $$7.setCount($$8);
                        $$6.setChanged();
                        $$4 = true;
                    } else if ($$7.getCount() < $$9) {
                        p_38904_.shrink($$9 - $$7.getCount());
                        $$7.setCount($$9);
                        $$6.setChanged();
                        $$4 = true;
                    }
                }
                if (p_38907_) {
                    --$$5;
                    continue;
                }
                ++$$5;
            }
        }
        if (!p_38904_.isEmpty()) {
            $$5 = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? $$5 >= p_38905_ : $$5 < p_38906_) {
                Slot $$10 = this.slots.get($$5);
                ItemStack $$11 = $$10.getItem();
                if ($$11.isEmpty() && $$10.mayPlace(p_38904_)) {
                    int $$12 = $$10.getMaxStackSize(p_38904_);
                    $$10.setByPlayer(p_38904_.split(Math.min(p_38904_.getCount(), $$12)));
                    $$10.setChanged();
                    $$4 = true;
                    break;
                }
                if (p_38907_) {
                    --$$5;
                    continue;
                }
                ++$$5;
            }
        }
        return $$4;
    }

    public static int getQuickcraftType(int p_38929_) {
        return p_38929_ >> 2 & 3;
    }

    public static int getQuickcraftHeader(int p_38948_) {
        return p_38948_ & 3;
    }

    public static int getQuickcraftMask(int p_38931_, int p_38932_) {
        return p_38931_ & 3 | (p_38932_ & 3) << 2;
    }

    public static boolean isValidQuickcraftType(int p_38863_, Player p_38864_) {
        if (p_38863_ == 0) {
            return true;
        }
        if (p_38863_ == 1) {
            return true;
        }
        return p_38863_ == 2 && p_38864_.hasInfiniteMaterials();
    }

    protected void resetQuickCraft() {
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    public static boolean canItemQuickReplace(@Nullable Slot p_38900_, ItemStack p_38901_, boolean p_38902_) {
        boolean $$3;
        boolean bl = $$3 = p_38900_ == null || !p_38900_.hasItem();
        if (!$$3 && ItemStack.isSameItemSameComponents(p_38901_, p_38900_.getItem())) {
            return p_38900_.getItem().getCount() + (p_38902_ ? 0 : p_38901_.getCount()) <= p_38901_.getMaxStackSize();
        }
        return $$3;
    }

    public static int getQuickCraftPlaceCount(Set<Slot> p_279393_, int p_279288_, ItemStack p_279172_) {
        return switch (p_279288_) {
            case 0 -> Mth.floor((float)p_279172_.getCount() / (float)p_279393_.size());
            case 1 -> 1;
            case 2 -> p_279172_.getMaxStackSize();
            default -> p_279172_.getCount();
        };
    }

    public boolean canDragTo(Slot p_38945_) {
        return true;
    }

    public static int getRedstoneSignalFromBlockEntity(@Nullable BlockEntity p_38919_) {
        if (p_38919_ instanceof Container) {
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Object)p_38919_));
        }
        return 0;
    }

    public static int getRedstoneSignalFromContainer(@Nullable Container p_38939_) {
        if (p_38939_ == null) {
            return 0;
        }
        float $$1 = 0.0f;
        for (int $$2 = 0; $$2 < p_38939_.getContainerSize(); ++$$2) {
            ItemStack $$3 = p_38939_.getItem($$2);
            if ($$3.isEmpty()) continue;
            $$1 += (float)$$3.getCount() / (float)p_38939_.getMaxStackSize($$3);
        }
        return Mth.lerpDiscrete($$1 /= (float)p_38939_.getContainerSize(), 0, 15);
    }

    public void setCarried(ItemStack p_150439_) {
        this.carried = p_150439_;
    }

    public ItemStack getCarried() {
        return this.carried;
    }

    public void suppressRemoteUpdates() {
        this.suppressRemoteUpdates = true;
    }

    public void resumeRemoteUpdates() {
        this.suppressRemoteUpdates = false;
    }

    public void transferState(AbstractContainerMenu p_150415_) {
        HashBasedTable $$1 = HashBasedTable.create();
        for (int $$2 = 0; $$2 < p_150415_.slots.size(); ++$$2) {
            Slot $$3 = p_150415_.slots.get($$2);
            $$1.put((Object)$$3.container, (Object)$$3.getContainerSlot(), (Object)$$2);
        }
        for (int $$4 = 0; $$4 < this.slots.size(); ++$$4) {
            Slot $$5 = this.slots.get($$4);
            Integer $$6 = (Integer)$$1.get((Object)$$5.container, (Object)$$5.getContainerSlot());
            if ($$6 == null) continue;
            this.lastSlots.set($$4, p_150415_.lastSlots.get($$6));
            this.remoteSlots.set($$4, p_150415_.remoteSlots.get($$6));
        }
    }

    public OptionalInt findSlot(Container p_182418_, int p_182419_) {
        for (int $$2 = 0; $$2 < this.slots.size(); ++$$2) {
            Slot $$3 = this.slots.get($$2);
            if ($$3.container != p_182418_ || p_182419_ != $$3.getContainerSlot()) continue;
            return OptionalInt.of($$2);
        }
        return OptionalInt.empty();
    }

    public int getStateId() {
        return this.stateId;
    }

    public int incrementStateId() {
        this.stateId = this.stateId + 1 & Short.MAX_VALUE;
        return this.stateId;
    }
}

