/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HorseInventoryMenu
extends AbstractContainerMenu {
    private final Container horseContainer;
    private final Container armorContainer;
    private final AbstractHorse horse;
    private static final int SLOT_BODY_ARMOR = 1;
    private static final int SLOT_HORSE_INVENTORY_START = 2;

    public HorseInventoryMenu(int p_39656_, Inventory p_39657_, Container p_39658_, final AbstractHorse p_39659_, int p_352384_) {
        super(null, p_39656_);
        this.horseContainer = p_39658_;
        this.armorContainer = p_39659_.getBodyArmorAccess();
        this.horse = p_39659_;
        p_39658_.startOpen(p_39657_.player);
        this.addSlot(new Slot(this, p_39658_, 0, 8, 18){

            @Override
            public boolean mayPlace(ItemStack p_39677_) {
                return p_39677_.is(Items.SADDLE) && !this.hasItem() && p_39659_.isSaddleable();
            }

            @Override
            public boolean isActive() {
                return p_39659_.isSaddleable();
            }
        });
        this.addSlot(new ArmorSlot(this, this.armorContainer, p_39659_, EquipmentSlot.BODY, 0, 8, 36, null){

            @Override
            public boolean mayPlace(ItemStack p_39690_) {
                return p_39659_.isEquippableInSlot(p_39690_, EquipmentSlot.BODY);
            }

            @Override
            public boolean isActive() {
                return p_39659_.canUseSlot(EquipmentSlot.BODY);
            }
        });
        if (p_352384_ > 0) {
            for (int $$5 = 0; $$5 < 3; ++$$5) {
                for (int $$6 = 0; $$6 < p_352384_; ++$$6) {
                    this.addSlot(new Slot(p_39658_, 1 + $$6 + $$5 * p_352384_, 80 + $$6 * 18, 18 + $$5 * 18));
                }
            }
        }
        this.addStandardInventorySlots(p_39657_, 8, 84);
    }

    @Override
    public boolean stillValid(Player p_39661_) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(p_39661_) && this.armorContainer.stillValid(p_39661_) && this.horse.isAlive() && p_39661_.canInteractWithEntity(this.horse, 4.0);
    }

    @Override
    public ItemStack quickMoveStack(Player p_39665_, int p_39666_) {
        ItemStack $$2 = ItemStack.EMPTY;
        Slot $$3 = (Slot)this.slots.get(p_39666_);
        if ($$3 != null && $$3.hasItem()) {
            ItemStack $$4 = $$3.getItem();
            $$2 = $$4.copy();
            int $$5 = this.horseContainer.getContainerSize() + 1;
            if (p_39666_ < $$5) {
                if (!this.moveItemStackTo($$4, $$5, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace($$4) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo($$4, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace($$4)) {
                if (!this.moveItemStackTo($$4, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if ($$5 <= 1 || !this.moveItemStackTo($$4, 2, $$5, false)) {
                int $$7;
                int $$6 = $$5;
                int $$8 = $$7 = $$6 + 27;
                int $$9 = $$8 + 9;
                if (p_39666_ >= $$8 && p_39666_ < $$9 ? !this.moveItemStackTo($$4, $$6, $$7, false) : (p_39666_ >= $$6 && p_39666_ < $$7 ? !this.moveItemStackTo($$4, $$8, $$9, false) : !this.moveItemStackTo($$4, $$8, $$7, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if ($$4.isEmpty()) {
                $$3.setByPlayer(ItemStack.EMPTY);
            } else {
                $$3.setChanged();
            }
        }
        return $$2;
    }

    @Override
    public void removed(Player p_39663_) {
        super.removed(p_39663_);
        this.horseContainer.stopOpen(p_39663_);
    }
}

