/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ItemCombinerMenu
extends AbstractContainerMenu {
    private static final int INVENTORY_SLOTS_PER_ROW = 9;
    private static final int INVENTORY_ROWS = 3;
    private static final int INPUT_SLOT_START = 0;
    protected final ContainerLevelAccess access;
    protected final Player player;
    protected final Container inputSlots;
    protected final ResultContainer resultSlots = new ResultContainer(){

        @Override
        public void setChanged() {
            ItemCombinerMenu.this.slotsChanged(this);
        }
    };
    private final int resultSlotIndex;

    protected boolean mayPickup(Player p_39798_, boolean p_39799_) {
        return true;
    }

    protected abstract void onTake(Player var1, ItemStack var2);

    protected abstract boolean isValidBlock(BlockState var1);

    public ItemCombinerMenu(@Nullable MenuType<?> p_39773_, int p_39774_, Inventory p_39775_, ContainerLevelAccess p_39776_, ItemCombinerMenuSlotDefinition p_379677_) {
        super(p_39773_, p_39774_);
        this.access = p_39776_;
        this.player = p_39775_.player;
        this.inputSlots = this.createContainer(p_379677_.getNumOfInputSlots());
        this.resultSlotIndex = p_379677_.getResultSlotIndex();
        this.createInputSlots(p_379677_);
        this.createResultSlot(p_379677_);
        this.addStandardInventorySlots(p_39775_, 8, 84);
    }

    private void createInputSlots(ItemCombinerMenuSlotDefinition p_267172_) {
        for (final ItemCombinerMenuSlotDefinition.SlotDefinition $$1 : p_267172_.getSlots()) {
            this.addSlot(new Slot(this, this.inputSlots, $$1.slotIndex(), $$1.x(), $$1.y()){

                @Override
                public boolean mayPlace(ItemStack p_39818_) {
                    return $$1.mayPlace().test(p_39818_);
                }
            });
        }
    }

    private void createResultSlot(ItemCombinerMenuSlotDefinition p_267000_) {
        this.addSlot(new Slot(this.resultSlots, p_267000_.getResultSlot().slotIndex(), p_267000_.getResultSlot().x(), p_267000_.getResultSlot().y()){

            @Override
            public boolean mayPlace(ItemStack p_381651_) {
                return false;
            }

            @Override
            public boolean mayPickup(Player p_381633_) {
                return ItemCombinerMenu.this.mayPickup(p_381633_, this.hasItem());
            }

            @Override
            public void onTake(Player p_381623_, ItemStack p_381628_) {
                ItemCombinerMenu.this.onTake(p_381623_, p_381628_);
            }
        });
    }

    public abstract void createResult();

    private SimpleContainer createContainer(int p_267204_) {
        return new SimpleContainer(p_267204_){

            @Override
            public void setChanged() {
                super.setChanged();
                ItemCombinerMenu.this.slotsChanged(this);
            }
        };
    }

    @Override
    public void slotsChanged(Container p_39778_) {
        super.slotsChanged(p_39778_);
        if (p_39778_ == this.inputSlots) {
            this.createResult();
        }
    }

    @Override
    public void removed(Player p_39790_) {
        super.removed(p_39790_);
        this.access.execute((p_39796_, p_39797_) -> this.clearContainer(p_39790_, this.inputSlots));
    }

    @Override
    public boolean stillValid(Player p_39780_) {
        return this.access.evaluate((p_339525_, p_339526_) -> {
            if (!this.isValidBlock(p_339525_.getBlockState((BlockPos)p_339526_))) {
                return false;
            }
            return p_39780_.canInteractWithBlock((BlockPos)p_339526_, 4.0);
        }, true);
    }

    @Override
    public ItemStack quickMoveStack(Player p_39792_, int p_39793_) {
        ItemStack $$2 = ItemStack.EMPTY;
        Slot $$3 = (Slot)this.slots.get(p_39793_);
        if ($$3 != null && $$3.hasItem()) {
            ItemStack $$4 = $$3.getItem();
            $$2 = $$4.copy();
            int $$5 = this.getInventorySlotStart();
            int $$6 = this.getUseRowEnd();
            if (p_39793_ == this.getResultSlot()) {
                if (!this.moveItemStackTo($$4, $$5, $$6, true)) {
                    return ItemStack.EMPTY;
                }
                $$3.onQuickCraft($$4, $$2);
            } else if (p_39793_ >= 0 && p_39793_ < this.getResultSlot() ? !this.moveItemStackTo($$4, $$5, $$6, false) : (this.canMoveIntoInputSlots($$4) && p_39793_ >= this.getInventorySlotStart() && p_39793_ < this.getUseRowEnd() ? !this.moveItemStackTo($$4, 0, this.getResultSlot(), false) : (p_39793_ >= this.getInventorySlotStart() && p_39793_ < this.getInventorySlotEnd() ? !this.moveItemStackTo($$4, this.getUseRowStart(), this.getUseRowEnd(), false) : p_39793_ >= this.getUseRowStart() && p_39793_ < this.getUseRowEnd() && !this.moveItemStackTo($$4, this.getInventorySlotStart(), this.getInventorySlotEnd(), false)))) {
                return ItemStack.EMPTY;
            }
            if ($$4.isEmpty()) {
                $$3.setByPlayer(ItemStack.EMPTY);
            } else {
                $$3.setChanged();
            }
            if ($$4.getCount() == $$2.getCount()) {
                return ItemStack.EMPTY;
            }
            $$3.onTake(p_39792_, $$4);
        }
        return $$2;
    }

    protected boolean canMoveIntoInputSlots(ItemStack p_39787_) {
        return true;
    }

    public int getResultSlot() {
        return this.resultSlotIndex;
    }

    private int getInventorySlotStart() {
        return this.getResultSlot() + 1;
    }

    private int getInventorySlotEnd() {
        return this.getInventorySlotStart() + 27;
    }

    private int getUseRowStart() {
        return this.getInventorySlotEnd();
    }

    private int getUseRowEnd() {
        return this.getUseRowStart() + 9;
    }
}

