/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BlockItem
extends Item {
    @Deprecated
    private final Block block;

    public BlockItem(Block p_40565_, Item.Properties p_40566_) {
        super(p_40566_);
        this.block = p_40565_;
    }

    @Override
    public InteractionResult useOn(UseOnContext p_40581_) {
        InteractionResult $$1 = this.place(new BlockPlaceContext(p_40581_));
        if (!$$1.consumesAction() && p_40581_.getItemInHand().has(DataComponents.CONSUMABLE)) {
            return super.use(p_40581_.getLevel(), p_40581_.getPlayer(), p_40581_.getHand());
        }
        return $$1;
    }

    public InteractionResult place(BlockPlaceContext p_40577_) {
        if (!this.getBlock().isEnabled(p_40577_.getLevel().enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (!p_40577_.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext $$1 = this.updatePlacementContext(p_40577_);
        if ($$1 == null) {
            return InteractionResult.FAIL;
        }
        BlockState $$2 = this.getPlacementState($$1);
        if ($$2 == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock($$1, $$2)) {
            return InteractionResult.FAIL;
        }
        BlockPos $$3 = $$1.getClickedPos();
        Level $$4 = $$1.getLevel();
        Player $$5 = $$1.getPlayer();
        ItemStack $$6 = $$1.getItemInHand();
        BlockState $$7 = $$4.getBlockState($$3);
        if ($$7.is($$2.getBlock())) {
            $$7 = this.updateBlockStateFromTag($$3, $$4, $$6, $$7);
            this.updateCustomBlockEntityTag($$3, $$4, $$5, $$6, $$7);
            BlockItem.updateBlockEntityComponents($$4, $$3, $$6);
            $$7.getBlock().setPlacedBy($$4, $$3, $$7, $$5, $$6);
            if ($$5 instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)$$5, $$3, $$6);
            }
        }
        SoundType $$8 = $$7.getSoundType();
        $$4.playSound($$5, $$3, this.getPlaceSound($$7), SoundSource.BLOCKS, ($$8.getVolume() + 1.0f) / 2.0f, $$8.getPitch() * 0.8f);
        $$4.gameEvent(GameEvent.BLOCK_PLACE, $$3, GameEvent.Context.of($$5, $$7));
        $$6.consume(1, $$5);
        return InteractionResult.SUCCESS;
    }

    protected SoundEvent getPlaceSound(BlockState p_40588_) {
        return p_40588_.getSoundType().getPlaceSound();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext p_40609_) {
        return p_40609_;
    }

    private static void updateBlockEntityComponents(Level p_331559_, BlockPos p_331993_, ItemStack p_332021_) {
        BlockEntity $$3 = p_331559_.getBlockEntity(p_331993_);
        if ($$3 != null) {
            $$3.applyComponentsFromItemStack(p_332021_);
            $$3.setChanged();
        }
    }

    protected boolean updateCustomBlockEntityTag(BlockPos p_40597_, Level p_40598_, @Nullable Player p_40599_, ItemStack p_40600_, BlockState p_40601_) {
        return BlockItem.updateCustomBlockEntityTag(p_40598_, p_40599_, p_40597_, p_40600_);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext p_40613_) {
        BlockState $$1 = this.getBlock().getStateForPlacement(p_40613_);
        return $$1 != null && this.canPlace(p_40613_, $$1) ? $$1 : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos p_40603_, Level p_40604_, ItemStack p_40605_, BlockState p_40606_) {
        BlockItemStateProperties $$4 = p_40605_.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY);
        if ($$4.isEmpty()) {
            return p_40606_;
        }
        BlockState $$5 = $$4.apply(p_40606_);
        if ($$5 != p_40606_) {
            p_40604_.setBlock(p_40603_, $$5, 2);
        }
        return $$5;
    }

    protected boolean canPlace(BlockPlaceContext p_40611_, BlockState p_40612_) {
        Player $$2 = p_40611_.getPlayer();
        CollisionContext $$3 = $$2 == null ? CollisionContext.empty() : CollisionContext.of($$2);
        return (!this.mustSurvive() || p_40612_.canSurvive(p_40611_.getLevel(), p_40611_.getClickedPos())) && p_40611_.getLevel().isUnobstructed(p_40612_, p_40611_.getClickedPos(), $$3);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext p_40578_, BlockState p_40579_) {
        return p_40578_.getLevel().setBlock(p_40578_.getClickedPos(), p_40579_, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level p_40583_, @Nullable Player p_40584_, BlockPos p_40585_, ItemStack p_40586_) {
        BlockEntity $$6;
        MinecraftServer $$4 = p_40583_.getServer();
        if ($$4 == null) {
            return false;
        }
        CustomData $$5 = p_40586_.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
        if (!$$5.isEmpty() && ($$6 = p_40583_.getBlockEntity(p_40585_)) != null) {
            if (!(p_40583_.isClientSide || !$$6.onlyOpCanSetNbt() || p_40584_ != null && p_40584_.canUseGameMasterBlocks())) {
                return false;
            }
            return $$5.loadInto($$6, p_40583_.registryAccess());
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack p_40572_, Item.TooltipContext p_339655_, List<Component> p_40574_, TooltipFlag p_40575_) {
        super.appendHoverText(p_40572_, p_339655_, p_40574_, p_40575_);
        this.getBlock().appendHoverText(p_40572_, p_339655_, p_40574_, p_40575_);
    }

    public Block getBlock() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> p_40607_, Item p_40608_) {
        p_40607_.put(this.getBlock(), p_40608_);
    }

    @Override
    public boolean canFitInsideContainerItems() {
        return !(this.getBlock() instanceof ShulkerBoxBlock);
    }

    @Override
    public void onDestroyed(ItemEntity p_150700_) {
        ItemContainerContents $$1 = p_150700_.getItem().set(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        if ($$1 != null) {
            ItemUtils.onContainerDestroyed(p_150700_, $$1.nonEmptyItemsCopy());
        }
    }

    public static void setBlockEntityData(ItemStack p_186339_, BlockEntityType<?> p_186340_, CompoundTag p_186341_) {
        p_186341_.remove("id");
        if (p_186341_.isEmpty()) {
            p_186339_.remove(DataComponents.BLOCK_ENTITY_DATA);
        } else {
            BlockEntity.addEntityType(p_186341_, p_186340_);
            p_186339_.set(DataComponents.BLOCK_ENTITY_DATA, CustomData.of(p_186341_));
        }
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.getBlock().requiredFeatures();
    }
}

