/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class BoneMealItem
extends Item {
    public static final int GRASS_SPREAD_WIDTH = 3;
    public static final int GRASS_SPREAD_HEIGHT = 1;
    public static final int GRASS_COUNT_MULTIPLIER = 3;

    public BoneMealItem(Item.Properties p_40626_) {
        super(p_40626_);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_40637_) {
        Level $$1 = p_40637_.getLevel();
        BlockPos $$2 = p_40637_.getClickedPos();
        BlockPos $$3 = $$2.relative(p_40637_.getClickedFace());
        if (BoneMealItem.growCrop(p_40637_.getItemInHand(), $$1, $$2)) {
            if (!$$1.isClientSide) {
                p_40637_.getPlayer().gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                $$1.levelEvent(1505, $$2, 15);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState $$4 = $$1.getBlockState($$2);
        boolean $$5 = $$4.isFaceSturdy($$1, $$2, p_40637_.getClickedFace());
        if ($$5 && BoneMealItem.growWaterPlant(p_40637_.getItemInHand(), $$1, $$3, p_40637_.getClickedFace())) {
            if (!$$1.isClientSide) {
                p_40637_.getPlayer().gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                $$1.levelEvent(1505, $$3, 15);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean growCrop(ItemStack p_40628_, Level p_40629_, BlockPos p_40630_) {
        BonemealableBlock $$4;
        BlockState $$3 = p_40629_.getBlockState(p_40630_);
        Block block = $$3.getBlock();
        if (block instanceof BonemealableBlock && ($$4 = (BonemealableBlock)((Object)block)).isValidBonemealTarget(p_40629_, p_40630_, $$3)) {
            if (p_40629_ instanceof ServerLevel) {
                if ($$4.isBonemealSuccess(p_40629_, p_40629_.random, p_40630_, $$3)) {
                    $$4.performBonemeal((ServerLevel)p_40629_, p_40629_.random, p_40630_, $$3);
                }
                p_40628_.shrink(1);
            }
            return true;
        }
        return false;
    }

    public static boolean growWaterPlant(ItemStack p_40632_, Level p_40633_, BlockPos p_40634_, @Nullable Direction p_40635_) {
        if (!p_40633_.getBlockState(p_40634_).is(Blocks.WATER) || p_40633_.getFluidState(p_40634_).getAmount() != 8) {
            return false;
        }
        if (!(p_40633_ instanceof ServerLevel)) {
            return true;
        }
        RandomSource $$4 = p_40633_.getRandom();
        block0: for (int $$5 = 0; $$5 < 128; ++$$5) {
            BlockPos $$6 = p_40634_;
            BlockState $$7 = Blocks.SEAGRASS.defaultBlockState();
            for (int $$8 = 0; $$8 < $$5 / 16; ++$$8) {
                if (p_40633_.getBlockState($$6 = $$6.offset($$4.nextInt(3) - 1, ($$4.nextInt(3) - 1) * $$4.nextInt(3) / 2, $$4.nextInt(3) - 1)).isCollisionShapeFullBlock(p_40633_, $$6)) continue block0;
            }
            Holder<Biome> $$9 = p_40633_.getBiome($$6);
            if ($$9.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL)) {
                if ($$5 == 0 && p_40635_ != null && p_40635_.getAxis().isHorizontal()) {
                    $$7 = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.WALL_CORALS, p_40633_.random).map(p_204100_ -> ((Block)p_204100_.value()).defaultBlockState()).orElse($$7);
                    if ($$7.hasProperty(BaseCoralWallFanBlock.FACING)) {
                        $$7 = (BlockState)$$7.setValue(BaseCoralWallFanBlock.FACING, p_40635_);
                    }
                } else if ($$4.nextInt(4) == 0) {
                    $$7 = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.UNDERWATER_BONEMEALS, p_40633_.random).map(p_204095_ -> ((Block)p_204095_.value()).defaultBlockState()).orElse($$7);
                }
            }
            if ($$7.is(BlockTags.WALL_CORALS, p_373910_ -> p_373910_.hasProperty(BaseCoralWallFanBlock.FACING))) {
                for (int $$10 = 0; !$$7.canSurvive(p_40633_, $$6) && $$10 < 4; ++$$10) {
                    $$7 = (BlockState)$$7.setValue(BaseCoralWallFanBlock.FACING, Direction.Plane.HORIZONTAL.getRandomDirection($$4));
                }
            }
            if (!$$7.canSurvive(p_40633_, $$6)) continue;
            BlockState $$11 = p_40633_.getBlockState($$6);
            if ($$11.is(Blocks.WATER) && p_40633_.getFluidState($$6).getAmount() == 8) {
                p_40633_.setBlock($$6, $$7, 3);
                continue;
            }
            if (!$$11.is(Blocks.SEAGRASS) || !((BonemealableBlock)((Object)Blocks.SEAGRASS)).isValidBonemealTarget(p_40633_, $$6, $$11) || $$4.nextInt(10) != 0) continue;
            ((BonemealableBlock)((Object)Blocks.SEAGRASS)).performBonemeal((ServerLevel)p_40633_, $$4, $$6, $$11);
        }
        p_40632_.shrink(1);
        return true;
    }

    public static void addGrowthParticles(LevelAccessor p_40639_, BlockPos p_40640_, int p_40641_) {
        BlockState $$3 = p_40639_.getBlockState(p_40640_);
        Block block = $$3.getBlock();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock $$4 = (BonemealableBlock)((Object)block);
            BlockPos $$5 = $$4.getParticlePos(p_40640_);
            switch ($$4.getType()) {
                case NEIGHBOR_SPREADER: {
                    ParticleUtils.spawnParticles(p_40639_, $$5, p_40641_ * 3, 3.0, 1.0, false, ParticleTypes.HAPPY_VILLAGER);
                    break;
                }
                case GROWER: {
                    ParticleUtils.spawnParticleInBlock(p_40639_, $$5, p_40641_, ParticleTypes.HAPPY_VILLAGER);
                }
            }
        } else if ($$3.is(Blocks.WATER)) {
            ParticleUtils.spawnParticles(p_40639_, p_40640_, p_40641_ * 3, 3.0, 1.0, false, ParticleTypes.HAPPY_VILLAGER);
        }
    }
}

