/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    public static final int MAX_SHOWN_GRID_ITEMS_X = 4;
    public static final int MAX_SHOWN_GRID_ITEMS_Y = 3;
    public static final int MAX_SHOWN_GRID_ITEMS = 12;
    public static final int OVERFLOWING_MAX_SHOWN_GRID_ITEMS = 11;
    private static final int FULL_BAR_COLOR = ARGB.colorFromFloat(1.0f, 1.0f, 0.33f, 0.33f);
    private static final int BAR_COLOR = ARGB.colorFromFloat(1.0f, 0.44f, 0.53f, 1.0f);
    private static final int TICKS_AFTER_FIRST_THROW = 10;
    private static final int TICKS_BETWEEN_THROWS = 2;
    private static final int TICKS_MAX_THROW_DURATION = 200;
    private final ResourceLocation openFrontModel;
    private final ResourceLocation openBackModel;

    public BundleItem(ResourceLocation p_371455_, ResourceLocation p_371856_, Item.Properties p_150726_) {
        super(p_150726_);
        this.openFrontModel = p_371455_;
        this.openBackModel = p_371856_;
    }

    public static float getFullnessDisplay(ItemStack p_150767_) {
        BundleContents $$1 = p_150767_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.weight().floatValue();
    }

    public ResourceLocation openFrontModel() {
        return this.openFrontModel;
    }

    public ResourceLocation openBackModel() {
        return this.openBackModel;
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack p_150733_, Slot p_150734_, ClickAction p_150735_, Player p_150736_) {
        BundleContents $$4 = p_150733_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$4 == null) {
            return false;
        }
        ItemStack $$5 = p_150734_.getItem();
        BundleContents.Mutable $$6 = new BundleContents.Mutable($$4);
        if (p_150735_ == ClickAction.PRIMARY && !$$5.isEmpty()) {
            if ($$6.tryTransfer(p_150734_, p_150736_) > 0) {
                BundleItem.playInsertSound(p_150736_);
            } else {
                BundleItem.playInsertFailSound(p_150736_);
            }
            p_150733_.set(DataComponents.BUNDLE_CONTENTS, $$6.toImmutable());
            this.broadcastChangesOnContainerMenu(p_150736_);
            return true;
        }
        if (p_150735_ == ClickAction.SECONDARY && $$5.isEmpty()) {
            ItemStack $$7 = $$6.removeOne();
            if ($$7 != null) {
                ItemStack $$8 = p_150734_.safeInsert($$7);
                if ($$8.getCount() > 0) {
                    $$6.tryInsert($$8);
                } else {
                    BundleItem.playRemoveOneSound(p_150736_);
                }
            }
            p_150733_.set(DataComponents.BUNDLE_CONTENTS, $$6.toImmutable());
            this.broadcastChangesOnContainerMenu(p_150736_);
            return true;
        }
        return false;
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack p_150742_, ItemStack p_150743_, Slot p_150744_, ClickAction p_150745_, Player p_150746_, SlotAccess p_150747_) {
        if (p_150745_ == ClickAction.PRIMARY && p_150743_.isEmpty()) {
            BundleItem.toggleSelectedItem(p_150742_, -1);
            return false;
        }
        BundleContents $$6 = p_150742_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$6 == null) {
            return false;
        }
        BundleContents.Mutable $$7 = new BundleContents.Mutable($$6);
        if (p_150745_ == ClickAction.PRIMARY && !p_150743_.isEmpty()) {
            if (p_150744_.allowModification(p_150746_) && $$7.tryInsert(p_150743_) > 0) {
                BundleItem.playInsertSound(p_150746_);
            } else {
                BundleItem.playInsertFailSound(p_150746_);
            }
            p_150742_.set(DataComponents.BUNDLE_CONTENTS, $$7.toImmutable());
            this.broadcastChangesOnContainerMenu(p_150746_);
            return true;
        }
        if (p_150745_ == ClickAction.SECONDARY && p_150743_.isEmpty()) {
            ItemStack $$8;
            if (p_150744_.allowModification(p_150746_) && ($$8 = $$7.removeOne()) != null) {
                BundleItem.playRemoveOneSound(p_150746_);
                p_150747_.set($$8);
            }
            p_150742_.set(DataComponents.BUNDLE_CONTENTS, $$7.toImmutable());
            this.broadcastChangesOnContainerMenu(p_150746_);
            return true;
        }
        BundleItem.toggleSelectedItem(p_150742_, -1);
        return false;
    }

    @Override
    public InteractionResult use(Level p_150760_, Player p_150761_, InteractionHand p_150762_) {
        if (p_150760_.isClientSide) {
            return InteractionResult.CONSUME;
        }
        p_150761_.startUsingItem(p_150762_);
        return InteractionResult.SUCCESS_SERVER;
    }

    private void dropContent(Level p_380196_, Player p_371609_, ItemStack p_371542_) {
        if (this.dropContent(p_371542_, p_371609_)) {
            BundleItem.playDropContentsSound(p_380196_, p_371609_);
            p_371609_.awardStat(Stats.ITEM_USED.get(this));
        }
    }

    @Override
    public boolean isBarVisible(ItemStack p_150769_) {
        BundleContents $$1 = p_150769_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.weight().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    public int getBarWidth(ItemStack p_150771_) {
        BundleContents $$1 = p_150771_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate($$1.weight(), 12), 13);
    }

    @Override
    public int getBarColor(ItemStack p_150773_) {
        BundleContents $$1 = p_150773_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.weight().compareTo(Fraction.ONE) >= 0 ? FULL_BAR_COLOR : BAR_COLOR;
    }

    public static void toggleSelectedItem(ItemStack p_363912_, int p_363836_) {
        BundleContents $$2 = p_363912_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$2 == null) {
            return;
        }
        BundleContents.Mutable $$3 = new BundleContents.Mutable($$2);
        $$3.toggleSelectedItem(p_363836_);
        p_363912_.set(DataComponents.BUNDLE_CONTENTS, $$3.toImmutable());
    }

    public static boolean hasSelectedItem(ItemStack p_362328_) {
        BundleContents $$1 = p_362328_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.getSelectedItem() != -1;
    }

    public static int getSelectedItem(ItemStack p_362900_) {
        BundleContents $$1 = p_362900_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.getSelectedItem();
    }

    public static ItemStack getSelectedItemStack(ItemStack p_361689_) {
        BundleContents $$1 = p_361689_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.getItemUnsafe($$1.getSelectedItem());
    }

    public static int getNumberOfItemsToShow(ItemStack p_361742_) {
        BundleContents $$1 = p_361742_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.getNumberOfItemsToShow();
    }

    private boolean dropContent(ItemStack p_371437_, Player p_371809_) {
        BundleContents $$2 = p_371437_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$2 == null || $$2.isEmpty()) {
            return false;
        }
        Optional<ItemStack> $$3 = BundleItem.removeOneItemFromBundle(p_371437_, p_371809_, $$2);
        if ($$3.isPresent()) {
            p_371809_.drop($$3.get(), true);
            return true;
        }
        return false;
    }

    private static Optional<ItemStack> removeOneItemFromBundle(ItemStack p_371385_, Player p_371941_, BundleContents p_371197_) {
        BundleContents.Mutable $$3 = new BundleContents.Mutable(p_371197_);
        ItemStack $$4 = $$3.removeOne();
        if ($$4 != null) {
            BundleItem.playRemoveOneSound(p_371941_);
            p_371385_.set(DataComponents.BUNDLE_CONTENTS, $$3.toImmutable());
            return Optional.of($$4);
        }
        return Optional.empty();
    }

    @Override
    public void onUseTick(Level p_371661_, LivingEntity p_371559_, ItemStack p_371431_, int p_371432_) {
        if (!p_371661_.isClientSide && p_371559_ instanceof Player) {
            boolean $$6;
            Player $$4 = (Player)p_371559_;
            int $$5 = this.getUseDuration(p_371431_, p_371559_);
            boolean bl = $$6 = p_371432_ == $$5;
            if ($$6 || p_371432_ < $$5 - 10 && p_371432_ % 2 == 0) {
                this.dropContent(p_371661_, $$4, p_371431_);
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack p_371683_, LivingEntity p_371530_) {
        return 200;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack p_150775_) {
        if (p_150775_.has(DataComponents.HIDE_TOOLTIP) || p_150775_.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        return Optional.ofNullable(p_150775_.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new);
    }

    @Override
    public void onDestroyed(ItemEntity p_150728_) {
        BundleContents $$1 = p_150728_.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if ($$1 == null) {
            return;
        }
        p_150728_.getItem().set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        ItemUtils.onContainerDestroyed(p_150728_, $$1.itemsCopy());
    }

    public static List<BundleItem> getAllBundleItemColors() {
        return Stream.of(Items.BUNDLE, Items.WHITE_BUNDLE, Items.ORANGE_BUNDLE, Items.MAGENTA_BUNDLE, Items.LIGHT_BLUE_BUNDLE, Items.YELLOW_BUNDLE, Items.LIME_BUNDLE, Items.PINK_BUNDLE, Items.GRAY_BUNDLE, Items.LIGHT_GRAY_BUNDLE, Items.CYAN_BUNDLE, Items.BLACK_BUNDLE, Items.BROWN_BUNDLE, Items.GREEN_BUNDLE, Items.RED_BUNDLE, Items.BLUE_BUNDLE, Items.PURPLE_BUNDLE).map(p_381071_ -> (BundleItem)p_381071_).toList();
    }

    public static Item getByColor(DyeColor p_374396_) {
        return switch (p_374396_) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Items.WHITE_BUNDLE;
            case DyeColor.ORANGE -> Items.ORANGE_BUNDLE;
            case DyeColor.MAGENTA -> Items.MAGENTA_BUNDLE;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_BUNDLE;
            case DyeColor.YELLOW -> Items.YELLOW_BUNDLE;
            case DyeColor.LIME -> Items.LIME_BUNDLE;
            case DyeColor.PINK -> Items.PINK_BUNDLE;
            case DyeColor.GRAY -> Items.GRAY_BUNDLE;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_BUNDLE;
            case DyeColor.CYAN -> Items.CYAN_BUNDLE;
            case DyeColor.BLUE -> Items.BLUE_BUNDLE;
            case DyeColor.BROWN -> Items.BROWN_BUNDLE;
            case DyeColor.GREEN -> Items.GREEN_BUNDLE;
            case DyeColor.RED -> Items.RED_BUNDLE;
            case DyeColor.BLACK -> Items.BLACK_BUNDLE;
            case DyeColor.PURPLE -> Items.PURPLE_BUNDLE;
        };
    }

    private static void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + p_186343_.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertSound(Entity p_186352_) {
        p_186352_.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + p_186352_.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertFailSound(Entity p_364546_) {
        p_364546_.playSound(SoundEvents.BUNDLE_INSERT_FAIL, 1.0f, 1.0f);
    }

    private static void playDropContentsSound(Level p_380028_, Entity p_186354_) {
        p_380028_.playSound(null, p_186354_.blockPosition(), SoundEvents.BUNDLE_DROP_CONTENTS, SoundSource.PLAYERS, 0.8f, 0.8f + p_186354_.level().getRandom().nextFloat() * 0.4f);
    }

    private void broadcastChangesOnContainerMenu(Player p_376384_) {
        AbstractContainerMenu $$1 = p_376384_.containerMenu;
        if ($$1 != null) {
            $$1.slotsChanged(p_376384_.getInventory());
        }
    }
}

