/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CrossbowItem
extends ProjectileWeaponItem {
    private static final float MAX_CHARGE_DURATION = 1.25f;
    public static final int DEFAULT_RANGE = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private static final float START_SOUND_PERCENT = 0.2f;
    private static final float MID_SOUND_PERCENT = 0.5f;
    private static final float ARROW_POWER = 3.15f;
    private static final float FIREWORK_POWER = 1.6f;
    public static final float MOB_ARROW_POWER = 1.6f;
    private static final ChargingSounds DEFAULT_SOUNDS = new ChargingSounds(Optional.of(SoundEvents.CROSSBOW_LOADING_START), Optional.of(SoundEvents.CROSSBOW_LOADING_MIDDLE), Optional.of(SoundEvents.CROSSBOW_LOADING_END));

    public CrossbowItem(Item.Properties p_40850_) {
        super(p_40850_);
    }

    @Override
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return ARROW_OR_FIREWORK;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public InteractionResult use(Level p_40920_, Player p_40921_, InteractionHand p_40922_) {
        ItemStack $$3 = p_40921_.getItemInHand(p_40922_);
        ChargedProjectiles $$4 = $$3.get(DataComponents.CHARGED_PROJECTILES);
        if ($$4 != null && !$$4.isEmpty()) {
            this.performShooting(p_40920_, p_40921_, p_40922_, $$3, CrossbowItem.getShootingPower($$4), 1.0f, null);
            return InteractionResult.CONSUME;
        }
        if (!p_40921_.getProjectile($$3).isEmpty()) {
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
            p_40921_.startUsingItem(p_40922_);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private static float getShootingPower(ChargedProjectiles p_330249_) {
        if (p_330249_.contains(Items.FIREWORK_ROCKET)) {
            return 1.6f;
        }
        return 3.15f;
    }

    @Override
    public boolean releaseUsing(ItemStack p_40875_, Level p_40876_, LivingEntity p_40877_, int p_40878_) {
        int $$4 = this.getUseDuration(p_40875_, p_40877_) - p_40878_;
        float $$5 = CrossbowItem.getPowerForTime($$4, p_40875_, p_40877_);
        if ($$5 >= 1.0f && !CrossbowItem.isCharged(p_40875_) && CrossbowItem.tryLoadProjectiles(p_40877_, p_40875_)) {
            ChargingSounds $$6 = this.getChargingSounds(p_40875_);
            $$6.end().ifPresent(p_381568_ -> p_40876_.playSound(null, p_40877_.getX(), p_40877_.getY(), p_40877_.getZ(), (SoundEvent)p_381568_.value(), p_40877_.getSoundSource(), 1.0f, 1.0f / (p_40876_.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
            return true;
        }
        return false;
    }

    private static boolean tryLoadProjectiles(LivingEntity p_40860_, ItemStack p_40861_) {
        List<ItemStack> $$2 = CrossbowItem.draw(p_40861_, p_40860_.getProjectile(p_40861_), p_40860_);
        if (!$$2.isEmpty()) {
            p_40861_.set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.of($$2));
            return true;
        }
        return false;
    }

    public static boolean isCharged(ItemStack p_40933_) {
        ChargedProjectiles $$1 = p_40933_.getOrDefault(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        return !$$1.isEmpty();
    }

    @Override
    protected void shootProjectile(LivingEntity p_40896_, Projectile p_332122_, int p_331865_, float p_40900_, float p_40902_, float p_40903_, @Nullable LivingEntity p_330303_) {
        Vector3f $$15;
        if (p_330303_ != null) {
            double $$7 = p_330303_.getX() - p_40896_.getX();
            double $$8 = p_330303_.getZ() - p_40896_.getZ();
            double $$9 = Math.sqrt($$7 * $$7 + $$8 * $$8);
            double $$10 = p_330303_.getY(0.3333333333333333) - p_332122_.getY() + $$9 * (double)0.2f;
            Vector3f $$11 = CrossbowItem.getProjectileShotVector(p_40896_, new Vec3($$7, $$10, $$8), p_40903_);
        } else {
            Vec3 $$12 = p_40896_.getUpVector(1.0f);
            Quaternionf $$13 = new Quaternionf().setAngleAxis((double)(p_40903_ * ((float)Math.PI / 180)), $$12.x, $$12.y, $$12.z);
            Vec3 $$14 = p_40896_.getViewVector(1.0f);
            $$15 = $$14.toVector3f().rotate((Quaternionfc)$$13);
        }
        p_332122_.shoot($$15.x(), $$15.y(), $$15.z(), p_40900_, p_40902_);
        float $$16 = CrossbowItem.getShotPitch(p_40896_.getRandom(), p_331865_);
        p_40896_.level().playSound(null, p_40896_.getX(), p_40896_.getY(), p_40896_.getZ(), SoundEvents.CROSSBOW_SHOOT, p_40896_.getSoundSource(), 1.0f, $$16);
    }

    private static Vector3f getProjectileShotVector(LivingEntity p_331584_, Vec3 p_331590_, float p_331104_) {
        Vector3f $$3 = p_331590_.toVector3f().normalize();
        Vector3f $$4 = new Vector3f((Vector3fc)$$3).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)$$4.lengthSquared() <= 1.0E-7) {
            Vec3 $$5 = p_331584_.getUpVector(1.0f);
            $$4 = new Vector3f((Vector3fc)$$3).cross((Vector3fc)$$5.toVector3f());
        }
        Vector3f $$6 = new Vector3f((Vector3fc)$$3).rotateAxis(1.5707964f, $$4.x, $$4.y, $$4.z);
        return new Vector3f((Vector3fc)$$3).rotateAxis(p_331104_ * ((float)Math.PI / 180), $$6.x, $$6.y, $$6.z);
    }

    @Override
    protected Projectile createProjectile(Level p_331583_, LivingEntity p_40863_, ItemStack p_40864_, ItemStack p_40865_, boolean p_40866_) {
        if (p_40865_.is(Items.FIREWORK_ROCKET)) {
            return new FireworkRocketEntity(p_331583_, p_40865_, p_40863_, p_40863_.getX(), p_40863_.getEyeY() - (double)0.15f, p_40863_.getZ(), true);
        }
        Projectile $$5 = super.createProjectile(p_331583_, p_40863_, p_40864_, p_40865_, p_40866_);
        if ($$5 instanceof AbstractArrow) {
            AbstractArrow $$6 = (AbstractArrow)$$5;
            $$6.setSoundEvent(SoundEvents.CROSSBOW_HIT);
        }
        return $$5;
    }

    @Override
    protected int getDurabilityUse(ItemStack p_331489_) {
        return p_331489_.is(Items.FIREWORK_ROCKET) ? 3 : 1;
    }

    /*
     * WARNING - void declaration
     */
    public void performShooting(Level p_40888_, LivingEntity p_40889_, InteractionHand p_40890_, ItemStack p_40891_, float p_40892_, float p_40893_, @Nullable LivingEntity p_331602_) {
        void $$8;
        if (!(p_40888_ instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$7 = (ServerLevel)p_40888_;
        ChargedProjectiles $$9 = p_40891_.set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        if ($$9 == null || $$9.isEmpty()) {
            return;
        }
        this.shoot((ServerLevel)$$8, p_40889_, p_40890_, p_40891_, $$9.getItems(), p_40892_, p_40893_, p_40889_ instanceof Player, p_331602_);
        if (p_40889_ instanceof ServerPlayer) {
            ServerPlayer $$10 = (ServerPlayer)p_40889_;
            CriteriaTriggers.SHOT_CROSSBOW.trigger($$10, p_40891_);
            $$10.awardStat(Stats.ITEM_USED.get(p_40891_.getItem()));
        }
    }

    private static float getShotPitch(RandomSource p_331176_, int p_331542_) {
        if (p_331542_ == 0) {
            return 1.0f;
        }
        return CrossbowItem.getRandomShotPitch((p_331542_ & 1) == 1, p_331176_);
    }

    private static float getRandomShotPitch(boolean p_220026_, RandomSource p_220027_) {
        float $$2 = p_220026_ ? 0.63f : 0.43f;
        return 1.0f / (p_220027_.nextFloat() * 0.5f + 1.8f) + $$2;
    }

    @Override
    public void onUseTick(Level p_40910_, LivingEntity p_40911_, ItemStack p_40912_, int p_40913_) {
        if (!p_40910_.isClientSide) {
            ChargingSounds $$4 = this.getChargingSounds(p_40912_);
            float $$5 = (float)(p_40912_.getUseDuration(p_40911_) - p_40913_) / (float)CrossbowItem.getChargeDuration(p_40912_, p_40911_);
            if ($$5 < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if ($$5 >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                $$4.start().ifPresent(p_381565_ -> p_40910_.playSound(null, p_40911_.getX(), p_40911_.getY(), p_40911_.getZ(), (SoundEvent)p_381565_.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
            }
            if ($$5 >= 0.5f && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                $$4.mid().ifPresent(p_381562_ -> p_40910_.playSound(null, p_40911_.getX(), p_40911_.getY(), p_40911_.getZ(), (SoundEvent)p_381562_.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack p_40938_, LivingEntity p_344898_) {
        return CrossbowItem.getChargeDuration(p_40938_, p_344898_) + 3;
    }

    public static int getChargeDuration(ItemStack p_352255_, LivingEntity p_345687_) {
        float $$2 = EnchantmentHelper.modifyCrossbowChargingTime(p_352255_, p_345687_, 1.25f);
        return Mth.floor($$2 * 20.0f);
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack p_40935_) {
        return ItemUseAnimation.CROSSBOW;
    }

    ChargingSounds getChargingSounds(ItemStack p_345050_) {
        return EnchantmentHelper.pickHighestLevel(p_345050_, EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS).orElse(DEFAULT_SOUNDS);
    }

    private static float getPowerForTime(int p_40854_, ItemStack p_40855_, LivingEntity p_344803_) {
        float $$3 = (float)p_40854_ / (float)CrossbowItem.getChargeDuration(p_40855_, p_344803_);
        if ($$3 > 1.0f) {
            $$3 = 1.0f;
        }
        return $$3;
    }

    @Override
    public void appendHoverText(ItemStack p_40880_, Item.TooltipContext p_339686_, List<Component> p_40882_, TooltipFlag p_40883_) {
        ChargedProjectiles $$4 = p_40880_.get(DataComponents.CHARGED_PROJECTILES);
        if ($$4 == null || $$4.isEmpty()) {
            return;
        }
        ItemStack $$5 = $$4.getItems().get(0);
        p_40882_.add(Component.translatable("item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append($$5.getDisplayName()));
        if (p_40883_.isAdvanced() && $$5.is(Items.FIREWORK_ROCKET)) {
            ArrayList $$6 = Lists.newArrayList();
            Items.FIREWORK_ROCKET.appendHoverText($$5, p_339686_, $$6, p_40883_);
            if (!$$6.isEmpty()) {
                for (int $$7 = 0; $$7 < $$6.size(); ++$$7) {
                    $$6.set($$7, Component.literal("  ").append((Component)$$6.get($$7)).withStyle(ChatFormatting.GRAY));
                }
                p_40882_.addAll($$6);
            }
        }
    }

    @Override
    public boolean useOnRelease(ItemStack p_150801_) {
        return p_150801_.is(this);
    }

    @Override
    public int getDefaultProjectileRange() {
        return 8;
    }

    public record ChargingSounds(Optional<Holder<SoundEvent>> start, Optional<Holder<SoundEvent>> mid, Optional<Holder<SoundEvent>> end) {
        public static final Codec<ChargingSounds> CODEC = RecordCodecBuilder.create(p_345672_ -> p_345672_.group((App)SoundEvent.CODEC.optionalFieldOf("start").forGetter(ChargingSounds::start), (App)SoundEvent.CODEC.optionalFieldOf("mid").forGetter(ChargingSounds::mid), (App)SoundEvent.CODEC.optionalFieldOf("end").forGetter(ChargingSounds::end)).apply((Applicative)p_345672_, ChargingSounds::new));
    }
}

