/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireworkRocketItem
extends Item
implements ProjectileItem {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public FireworkRocketItem(Item.Properties p_41209_) {
        super(p_41209_);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_41216_) {
        Level $$1 = p_41216_.getLevel();
        if ($$1 instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)$$1;
            ItemStack $$3 = p_41216_.getItemInHand();
            Vec3 $$4 = p_41216_.getClickLocation();
            Direction $$5 = p_41216_.getClickedFace();
            Projectile.spawnProjectile(new FireworkRocketEntity($$1, p_41216_.getPlayer(), $$4.x + (double)$$5.getStepX() * 0.15, $$4.y + (double)$$5.getStepY() * 0.15, $$4.z + (double)$$5.getStepZ() * 0.15, $$3), $$2, $$3);
            $$3.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level p_41218_, Player p_41219_, InteractionHand p_41220_) {
        if (p_41219_.isFallFlying()) {
            ItemStack $$3 = p_41219_.getItemInHand(p_41220_);
            if (p_41218_ instanceof ServerLevel) {
                ServerLevel $$4 = (ServerLevel)p_41218_;
                Projectile.spawnProjectile(new FireworkRocketEntity(p_41218_, $$3, p_41219_), $$4, $$3);
                $$3.consume(1, p_41219_);
                p_41219_.awardStat(Stats.ITEM_USED.get(this));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void appendHoverText(ItemStack p_41211_, Item.TooltipContext p_339661_, List<Component> p_41213_, TooltipFlag p_41214_) {
        Fireworks $$4 = p_41211_.get(DataComponents.FIREWORKS);
        if ($$4 != null) {
            $$4.addToTooltip(p_339661_, p_41213_::add, p_41214_);
        }
    }

    @Override
    public Projectile asProjectile(Level p_338390_, Position p_338574_, ItemStack p_338487_, Direction p_338368_) {
        return new FireworkRocketEntity(p_338390_, p_338487_.copyWithCount(1), p_338574_.x(), p_338574_.y(), p_338574_.z(), true);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction(FireworkRocketItem::getEntityJustOutsideOfBlockPos).uncertainty(1.0f).power(0.5f).overrideDispenseEvent(1004).build();
    }

    private static Vec3 getEntityJustOutsideOfBlockPos(BlockSource p_371687_, Direction p_371656_) {
        return p_371687_.center().add((double)p_371656_.getStepX() * 0.5000099999997474, (double)p_371656_.getStepY() * 0.5000099999997474, (double)p_371656_.getStepZ() * 0.5000099999997474);
    }
}

