/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private final TagKey<Instrument> instruments;

    public InstrumentItem(TagKey<Instrument> p_220100_, Item.Properties p_220099_) {
        super(p_220099_);
        this.instruments = p_220100_;
    }

    @Override
    public void appendHoverText(ItemStack p_220115_, Item.TooltipContext p_339630_, List<Component> p_220117_, TooltipFlag p_220118_) {
        super.appendHoverText(p_220115_, p_339630_, p_220117_, p_220118_);
        HolderLookup.Provider $$4 = p_339630_.registries();
        if ($$4 == null) {
            return;
        }
        Optional<Holder<Instrument>> $$5 = this.getInstrument(p_220115_, $$4);
        if ($$5.isPresent()) {
            MutableComponent $$6 = $$5.get().value().description().copy();
            ComponentUtils.mergeStyles($$6, Style.EMPTY.withColor(ChatFormatting.GRAY));
            p_220117_.add($$6);
        }
    }

    public static ItemStack create(Item p_220108_, Holder<Instrument> p_220109_) {
        ItemStack $$2 = new ItemStack(p_220108_);
        $$2.set(DataComponents.INSTRUMENT, p_220109_);
        return $$2;
    }

    @Override
    public InteractionResult use(Level p_220123_, Player p_220124_, InteractionHand p_220125_) {
        ItemStack $$3 = p_220124_.getItemInHand(p_220125_);
        Optional<Holder<Instrument>> $$4 = this.getInstrument($$3, p_220124_.registryAccess());
        if ($$4.isPresent()) {
            Instrument $$5 = $$4.get().value();
            p_220124_.startUsingItem(p_220125_);
            InstrumentItem.play(p_220123_, p_220124_, $$5);
            p_220124_.getCooldowns().addCooldown($$3, Mth.floor($$5.useDuration() * 20.0f));
            p_220124_.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public int getUseDuration(ItemStack p_220131_, LivingEntity p_345916_) {
        Optional<Holder<Instrument>> $$2 = this.getInstrument(p_220131_, p_345916_.registryAccess());
        return $$2.map(p_360033_ -> Mth.floor(((Instrument)p_360033_.value()).useDuration() * 20.0f)).orElse(0);
    }

    private Optional<Holder<Instrument>> getInstrument(ItemStack p_220135_, HolderLookup.Provider p_365136_) {
        Iterator $$4;
        Holder<Instrument> $$2 = p_220135_.get(DataComponents.INSTRUMENT);
        if ($$2 != null) {
            return Optional.of($$2);
        }
        Optional<HolderSet.Named<Instrument>> $$3 = p_365136_.lookupOrThrow(Registries.INSTRUMENT).get(this.instruments);
        if ($$3.isPresent() && ($$4 = $$3.get().iterator()).hasNext()) {
            return Optional.of($$4.next());
        }
        return Optional.empty();
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack p_220133_) {
        return ItemUseAnimation.TOOT_HORN;
    }

    private static void play(Level p_220127_, Player p_220128_, Instrument p_220129_) {
        SoundEvent $$3 = p_220129_.soundEvent().value();
        float $$4 = p_220129_.range() / 16.0f;
        p_220127_.playSound(p_220128_, p_220128_, $$3, SoundSource.RECORDS, $$4, 1.0f);
        p_220127_.gameEvent(GameEvent.INSTRUMENT_PLAY, p_220128_.position(), GameEvent.Context.of(p_220128_));
    }
}

