/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.UseCooldown;

public class ItemCooldowns {
    private final Map<ResourceLocation, CooldownInstance> cooldowns = Maps.newHashMap();
    private int tickCount;

    public boolean isOnCooldown(ItemStack p_366432_) {
        return this.getCooldownPercent(p_366432_, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(ItemStack p_366443_, float p_41523_) {
        ResourceLocation $$2 = this.getCooldownGroup(p_366443_);
        CooldownInstance $$3 = this.cooldowns.get($$2);
        if ($$3 != null) {
            float $$4 = $$3.endTime - $$3.startTime;
            float $$5 = (float)$$3.endTime - ((float)this.tickCount + p_41523_);
            return Mth.clamp($$5 / $$4, 0.0f, 1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<ResourceLocation, CooldownInstance>> $$0 = this.cooldowns.entrySet().iterator();
            while ($$0.hasNext()) {
                Map.Entry<ResourceLocation, CooldownInstance> $$1 = $$0.next();
                if ($$1.getValue().endTime > this.tickCount) continue;
                $$0.remove();
                this.onCooldownEnded($$1.getKey());
            }
        }
    }

    public ResourceLocation getCooldownGroup(ItemStack p_366444_) {
        UseCooldown $$1 = p_366444_.get(DataComponents.USE_COOLDOWN);
        ResourceLocation $$2 = BuiltInRegistries.ITEM.getKey(p_366444_.getItem());
        if ($$1 == null) {
            return $$2;
        }
        return $$1.cooldownGroup().orElse($$2);
    }

    public void addCooldown(ItemStack p_366762_, int p_41526_) {
        this.addCooldown(this.getCooldownGroup(p_366762_), p_41526_);
    }

    public void addCooldown(ResourceLocation p_366429_, int p_366819_) {
        this.cooldowns.put(p_366429_, new CooldownInstance(this.tickCount, this.tickCount + p_366819_));
        this.onCooldownStarted(p_366429_, p_366819_);
    }

    public void removeCooldown(ResourceLocation p_366803_) {
        this.cooldowns.remove(p_366803_);
        this.onCooldownEnded(p_366803_);
    }

    protected void onCooldownStarted(ResourceLocation p_366622_, int p_41530_) {
    }

    protected void onCooldownEnded(ResourceLocation p_366721_) {
    }

    record CooldownInstance(int startTime, int endTime) {
    }
}

