/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapItem
extends Item {
    public static final int IMAGE_WIDTH = 128;
    public static final int IMAGE_HEIGHT = 128;

    public MapItem(Item.Properties p_42847_) {
        super(p_42847_);
    }

    public static ItemStack create(Level p_42887_, int p_42888_, int p_42889_, byte p_42890_, boolean p_42891_, boolean p_42892_) {
        ItemStack $$6 = new ItemStack(Items.FILLED_MAP);
        MapId $$7 = MapItem.createNewSavedData(p_42887_, p_42888_, p_42889_, p_42890_, p_42891_, p_42892_, p_42887_.dimension());
        $$6.set(DataComponents.MAP_ID, $$7);
        return $$6;
    }

    @Nullable
    public static MapItemSavedData getSavedData(@Nullable MapId p_324036_, Level p_151130_) {
        return p_324036_ == null ? null : p_151130_.getMapData(p_324036_);
    }

    @Nullable
    public static MapItemSavedData getSavedData(ItemStack p_42854_, Level p_42855_) {
        MapId $$2 = p_42854_.get(DataComponents.MAP_ID);
        return MapItem.getSavedData($$2, p_42855_);
    }

    private static MapId createNewSavedData(Level p_151121_, int p_151122_, int p_151123_, int p_151124_, boolean p_151125_, boolean p_151126_, ResourceKey<Level> p_151127_) {
        MapItemSavedData $$7 = MapItemSavedData.createFresh(p_151122_, p_151123_, (byte)p_151124_, p_151125_, p_151126_, p_151127_);
        MapId $$8 = p_151121_.getFreeMapId();
        p_151121_.setMapData($$8, $$7);
        return $$8;
    }

    public void update(Level p_42894_, Entity p_42895_, MapItemSavedData p_42896_) {
        if (p_42894_.dimension() != p_42896_.dimension || !(p_42895_ instanceof Player)) {
            return;
        }
        int $$3 = 1 << p_42896_.scale;
        int $$4 = p_42896_.centerX;
        int $$5 = p_42896_.centerZ;
        int $$6 = Mth.floor(p_42895_.getX() - (double)$$4) / $$3 + 64;
        int $$7 = Mth.floor(p_42895_.getZ() - (double)$$5) / $$3 + 64;
        int $$8 = 128 / $$3;
        if (p_42894_.dimensionType().hasCeiling()) {
            $$8 /= 2;
        }
        MapItemSavedData.HoldingPlayer $$9 = p_42896_.getHoldingPlayer((Player)p_42895_);
        ++$$9.step;
        BlockPos.MutableBlockPos $$10 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos $$11 = new BlockPos.MutableBlockPos();
        boolean $$12 = false;
        for (int $$13 = $$6 - $$8 + 1; $$13 < $$6 + $$8; ++$$13) {
            if (($$13 & 0xF) != ($$9.step & 0xF) && !$$12) continue;
            $$12 = false;
            double $$14 = 0.0;
            for (int $$15 = $$7 - $$8 - 1; $$15 < $$7 + $$8; ++$$15) {
                MapColor.Brightness $$40;
                if ($$13 < 0 || $$15 < -1 || $$13 >= 128 || $$15 >= 128) continue;
                int $$16 = Mth.square($$13 - $$6) + Mth.square($$15 - $$7);
                boolean $$17 = $$16 > ($$8 - 2) * ($$8 - 2);
                int $$18 = ($$4 / $$3 + $$13 - 64) * $$3;
                int $$19 = ($$5 / $$3 + $$15 - 64) * $$3;
                LinkedHashMultiset $$20 = LinkedHashMultiset.create();
                LevelChunk $$21 = p_42894_.getChunk(SectionPos.blockToSectionCoord($$18), SectionPos.blockToSectionCoord($$19));
                if ($$21.isEmpty()) continue;
                int $$22 = 0;
                double $$23 = 0.0;
                if (p_42894_.dimensionType().hasCeiling()) {
                    int $$24 = $$18 + $$19 * 231871;
                    if ((($$24 = $$24 * $$24 * 31287121 + $$24 * 11) >> 20 & 1) == 0) {
                        $$20.add((Object)Blocks.DIRT.defaultBlockState().getMapColor(p_42894_, BlockPos.ZERO), 10);
                    } else {
                        $$20.add((Object)Blocks.STONE.defaultBlockState().getMapColor(p_42894_, BlockPos.ZERO), 100);
                    }
                    $$23 = 100.0;
                } else {
                    for (int $$25 = 0; $$25 < $$3; ++$$25) {
                        for (int $$26 = 0; $$26 < $$3; ++$$26) {
                            BlockState $$31;
                            $$10.set($$18 + $$25, 0, $$19 + $$26);
                            int $$27 = $$21.getHeight(Heightmap.Types.WORLD_SURFACE, $$10.getX(), $$10.getZ()) + 1;
                            if ($$27 > p_42894_.getMinY() + 1) {
                                BlockState $$28;
                                do {
                                    $$10.setY(--$$27);
                                } while (($$28 = $$21.getBlockState($$10)).getMapColor(p_42894_, $$10) == MapColor.NONE && $$27 > p_42894_.getMinY());
                                if ($$27 > p_42894_.getMinY() && !$$28.getFluidState().isEmpty()) {
                                    BlockState $$30;
                                    int $$29 = $$27 - 1;
                                    $$11.set($$10);
                                    do {
                                        $$11.setY($$29--);
                                        $$30 = $$21.getBlockState($$11);
                                        ++$$22;
                                    } while ($$29 > p_42894_.getMinY() && !$$30.getFluidState().isEmpty());
                                    $$28 = this.getCorrectStateForFluidBlock(p_42894_, $$28, $$10);
                                }
                            } else {
                                $$31 = Blocks.BEDROCK.defaultBlockState();
                            }
                            p_42896_.checkBanners(p_42894_, $$10.getX(), $$10.getZ());
                            $$23 += (double)$$27 / (double)($$3 * $$3);
                            $$20.add((Object)$$31.getMapColor(p_42894_, $$10));
                        }
                    }
                }
                $$22 /= $$3 * $$3;
                MapColor $$32 = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)$$20), (Object)MapColor.NONE);
                if ($$32 == MapColor.WATER) {
                    double $$33 = (double)$$22 * 0.1 + (double)($$13 + $$15 & 1) * 0.2;
                    if ($$33 < 0.5) {
                        MapColor.Brightness $$34 = MapColor.Brightness.HIGH;
                    } else if ($$33 > 0.9) {
                        MapColor.Brightness $$35 = MapColor.Brightness.LOW;
                    } else {
                        MapColor.Brightness $$36 = MapColor.Brightness.NORMAL;
                    }
                } else {
                    double $$37 = ($$23 - $$14) * 4.0 / (double)($$3 + 4) + ((double)($$13 + $$15 & 1) - 0.5) * 0.4;
                    if ($$37 > 0.6) {
                        MapColor.Brightness $$38 = MapColor.Brightness.HIGH;
                    } else if ($$37 < -0.6) {
                        MapColor.Brightness $$39 = MapColor.Brightness.LOW;
                    } else {
                        $$40 = MapColor.Brightness.NORMAL;
                    }
                }
                $$14 = $$23;
                if ($$15 < 0 || $$16 >= $$8 * $$8 || $$17 && ($$13 + $$15 & 1) == 0) continue;
                $$12 |= p_42896_.updateColor($$13, $$15, $$32.getPackedId($$40));
            }
        }
    }

    private BlockState getCorrectStateForFluidBlock(Level p_42901_, BlockState p_42902_, BlockPos p_42903_) {
        FluidState $$3 = p_42902_.getFluidState();
        if (!$$3.isEmpty() && !p_42902_.isFaceSturdy(p_42901_, p_42903_, Direction.UP)) {
            return $$3.createLegacyBlock();
        }
        return p_42902_;
    }

    private static boolean isBiomeWatery(boolean[] p_212252_, int p_212253_, int p_212254_) {
        return p_212252_[p_212254_ * 128 + p_212253_];
    }

    public static void renderBiomePreviewMap(ServerLevel p_42851_, ItemStack p_42852_) {
        MapItemSavedData $$2 = MapItem.getSavedData(p_42852_, (Level)p_42851_);
        if ($$2 == null) {
            return;
        }
        if (p_42851_.dimension() != $$2.dimension) {
            return;
        }
        int $$3 = 1 << $$2.scale;
        int $$4 = $$2.centerX;
        int $$5 = $$2.centerZ;
        boolean[] $$6 = new boolean[16384];
        int $$7 = $$4 / $$3 - 64;
        int $$8 = $$5 / $$3 - 64;
        BlockPos.MutableBlockPos $$9 = new BlockPos.MutableBlockPos();
        for (int $$10 = 0; $$10 < 128; ++$$10) {
            for (int $$11 = 0; $$11 < 128; ++$$11) {
                Holder<Biome> $$12 = p_42851_.getBiome($$9.set(($$7 + $$11) * $$3, 0, ($$8 + $$10) * $$3));
                $$6[$$10 * 128 + $$11] = $$12.is(BiomeTags.WATER_ON_MAP_OUTLINES);
            }
        }
        for (int $$13 = 1; $$13 < 127; ++$$13) {
            for (int $$14 = 1; $$14 < 127; ++$$14) {
                int $$15 = 0;
                for (int $$16 = -1; $$16 < 2; ++$$16) {
                    for (int $$17 = -1; $$17 < 2; ++$$17) {
                        if ($$16 == 0 && $$17 == 0 || !MapItem.isBiomeWatery($$6, $$13 + $$16, $$14 + $$17)) continue;
                        ++$$15;
                    }
                }
                MapColor.Brightness $$18 = MapColor.Brightness.LOWEST;
                MapColor $$19 = MapColor.NONE;
                if (MapItem.isBiomeWatery($$6, $$13, $$14)) {
                    $$19 = MapColor.COLOR_ORANGE;
                    if ($$15 > 7 && $$14 % 2 == 0) {
                        switch (($$13 + (int)(Mth.sin((float)$$14 + 0.0f) * 7.0f)) / 8 % 5) {
                            case 0: 
                            case 4: {
                                $$18 = MapColor.Brightness.LOW;
                                break;
                            }
                            case 1: 
                            case 3: {
                                $$18 = MapColor.Brightness.NORMAL;
                                break;
                            }
                            case 2: {
                                $$18 = MapColor.Brightness.HIGH;
                            }
                        }
                    } else if ($$15 > 7) {
                        $$19 = MapColor.NONE;
                    } else if ($$15 > 5) {
                        $$18 = MapColor.Brightness.NORMAL;
                    } else if ($$15 > 3) {
                        $$18 = MapColor.Brightness.LOW;
                    } else if ($$15 > 1) {
                        $$18 = MapColor.Brightness.LOW;
                    }
                } else if ($$15 > 0) {
                    $$19 = MapColor.COLOR_BROWN;
                    $$18 = $$15 > 3 ? MapColor.Brightness.NORMAL : MapColor.Brightness.LOWEST;
                }
                if ($$19 == MapColor.NONE) continue;
                $$2.setColor($$13, $$14, $$19.getPackedId($$18));
            }
        }
    }

    @Override
    public void inventoryTick(ItemStack p_42870_, Level p_42871_, Entity p_42872_, int p_42873_, boolean p_42874_) {
        if (p_42871_.isClientSide) {
            return;
        }
        MapItemSavedData $$5 = MapItem.getSavedData(p_42870_, p_42871_);
        if ($$5 == null) {
            return;
        }
        if (p_42872_ instanceof Player) {
            Player $$6 = (Player)p_42872_;
            $$5.tickCarriedBy($$6, p_42870_);
        }
        if (!$$5.locked && (p_42874_ || p_42872_ instanceof Player && ((Player)p_42872_).getOffhandItem() == p_42870_)) {
            this.update(p_42871_, p_42872_, $$5);
        }
    }

    @Override
    public void onCraftedPostProcess(ItemStack p_42913_, Level p_42914_) {
        MapPostProcessing $$2 = p_42913_.remove(DataComponents.MAP_POST_PROCESSING);
        if ($$2 == null) {
            return;
        }
        switch ($$2) {
            case LOCK: {
                MapItem.lockMap(p_42914_, p_42913_);
                break;
            }
            case SCALE: {
                MapItem.scaleMap(p_42913_, p_42914_);
            }
        }
    }

    private static void scaleMap(ItemStack p_42857_, Level p_42858_) {
        MapItemSavedData $$2 = MapItem.getSavedData(p_42857_, p_42858_);
        if ($$2 != null) {
            MapId $$3 = p_42858_.getFreeMapId();
            p_42858_.setMapData($$3, $$2.scaled());
            p_42857_.set(DataComponents.MAP_ID, $$3);
        }
    }

    public static void lockMap(Level p_42898_, ItemStack p_42899_) {
        MapItemSavedData $$2 = MapItem.getSavedData(p_42899_, p_42898_);
        if ($$2 != null) {
            MapId $$3 = p_42898_.getFreeMapId();
            MapItemSavedData $$4 = $$2.locked();
            p_42898_.setMapData($$3, $$4);
            p_42899_.set(DataComponents.MAP_ID, $$3);
        }
    }

    @Override
    public void appendHoverText(ItemStack p_42880_, Item.TooltipContext p_339653_, List<Component> p_42882_, TooltipFlag p_42883_) {
        MapId $$4 = p_42880_.get(DataComponents.MAP_ID);
        MapItemSavedData $$5 = $$4 != null ? p_339653_.mapData($$4) : null;
        MapPostProcessing $$6 = p_42880_.get(DataComponents.MAP_POST_PROCESSING);
        if ($$5 != null && ($$5.locked || $$6 == MapPostProcessing.LOCK)) {
            p_42882_.add(Component.translatable("filled_map.locked", $$4.id()).withStyle(ChatFormatting.GRAY));
        }
        if (p_42883_.isAdvanced()) {
            if ($$5 != null) {
                if ($$6 == null) {
                    p_42882_.add(MapItem.getTooltipForId($$4));
                }
                byte $$7 = $$6 == MapPostProcessing.SCALE ? (byte)1 : 0;
                int $$8 = Math.min($$5.scale + $$7, 4);
                p_42882_.add(Component.translatable("filled_map.scale", 1 << $$8).withStyle(ChatFormatting.GRAY));
                p_42882_.add(Component.translatable("filled_map.level", $$8, 4).withStyle(ChatFormatting.GRAY));
            } else {
                p_42882_.add(Component.translatable("filled_map.unknown").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public static Component getTooltipForId(MapId p_323616_) {
        return Component.translatable("filled_map.id", p_323616_.id()).withStyle(ChatFormatting.GRAY);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_42885_) {
        BlockState $$1 = p_42885_.getLevel().getBlockState(p_42885_.getClickedPos());
        if ($$1.is(BlockTags.BANNERS)) {
            MapItemSavedData $$2;
            if (!p_42885_.getLevel().isClientSide && ($$2 = MapItem.getSavedData(p_42885_.getItemInHand(), p_42885_.getLevel())) != null && !$$2.toggleBanner(p_42885_.getLevel(), p_42885_.getClickedPos())) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(p_42885_);
    }
}

