/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

public class MobBucketItem
extends BucketItem {
    private static final MapCodec<TropicalFish.Variant> VARIANT_FIELD_CODEC = TropicalFish.Variant.CODEC.fieldOf("BucketVariantTag");
    private final EntityType<?> type;
    private final SoundEvent emptySound;

    public MobBucketItem(EntityType<?> p_151137_, Fluid p_151138_, SoundEvent p_151139_, Item.Properties p_151140_) {
        super(p_151138_, p_151140_);
        this.type = p_151137_;
        this.emptySound = p_151139_;
    }

    @Override
    public void checkExtraContent(@Nullable Player p_151146_, Level p_151147_, ItemStack p_151148_, BlockPos p_151149_) {
        if (p_151147_ instanceof ServerLevel) {
            this.spawn((ServerLevel)p_151147_, p_151148_, p_151149_);
            p_151147_.gameEvent((Entity)p_151146_, GameEvent.ENTITY_PLACE, p_151149_);
        }
    }

    @Override
    protected void playEmptySound(@Nullable Player p_151151_, LevelAccessor p_151152_, BlockPos p_151153_) {
        p_151152_.playSound(p_151151_, p_151153_, this.emptySound, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(ServerLevel p_151142_, ItemStack p_151143_, BlockPos p_151144_) {
        Object $$3 = this.type.create(p_151142_, EntityType.createDefaultStackConfig(p_151142_, p_151143_, null), p_151144_, EntitySpawnReason.BUCKET, true, false);
        if ($$3 instanceof Bucketable) {
            Bucketable $$4 = (Bucketable)$$3;
            CustomData $$5 = p_151143_.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, CustomData.EMPTY);
            $$4.loadFromBucketTag($$5.copyTag());
            $$4.setFromBucket(true);
        }
        if ($$3 != null) {
            p_151142_.addFreshEntityWithPassengers((Entity)$$3);
        }
    }

    @Override
    public void appendHoverText(ItemStack p_151155_, Item.TooltipContext p_339675_, List<Component> p_151157_, TooltipFlag p_151158_) {
        if (this.type == EntityType.TROPICAL_FISH) {
            CustomData $$4 = p_151155_.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, CustomData.EMPTY);
            if ($$4.isEmpty()) {
                return;
            }
            Optional $$5 = $$4.read(VARIANT_FIELD_CODEC).result();
            if ($$5.isPresent()) {
                TropicalFish.Variant $$6 = (TropicalFish.Variant)$$5.get();
                ChatFormatting[] $$7 = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
                String $$8 = "color.minecraft." + String.valueOf($$6.baseColor());
                String $$9 = "color.minecraft." + String.valueOf($$6.patternColor());
                int $$10 = TropicalFish.COMMON_VARIANTS.indexOf($$6);
                if ($$10 != -1) {
                    p_151157_.add(Component.translatable(TropicalFish.getPredefinedName($$10)).withStyle($$7));
                    return;
                }
                p_151157_.add($$6.pattern().displayName().plainCopy().withStyle($$7));
                MutableComponent $$11 = Component.translatable($$8);
                if (!$$8.equals($$9)) {
                    $$11.append(", ").append(Component.translatable($$9));
                }
                $$11.withStyle($$7);
                p_151157_.add($$11);
            }
        }
    }
}

