/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public final class BundleContents
implements TooltipComponent {
    public static final BundleContents EMPTY = new BundleContents(List.of());
    public static final Codec<BundleContents> CODEC = ItemStack.CODEC.listOf().flatXmap(BundleContents::checkAndCreate, p_381696_ -> DataResult.success(p_381696_.items));
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(BundleContents::new, p_331551_ -> p_331551_.items);
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction((int)1, (int)16);
    private static final int NO_STACK_INDEX = -1;
    public static final int NO_SELECTED_ITEM_INDEX = -1;
    final List<ItemStack> items;
    final Fraction weight;
    final int selectedItem;

    BundleContents(List<ItemStack> p_331277_, Fraction p_339622_, int p_361490_) {
        this.items = p_331277_;
        this.weight = p_339622_;
        this.selectedItem = p_361490_;
    }

    private static DataResult<BundleContents> checkAndCreate(List<ItemStack> p_381706_) {
        try {
            Fraction $$1 = BundleContents.computeContentWeight(p_381706_);
            return DataResult.success((Object)new BundleContents(p_381706_, $$1, -1));
        }
        catch (ArithmeticException $$2) {
            return DataResult.error(() -> "Excessive total bundle weight");
        }
    }

    public BundleContents(List<ItemStack> p_331417_) {
        this(p_331417_, BundleContents.computeContentWeight(p_331417_), -1);
    }

    private static Fraction computeContentWeight(List<ItemStack> p_331148_) {
        Fraction $$1 = Fraction.ZERO;
        for (ItemStack $$2 : p_331148_) {
            $$1 = $$1.add(BundleContents.getWeight($$2).multiplyBy(Fraction.getFraction((int)$$2.getCount(), (int)1)));
        }
        return $$1;
    }

    static Fraction getWeight(ItemStack p_332084_) {
        BundleContents $$1 = p_332084_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$1 != null) {
            return BUNDLE_IN_BUNDLE_WEIGHT.add($$1.weight());
        }
        List $$2 = p_332084_.getOrDefault(DataComponents.BEES, List.of());
        if (!$$2.isEmpty()) {
            return Fraction.ONE;
        }
        return Fraction.getFraction((int)1, (int)p_332084_.getMaxStackSize());
    }

    public static boolean canItemBeInBundle(ItemStack p_362945_) {
        return !p_362945_.isEmpty() && p_362945_.getItem().canFitInsideContainerItems();
    }

    public int getNumberOfItemsToShow() {
        int $$0 = this.size();
        int $$1 = $$0 > 12 ? 11 : 12;
        int $$2 = $$0 % 4;
        int $$3 = $$2 == 0 ? 0 : 4 - $$2;
        return Math.min($$0, $$1 - $$3);
    }

    public ItemStack getItemUnsafe(int p_330802_) {
        return this.items.get(p_330802_);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public boolean hasSelectedItem() {
        return this.selectedItem != -1;
    }

    public boolean equals(Object p_331898_) {
        if (this == p_331898_) {
            return true;
        }
        if (p_331898_ instanceof BundleContents) {
            BundleContents $$1 = (BundleContents)p_331898_;
            return this.weight.equals((Object)$$1.weight) && ItemStack.listMatches(this.items, $$1.items);
        }
        return false;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "BundleContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<ItemStack> items;
        private Fraction weight;
        private int selectedItem;

        public Mutable(BundleContents p_332039_) {
            this.items = new ArrayList<ItemStack>(p_332039_.items);
            this.weight = p_332039_.weight;
            this.selectedItem = p_332039_.selectedItem;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            this.selectedItem = -1;
            return this;
        }

        private int findStackIndex(ItemStack p_331941_) {
            if (!p_331941_.isStackable()) {
                return -1;
            }
            for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
                if (!ItemStack.isSameItemSameComponents(this.items.get($$1), p_331941_)) continue;
                return $$1;
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack p_330527_) {
            Fraction $$1 = Fraction.ONE.subtract(this.weight);
            return Math.max($$1.divideBy(BundleContents.getWeight(p_330527_)).intValue(), 0);
        }

        public int tryInsert(ItemStack p_331789_) {
            if (!BundleContents.canItemBeInBundle(p_331789_)) {
                return 0;
            }
            int $$1 = Math.min(p_331789_.getCount(), this.getMaxAmountToAdd(p_331789_));
            if ($$1 == 0) {
                return 0;
            }
            this.weight = this.weight.add(BundleContents.getWeight(p_331789_).multiplyBy(Fraction.getFraction((int)$$1, (int)1)));
            int $$2 = this.findStackIndex(p_331789_);
            if ($$2 != -1) {
                ItemStack $$3 = this.items.remove($$2);
                ItemStack $$4 = $$3.copyWithCount($$3.getCount() + $$1);
                p_331789_.shrink($$1);
                this.items.add(0, $$4);
            } else {
                this.items.add(0, p_331789_.split($$1));
            }
            return $$1;
        }

        public int tryTransfer(Slot p_330834_, Player p_331924_) {
            ItemStack $$2 = p_330834_.getItem();
            int $$3 = this.getMaxAmountToAdd($$2);
            return BundleContents.canItemBeInBundle($$2) ? this.tryInsert(p_330834_.safeTake($$2.getCount(), $$3, p_331924_)) : 0;
        }

        public void toggleSelectedItem(int p_360571_) {
            this.selectedItem = this.selectedItem == p_360571_ || p_360571_ >= this.items.size() ? -1 : p_360571_;
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            int $$0 = this.selectedItem == -1 || this.selectedItem >= this.items.size() ? 0 : this.selectedItem;
            ItemStack $$1 = this.items.remove($$0).copy();
            this.weight = this.weight.subtract(BundleContents.getWeight($$1).multiplyBy(Fraction.getFraction((int)$$1.getCount(), (int)1)));
            this.toggleSelectedItem(-1);
            return $$1;
        }

        public Fraction weight() {
            return this.weight;
        }

        public BundleContents toImmutable() {
            return new BundleContents(List.copyOf(this.items), this.weight, this.selectedItem);
        }
    }
}

