/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;

public class PlacementInfo {
    public static final PlacementInfo NOT_PLACEABLE = new PlacementInfo(List.of(), List.of(), List.of());
    private final List<Ingredient> ingredients;
    private final List<StackedContents.IngredientInfo<Holder<Item>>> unpackedIngredients;
    private final List<Optional<SlotInfo>> slotInfo;

    private PlacementInfo(List<Ingredient> p_364604_, List<StackedContents.IngredientInfo<Holder<Item>>> p_360939_, List<Optional<SlotInfo>> p_379368_) {
        this.ingredients = p_364604_;
        this.unpackedIngredients = p_360939_;
        this.slotInfo = p_379368_;
    }

    public static StackedContents.IngredientInfo<Holder<Item>> ingredientToContents(Ingredient p_379978_) {
        return StackedItemContents.convertIngredientContents(p_379978_.items().stream());
    }

    public static PlacementInfo create(Ingredient p_363622_) {
        if (p_363622_.items().isEmpty()) {
            return NOT_PLACEABLE;
        }
        StackedContents.IngredientInfo<Holder<Item>> $$1 = PlacementInfo.ingredientToContents(p_363622_);
        SlotInfo $$2 = new SlotInfo(0);
        return new PlacementInfo(List.of(p_363622_), List.of($$1), List.of(Optional.of($$2)));
    }

    public static PlacementInfo createFromOptionals(List<Optional<Ingredient>> p_361135_) {
        int $$1 = p_361135_.size();
        ArrayList<Ingredient> $$2 = new ArrayList<Ingredient>($$1);
        ArrayList<StackedContents.IngredientInfo<Holder<Item>>> $$3 = new ArrayList<StackedContents.IngredientInfo<Holder<Item>>>($$1);
        ArrayList<Optional<SlotInfo>> $$4 = new ArrayList<Optional<SlotInfo>>($$1);
        int $$5 = 0;
        for (Optional<Ingredient> $$6 : p_361135_) {
            if ($$6.isPresent()) {
                Ingredient $$7 = $$6.get();
                if ($$7.items().isEmpty()) {
                    return NOT_PLACEABLE;
                }
                $$2.add($$7);
                $$3.add(PlacementInfo.ingredientToContents($$7));
                $$4.add(Optional.of(new SlotInfo($$5++)));
                continue;
            }
            $$4.add(Optional.empty());
        }
        return new PlacementInfo($$2, $$3, $$4);
    }

    public static PlacementInfo create(List<Ingredient> p_364524_) {
        int $$1 = p_364524_.size();
        ArrayList<StackedContents.IngredientInfo<Holder<Item>>> $$2 = new ArrayList<StackedContents.IngredientInfo<Holder<Item>>>($$1);
        ArrayList<Optional<SlotInfo>> $$3 = new ArrayList<Optional<SlotInfo>>($$1);
        for (int $$4 = 0; $$4 < $$1; ++$$4) {
            Ingredient $$5 = p_364524_.get($$4);
            if ($$5.items().isEmpty()) {
                return NOT_PLACEABLE;
            }
            $$2.add(PlacementInfo.ingredientToContents($$5));
            $$3.add(Optional.of(new SlotInfo($$4)));
        }
        return new PlacementInfo(p_364524_, $$2, $$3);
    }

    public List<Optional<SlotInfo>> slotInfo() {
        return this.slotInfo;
    }

    public List<Ingredient> ingredients() {
        return this.ingredients;
    }

    public List<StackedContents.IngredientInfo<Holder<Item>>> unpackedIngredients() {
        return this.unpackedIngredients;
    }

    public boolean isImpossibleToPlace() {
        return this.slotInfo.isEmpty();
    }

    public record SlotInfo(int placerOutputPosition) {
    }
}

