/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class RecipeManager
extends SimplePreparableReloadListener<RecipeMap>
implements RecipeAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, IngredientExtractor> RECIPE_PROPERTY_SETS = Map.of(RecipePropertySet.SMITHING_ADDITION, p_380841_ -> {
        Optional<Object> optional;
        if (p_380841_ instanceof SmithingRecipe) {
            SmithingRecipe $$1 = (SmithingRecipe)p_380841_;
            optional = $$1.additionIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_BASE, p_380848_ -> {
        Optional<Object> optional;
        if (p_380848_ instanceof SmithingRecipe) {
            SmithingRecipe $$1 = (SmithingRecipe)p_380848_;
            optional = $$1.baseIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_TEMPLATE, p_380847_ -> {
        Optional<Object> optional;
        if (p_380847_ instanceof SmithingRecipe) {
            SmithingRecipe $$1 = (SmithingRecipe)p_380847_;
            optional = $$1.templateIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.SMELTING), RecipePropertySet.BLAST_FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.BLASTING), RecipePropertySet.SMOKER_INPUT, RecipeManager.forSingleInput(RecipeType.SMOKING), RecipePropertySet.CAMPFIRE_INPUT, RecipeManager.forSingleInput(RecipeType.CAMPFIRE_COOKING));
    private final HolderLookup.Provider registries;
    private RecipeMap recipes = RecipeMap.EMPTY;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySets = Map.of();
    private SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes = SelectableRecipe.SingleInputSet.empty();
    private List<ServerDisplayInfo> allDisplays = List.of();
    private Map<ResourceKey<Recipe<?>>, List<ServerDisplayInfo>> recipeToDisplay = Map.of();

    public RecipeManager(HolderLookup.Provider p_324137_) {
        this.registries = p_324137_;
    }

    @Override
    protected RecipeMap prepare(ResourceManager p_379845_, ProfilerFiller p_380058_) {
        TreeMap<ResourceLocation, Recipe> $$2 = new TreeMap<ResourceLocation, Recipe>();
        SimpleJsonResourceReloadListener.scanDirectory(p_379845_, Registries.elementsDirPath(Registries.RECIPE), this.registries.createSerializationContext(JsonOps.INSTANCE), Recipe.CODEC, $$2);
        ArrayList $$3 = new ArrayList($$2.size());
        $$2.forEach((p_379232_, p_379233_) -> {
            ResourceKey<Recipe<?>> $$3 = ResourceKey.create(Registries.RECIPE, p_379232_);
            RecipeHolder<Recipe> $$4 = new RecipeHolder<Recipe>($$3, (Recipe)p_379233_);
            $$3.add($$4);
        });
        return RecipeMap.create($$3);
    }

    @Override
    protected void apply(RecipeMap p_380231_, ResourceManager p_44038_, ProfilerFiller p_44039_) {
        this.recipes = p_380231_;
        LOGGER.info("Loaded {} recipes", (Object)p_380231_.values().size());
    }

    public void finalizeRecipeLoading(FeatureFlagSet p_379660_) {
        ArrayList $$1 = new ArrayList();
        List<IngredientCollector> $$2 = RECIPE_PROPERTY_SETS.entrySet().stream().map(p_380840_ -> new IngredientCollector((ResourceKey)p_380840_.getKey(), (IngredientExtractor)p_380840_.getValue())).toList();
        this.recipes.values().forEach(p_380845_ -> {
            Object $$4 = p_380845_.value();
            if (!$$4.isSpecial() && $$4.placementInfo().isImpossibleToPlace()) {
                LOGGER.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)p_380845_.id().location());
                return;
            }
            $$2.forEach(p_380839_ -> p_380839_.accept((Recipe<?>)$$4));
            if ($$4 instanceof StonecutterRecipe) {
                StonecutterRecipe $$5 = (StonecutterRecipe)$$4;
                RecipeHolder $$6 = p_380845_;
                if (RecipeManager.isIngredientEnabled(p_379660_, $$5.input()) && $$5.resultDisplay().isEnabled(p_379660_)) {
                    $$1.add(new SelectableRecipe.SingleInputEntry($$5.input(), new SelectableRecipe($$5.resultDisplay(), Optional.of($$6))));
                }
            }
        });
        this.propertySets = $$2.stream().collect(Collectors.toUnmodifiableMap(p_380846_ -> p_380846_.key, p_380852_ -> p_380852_.asPropertySet(p_379660_)));
        this.stonecutterRecipes = new SelectableRecipe.SingleInputSet($$1);
        this.allDisplays = RecipeManager.unpackRecipeInfo(this.recipes.values(), p_379660_);
        this.recipeToDisplay = this.allDisplays.stream().collect(Collectors.groupingBy(p_379212_ -> p_379212_.parent.id(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<Ingredient> filterDisabled(FeatureFlagSet p_379504_, List<Ingredient> p_379890_) {
        p_379890_.removeIf(p_379230_ -> !RecipeManager.isIngredientEnabled(p_379504_, p_379230_));
        return p_379890_;
    }

    private static boolean isIngredientEnabled(FeatureFlagSet p_379722_, Ingredient p_380390_) {
        return p_380390_.items().stream().allMatch(p_379224_ -> ((Item)p_379224_.value()).isEnabled(p_379722_));
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_345895_, I p_345268_, Level p_346336_, @Nullable ResourceKey<Recipe<?>> p_380176_) {
        RecipeHolder<T> $$4 = p_380176_ != null ? this.byKeyTyped(p_345895_, p_380176_) : null;
        return this.getRecipeFor(p_345895_, p_345268_, p_346336_, $$4);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_220249_, I p_345826_, Level p_220251_, @Nullable RecipeHolder<T> p_346407_) {
        if (p_346407_ != null && p_346407_.value().matches(p_345826_, p_220251_)) {
            return Optional.of(p_346407_);
        }
        return this.getRecipeFor(p_220249_, p_345826_, p_220251_);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_44016_, I p_345492_, Level p_44018_) {
        return this.recipes.getRecipesFor(p_44016_, p_345492_, p_44018_).findFirst();
    }

    public Optional<RecipeHolder<?>> byKey(ResourceKey<Recipe<?>> p_379753_) {
        return Optional.ofNullable(this.recipes.byKey(p_379753_));
    }

    @Nullable
    private <T extends Recipe<?>> RecipeHolder<T> byKeyTyped(RecipeType<T> p_341695_, ResourceKey<Recipe<?>> p_379841_) {
        RecipeHolder<?> $$2 = this.recipes.byKey(p_379841_);
        if ($$2 != null && $$2.value().getType().equals(p_341695_)) {
            return $$2;
        }
        return null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> getSynchronizedItemProperties() {
        return this.propertySets;
    }

    public SelectableRecipe.SingleInputSet<StonecutterRecipe> getSynchronizedStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    @Override
    public RecipePropertySet propertySet(ResourceKey<RecipePropertySet> p_379366_) {
        return this.propertySets.getOrDefault(p_379366_, RecipePropertySet.EMPTY);
    }

    @Override
    public SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.recipes.values();
    }

    @Nullable
    public ServerDisplayInfo getRecipeFromDisplay(RecipeDisplayId p_379566_) {
        return this.allDisplays.get(p_379566_.index());
    }

    public void listDisplaysForRecipe(ResourceKey<Recipe<?>> p_379964_, Consumer<RecipeDisplayEntry> p_379437_) {
        List<ServerDisplayInfo> $$2 = this.recipeToDisplay.get(p_379964_);
        if ($$2 != null) {
            $$2.forEach(p_379228_ -> p_379437_.accept(p_379228_.display));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceKey<Recipe<?>> p_380059_, JsonObject p_44047_, HolderLookup.Provider p_323755_) {
        Recipe $$3 = (Recipe)Recipe.CODEC.parse(p_323755_.createSerializationContext(JsonOps.INSTANCE), (Object)p_44047_).getOrThrow(JsonParseException::new);
        return new RecipeHolder<Recipe>(p_380059_, $$3);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CachedCheck<I, T> createCheck(final RecipeType<T> p_220268_) {
        return new CachedCheck<I, T>(){
            @Nullable
            private ResourceKey<Recipe<?>> lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I p_344742_, ServerLevel p_379891_) {
                RecipeManager $$2 = p_379891_.recipeAccess();
                Optional $$3 = $$2.getRecipeFor(p_220268_, p_344742_, (Level)p_379891_, this.lastRecipe);
                if ($$3.isPresent()) {
                    RecipeHolder $$4 = $$3.get();
                    this.lastRecipe = $$4.id();
                    return Optional.of($$4);
                }
                return Optional.empty();
            }
        };
    }

    private static List<ServerDisplayInfo> unpackRecipeInfo(Iterable<RecipeHolder<?>> p_379538_, FeatureFlagSet p_379868_) {
        ArrayList<ServerDisplayInfo> $$2 = new ArrayList<ServerDisplayInfo>();
        Object2IntOpenHashMap $$3 = new Object2IntOpenHashMap();
        for (RecipeHolder<?> $$4 : p_379538_) {
            Optional<List<Ingredient>> $$9;
            OptionalInt $$7;
            Object $$5 = $$4.value();
            if ($$5.group().isEmpty()) {
                OptionalInt $$6 = OptionalInt.empty();
            } else {
                $$7 = OptionalInt.of($$3.computeIfAbsent((Object)$$5.group(), arg_0 -> RecipeManager.lambda$unpackRecipeInfo$13((Object2IntMap)$$3, arg_0)));
            }
            if ($$5.isSpecial()) {
                Optional $$8 = Optional.empty();
            } else {
                $$9 = Optional.of($$5.placementInfo().ingredients());
            }
            for (RecipeDisplay $$10 : $$5.display()) {
                if (!$$10.isEnabled(p_379868_)) continue;
                int $$11 = $$2.size();
                RecipeDisplayId $$12 = new RecipeDisplayId($$11);
                RecipeDisplayEntry $$13 = new RecipeDisplayEntry($$12, $$10, $$7, $$5.recipeBookCategory(), $$9);
                $$2.add(new ServerDisplayInfo($$13, $$4));
            }
        }
        return $$2;
    }

    private static IngredientExtractor forSingleInput(RecipeType<? extends SingleItemRecipe> p_381108_) {
        return p_380850_ -> {
            Optional<Object> optional;
            if (p_380850_.getType() == p_381108_ && p_380850_ instanceof SingleItemRecipe) {
                SingleItemRecipe $$2 = (SingleItemRecipe)p_380850_;
                optional = Optional.of($$2.input());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }

    private static /* synthetic */ int lambda$unpackRecipeInfo$13(Object2IntMap p_379225_, Object p_379226_) {
        return p_379225_.size();
    }

    public record ServerDisplayInfo(RecipeDisplayEntry display, RecipeHolder<?> parent) {
    }

    @FunctionalInterface
    public static interface IngredientExtractor {
        public Optional<Ingredient> apply(Recipe<?> var1);
    }

    public static class IngredientCollector
    implements Consumer<Recipe<?>> {
        final ResourceKey<RecipePropertySet> key;
        private final IngredientExtractor extractor;
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

        protected IngredientCollector(ResourceKey<RecipePropertySet> p_380992_, IngredientExtractor p_380987_) {
            this.key = p_380992_;
            this.extractor = p_380987_;
        }

        @Override
        public void accept(Recipe<?> p_380946_) {
            this.extractor.apply(p_380946_).ifPresent(this.ingredients::add);
        }

        public RecipePropertySet asPropertySet(FeatureFlagSet p_380941_) {
            return RecipePropertySet.create(RecipeManager.filterDisabled(p_380941_, this.ingredients));
        }

        @Override
        public /* synthetic */ void accept(Object object) {
            this.accept((Recipe)object);
        }
    }

    public static interface CachedCheck<I extends RecipeInput, T extends Recipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, ServerLevel var2);
    }
}

