/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RecipeMap {
    public static final RecipeMap EMPTY = new RecipeMap((Multimap<RecipeType<?>, RecipeHolder<?>>)ImmutableMultimap.of(), Map.of());
    private final Multimap<RecipeType<?>, RecipeHolder<?>> byType;
    private final Map<ResourceKey<Recipe<?>>, RecipeHolder<?>> byKey;

    private RecipeMap(Multimap<RecipeType<?>, RecipeHolder<?>> p_379497_, Map<ResourceKey<Recipe<?>>, RecipeHolder<?>> p_380280_) {
        this.byType = p_379497_;
        this.byKey = p_380280_;
    }

    public static RecipeMap create(Iterable<RecipeHolder<?>> p_379481_) {
        ImmutableMultimap.Builder $$1 = ImmutableMultimap.builder();
        ImmutableMap.Builder $$2 = ImmutableMap.builder();
        for (RecipeHolder<?> $$3 : p_379481_) {
            $$1.put($$3.value().getType(), $$3);
            $$2.put($$3.id(), $$3);
        }
        return new RecipeMap((Multimap<RecipeType<?>, RecipeHolder<?>>)$$1.build(), (Map<ResourceKey<Recipe<?>>, RecipeHolder<?>>)$$2.build());
    }

    public <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> byType(RecipeType<T> p_379772_) {
        return this.byType.get(p_379772_);
    }

    public Collection<RecipeHolder<?>> values() {
        return this.byKey.values();
    }

    @Nullable
    public RecipeHolder<?> byKey(ResourceKey<Recipe<?>> p_380265_) {
        return this.byKey.get(p_380265_);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Stream<RecipeHolder<T>> getRecipesFor(RecipeType<T> p_380402_, I p_379312_, Level p_379663_) {
        if (p_379312_.isEmpty()) {
            return Stream.empty();
        }
        return this.byType(p_380402_).stream().filter(p_380352_ -> p_380352_.value().matches((RecipeInput)p_379312_, p_379663_));
    }
}

