/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class RepairItemRecipe
extends CustomRecipe {
    public RepairItemRecipe(CraftingBookCategory p_248679_) {
        super(p_248679_);
    }

    @Nullable
    private static Pair<ItemStack, ItemStack> getItemsToCombine(CraftingInput p_345543_) {
        if (p_345543_.ingredientCount() != 2) {
            return null;
        }
        ItemStack $$1 = null;
        for (int $$2 = 0; $$2 < p_345543_.size(); ++$$2) {
            ItemStack $$3 = p_345543_.getItem($$2);
            if ($$3.isEmpty()) continue;
            if ($$1 == null) {
                $$1 = $$3;
                continue;
            }
            return RepairItemRecipe.canCombine($$1, $$3) ? Pair.of((Object)$$1, (Object)$$3) : null;
        }
        return null;
    }

    private static boolean canCombine(ItemStack p_336139_, ItemStack p_335795_) {
        return p_335795_.is(p_336139_.getItem()) && p_336139_.getCount() == 1 && p_335795_.getCount() == 1 && p_336139_.has(DataComponents.MAX_DAMAGE) && p_335795_.has(DataComponents.MAX_DAMAGE) && p_336139_.has(DataComponents.DAMAGE) && p_335795_.has(DataComponents.DAMAGE);
    }

    @Override
    public boolean matches(CraftingInput p_345243_, Level p_44139_) {
        return RepairItemRecipe.getItemsToCombine(p_345243_) != null;
    }

    @Override
    public ItemStack assemble(CraftingInput p_346224_, HolderLookup.Provider p_335610_) {
        Pair<ItemStack, ItemStack> $$2 = RepairItemRecipe.getItemsToCombine(p_346224_);
        if ($$2 == null) {
            return ItemStack.EMPTY;
        }
        ItemStack $$3 = (ItemStack)$$2.getFirst();
        ItemStack $$4 = (ItemStack)$$2.getSecond();
        int $$5 = Math.max($$3.getMaxDamage(), $$4.getMaxDamage());
        int $$6 = $$3.getMaxDamage() - $$3.getDamageValue();
        int $$7 = $$4.getMaxDamage() - $$4.getDamageValue();
        int $$8 = $$6 + $$7 + $$5 * 5 / 100;
        ItemStack $$9 = new ItemStack($$3.getItem());
        $$9.set(DataComponents.MAX_DAMAGE, $$5);
        $$9.setDamageValue(Math.max($$5 - $$8, 0));
        ItemEnchantments $$10 = EnchantmentHelper.getEnchantmentsForCrafting($$3);
        ItemEnchantments $$11 = EnchantmentHelper.getEnchantmentsForCrafting($$4);
        EnchantmentHelper.updateEnchantments($$9, p_367961_ -> p_335610_.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(p_344414_ -> p_344414_.is(EnchantmentTags.CURSE)).forEach(p_344418_ -> {
            int $$4 = Math.max($$10.getLevel((Holder<Enchantment>)p_344418_), $$11.getLevel((Holder<Enchantment>)p_344418_));
            if ($$4 > 0) {
                p_367961_.upgrade((Holder<Enchantment>)p_344418_, $$4);
            }
        }));
        return $$9;
    }

    @Override
    public RecipeSerializer<RepairItemRecipe> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

