/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;

public class TransmuteRecipe
implements CraftingRecipe {
    final String group;
    final CraftingBookCategory category;
    final Ingredient input;
    final Ingredient material;
    final Holder<Item> result;
    @Nullable
    private PlacementInfo placementInfo;

    public TransmuteRecipe(String p_374115_, CraftingBookCategory p_374513_, Ingredient p_374507_, Ingredient p_374190_, Holder<Item> p_374204_) {
        this.group = p_374115_;
        this.category = p_374513_;
        this.input = p_374507_;
        this.material = p_374190_;
        this.result = p_374204_;
    }

    @Override
    public boolean matches(CraftingInput p_374402_, Level p_374075_) {
        if (p_374402_.ingredientCount() != 2) {
            return false;
        }
        boolean $$2 = false;
        boolean $$3 = false;
        for (int $$4 = 0; $$4 < p_374402_.size(); ++$$4) {
            ItemStack $$5 = p_374402_.getItem($$4);
            if ($$5.isEmpty()) continue;
            if (!$$2 && this.input.test($$5) && $$5.getItem() != this.result.value()) {
                $$2 = true;
                continue;
            }
            if (!$$3 && this.material.test($$5)) {
                $$3 = true;
                continue;
            }
            return false;
        }
        return $$2 && $$3;
    }

    @Override
    public ItemStack assemble(CraftingInput p_374148_, HolderLookup.Provider p_374579_) {
        ItemStack $$2 = ItemStack.EMPTY;
        for (int $$3 = 0; $$3 < p_374148_.size(); ++$$3) {
            ItemStack $$4 = p_374148_.getItem($$3);
            if ($$4.isEmpty() || !this.input.test($$4) || $$4.getItem() == this.result.value()) continue;
            $$2 = $$4;
        }
        return $$2.transmuteCopy(this.result.value(), 1);
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(List.of(this.input.display(), this.material.display()), new SlotDisplay.ItemSlotDisplay(this.result), new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    @Override
    public RecipeSerializer<TransmuteRecipe> getSerializer() {
        return RecipeSerializer.TRANSMUTE;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(List.of(this.input, this.material));
        }
        return this.placementInfo;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    public static class Serializer
    implements RecipeSerializer<TransmuteRecipe> {
        private static final MapCodec<TransmuteRecipe> CODEC = RecordCodecBuilder.mapCodec(p_381583_ -> p_381583_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_374051_ -> p_374051_.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_374281_ -> p_374281_.category), (App)Ingredient.CODEC.fieldOf("input").forGetter(p_374483_ -> p_374483_.input), (App)Ingredient.CODEC.fieldOf("material").forGetter(p_374399_ -> p_374399_.material), (App)Item.CODEC.fieldOf("result").forGetter(p_374517_ -> p_374517_.result)).apply((Applicative)p_381583_, TransmuteRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TransmuteRecipe> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, p_374373_ -> p_374373_.group, CraftingBookCategory.STREAM_CODEC, p_374482_ -> p_374482_.category, Ingredient.CONTENTS_STREAM_CODEC, p_374160_ -> p_374160_.input, Ingredient.CONTENTS_STREAM_CODEC, p_374370_ -> p_374370_.material, ByteBufCodecs.holderRegistry(Registries.ITEM), p_374224_ -> p_374224_.result, TransmuteRecipe::new);

        @Override
        public MapCodec<TransmuteRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, TransmuteRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

