/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record SummonEntityEffect(HolderSet<EntityType<?>> entityTypes, boolean joinTeam) implements EnchantmentEntityEffect
{
    public static final MapCodec<SummonEntityEffect> CODEC = RecordCodecBuilder.mapCodec(p_345616_ -> p_345616_.group((App)RegistryCodecs.homogeneousList(Registries.ENTITY_TYPE).fieldOf("entity").forGetter(SummonEntityEffect::entityTypes), (App)Codec.BOOL.optionalFieldOf("join_team", (Object)false).forGetter(SummonEntityEffect::joinTeam)).apply((Applicative)p_345616_, SummonEntityEffect::new));

    @Override
    public void apply(ServerLevel p_345900_, int p_346183_, EnchantedItemInUse p_345549_, Entity p_346414_, Vec3 p_346284_) {
        BlockPos $$5 = BlockPos.containing(p_346284_);
        if (!Level.isInSpawnableBounds($$5)) {
            return;
        }
        Optional<Holder<EntityType<?>>> $$6 = this.entityTypes().getRandomElement(p_345900_.getRandom());
        if ($$6.isEmpty()) {
            return;
        }
        Object $$7 = $$6.get().value().spawn(p_345900_, $$5, EntitySpawnReason.TRIGGERED);
        if ($$7 == null) {
            return;
        }
        if ($$7 instanceof LightningBolt) {
            LightningBolt $$8 = (LightningBolt)$$7;
            LivingEntity livingEntity = p_345549_.owner();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer $$9 = (ServerPlayer)livingEntity;
                $$8.setCause($$9);
            }
        }
        if (this.joinTeam && p_346414_.getTeam() != null) {
            p_345900_.getScoreboard().addPlayerToTeam(((Entity)$$7).getScoreboardName(), p_346414_.getTeam());
        }
        ((Entity)$$7).moveTo(p_346284_.x, p_346284_.y, p_346284_.z, ((Entity)$$7).getYRot(), ((Entity)$$7).getXRot());
    }

    public MapCodec<SummonEntityEffect> codec() {
        return CODEC;
    }
}

