/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;

public record ArmorMaterial(int durability, Map<ArmorType, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient, ResourceLocation modelId) {
    public Item.Properties humanoidProperties(Item.Properties p_371701_, ArmorType p_371660_) {
        return p_371701_.durability(p_371660_.getDurability(this.durability)).attributes(this.createAttributes(p_371660_)).enchantable(this.enchantmentValue).component(DataComponents.EQUIPPABLE, Equippable.builder(p_371660_.getSlot()).setEquipSound(this.equipSound).setModel(this.modelId).build()).repairable(this.repairIngredient);
    }

    public Item.Properties animalProperties(Item.Properties p_371435_, HolderSet<EntityType<?>> p_371268_) {
        return p_371435_.durability(ArmorType.BODY.getDurability(this.durability)).attributes(this.createAttributes(ArmorType.BODY)).repairable(this.repairIngredient).component(DataComponents.EQUIPPABLE, Equippable.builder(EquipmentSlot.BODY).setEquipSound(this.equipSound).setModel(this.modelId).setAllowedEntities(p_371268_).build());
    }

    public Item.Properties animalProperties(Item.Properties p_376672_, Holder<SoundEvent> p_381624_, boolean p_380284_, HolderSet<EntityType<?>> p_376684_) {
        if (p_380284_) {
            p_376672_ = p_376672_.durability(ArmorType.BODY.getDurability(this.durability)).repairable(this.repairIngredient);
        }
        return p_376672_.attributes(this.createAttributes(ArmorType.BODY)).component(DataComponents.EQUIPPABLE, Equippable.builder(EquipmentSlot.BODY).setEquipSound(p_381624_).setModel(this.modelId).setAllowedEntities(p_376684_).setDamageOnHurt(p_380284_).build());
    }

    private ItemAttributeModifiers createAttributes(ArmorType p_371239_) {
        int $$1 = this.defense.getOrDefault(p_371239_, 0);
        ItemAttributeModifiers.Builder $$2 = ItemAttributeModifiers.builder();
        EquipmentSlotGroup $$3 = EquipmentSlotGroup.bySlot(p_371239_.getSlot());
        ResourceLocation $$4 = ResourceLocation.withDefaultNamespace("armor." + p_371239_.getName());
        $$2.add(Attributes.ARMOR, new AttributeModifier($$4, $$1, AttributeModifier.Operation.ADD_VALUE), $$3);
        $$2.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier($$4, this.toughness, AttributeModifier.Operation.ADD_VALUE), $$3);
        if (this.knockbackResistance > 0.0f) {
            $$2.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier($$4, this.knockbackResistance, AttributeModifier.Operation.ADD_VALUE), $$3);
        }
        return $$2.build();
    }
}

