/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;

public record EquipmentModel(Map<LayerType, List<Layer>> layers) {
    private static final Codec<List<Layer>> LAYER_LIST_CODEC = ExtraCodecs.nonEmptyList(Layer.CODEC.listOf());
    public static final Codec<EquipmentModel> CODEC = RecordCodecBuilder.create(p_371260_ -> p_371260_.group((App)ExtraCodecs.nonEmptyMap(Codec.unboundedMap(LayerType.CODEC, LAYER_LIST_CODEC)).fieldOf("layers").forGetter(EquipmentModel::layers)).apply((Applicative)p_371260_, EquipmentModel::new));

    public static Builder builder() {
        return new Builder();
    }

    public List<Layer> getLayers(LayerType p_371740_) {
        return this.layers.getOrDefault(p_371740_, List.of());
    }

    public static class Builder {
        private final Map<LayerType, List<Layer>> layersByType = new EnumMap<LayerType, List<Layer>>(LayerType.class);

        Builder() {
        }

        public Builder addHumanoidLayers(ResourceLocation p_371789_) {
            return this.addHumanoidLayers(p_371789_, false);
        }

        public Builder addHumanoidLayers(ResourceLocation p_371704_, boolean p_371440_) {
            this.addLayers(LayerType.HUMANOID_LEGGINGS, Layer.leatherDyeable(p_371704_, p_371440_));
            this.addMainHumanoidLayer(p_371704_, p_371440_);
            return this;
        }

        public Builder addMainHumanoidLayer(ResourceLocation p_371757_, boolean p_371736_) {
            return this.addLayers(LayerType.HUMANOID, Layer.leatherDyeable(p_371757_, p_371736_));
        }

        public Builder addLayers(LayerType p_371486_, Layer ... p_371512_) {
            Collections.addAll(this.layersByType.computeIfAbsent(p_371486_, p_371920_ -> new ArrayList()), p_371512_);
            return this;
        }

        public EquipmentModel build() {
            return new EquipmentModel((Map)this.layersByType.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_371873_ -> List.copyOf((Collection)p_371873_.getValue()))));
        }
    }

    public static enum LayerType implements StringRepresentable
    {
        HUMANOID("humanoid"),
        HUMANOID_LEGGINGS("humanoid_leggings"),
        WINGS("wings"),
        WOLF_BODY("wolf_body"),
        HORSE_BODY("horse_body"),
        LLAMA_BODY("llama_body");

        public static final Codec<LayerType> CODEC;
        private final String id;

        private LayerType(String p_371921_) {
            this.id = p_371921_;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(LayerType::values);
        }
    }

    public record Layer(ResourceLocation textureId, Optional<Dyeable> dyeable, boolean usePlayerTexture) {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create(p_371277_ -> p_371277_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Layer::textureId), (App)Dyeable.CODEC.optionalFieldOf("dyeable").forGetter(Layer::dyeable), (App)Codec.BOOL.optionalFieldOf("use_player_texture", (Object)false).forGetter(Layer::usePlayerTexture)).apply((Applicative)p_371277_, Layer::new));

        public Layer(ResourceLocation p_371199_) {
            this(p_371199_, Optional.empty(), false);
        }

        public static Layer leatherDyeable(ResourceLocation p_371872_, boolean p_371184_) {
            return new Layer(p_371872_, p_371184_ ? Optional.of(new Dyeable(Optional.of(-6265536))) : Optional.empty(), false);
        }

        public static Layer onlyIfDyed(ResourceLocation p_371928_, boolean p_371815_) {
            return new Layer(p_371928_, p_371815_ ? Optional.of(new Dyeable(Optional.empty())) : Optional.empty(), false);
        }

        public ResourceLocation getTextureLocation(LayerType p_371608_) {
            return this.textureId.withPath(p_371553_ -> "textures/entity/equipment/" + p_371608_.getSerializedName() + "/" + p_371553_ + ".png");
        }
    }

    public record Dyeable(Optional<Integer> colorWhenUndyed) {
        public static final Codec<Dyeable> CODEC = RecordCodecBuilder.create(p_371858_ -> p_371858_.group((App)ExtraCodecs.RGB_COLOR_CODEC.optionalFieldOf("color_when_undyed").forGetter(Dyeable::colorWhenUndyed)).apply((Applicative)p_371858_, Dyeable::new));
    }
}

