/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.equipment.EquipmentModel;

public interface EquipmentModels {
    public static final ResourceLocation LEATHER = ResourceLocation.withDefaultNamespace("leather");
    public static final ResourceLocation CHAINMAIL = ResourceLocation.withDefaultNamespace("chainmail");
    public static final ResourceLocation IRON = ResourceLocation.withDefaultNamespace("iron");
    public static final ResourceLocation GOLD = ResourceLocation.withDefaultNamespace("gold");
    public static final ResourceLocation DIAMOND = ResourceLocation.withDefaultNamespace("diamond");
    public static final ResourceLocation TURTLE_SCUTE = ResourceLocation.withDefaultNamespace("turtle_scute");
    public static final ResourceLocation NETHERITE = ResourceLocation.withDefaultNamespace("netherite");
    public static final ResourceLocation ARMADILLO_SCUTE = ResourceLocation.withDefaultNamespace("armadillo_scute");
    public static final ResourceLocation ELYTRA = ResourceLocation.withDefaultNamespace("elytra");
    public static final Map<DyeColor, ResourceLocation> CARPETS = Util.makeEnumMap(DyeColor.class, p_371647_ -> ResourceLocation.withDefaultNamespace(p_371647_.getSerializedName() + "_carpet"));
    public static final ResourceLocation TRADER_LLAMA = ResourceLocation.withDefaultNamespace("trader_llama");

    public static void bootstrap(BiConsumer<ResourceLocation, EquipmentModel> p_371586_) {
        p_371586_.accept(LEATHER, EquipmentModel.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace("leather"), true).addHumanoidLayers(ResourceLocation.withDefaultNamespace("leather_overlay"), false).addLayers(EquipmentModel.LayerType.HORSE_BODY, EquipmentModel.Layer.leatherDyeable(ResourceLocation.withDefaultNamespace("leather"), true)).build());
        p_371586_.accept(CHAINMAIL, EquipmentModels.onlyHumanoid("chainmail"));
        p_371586_.accept(IRON, EquipmentModels.humanoidAndHorse("iron"));
        p_371586_.accept(GOLD, EquipmentModels.humanoidAndHorse("gold"));
        p_371586_.accept(DIAMOND, EquipmentModels.humanoidAndHorse("diamond"));
        p_371586_.accept(TURTLE_SCUTE, EquipmentModel.builder().addMainHumanoidLayer(ResourceLocation.withDefaultNamespace("turtle_scute"), false).build());
        p_371586_.accept(NETHERITE, EquipmentModels.onlyHumanoid("netherite"));
        p_371586_.accept(ARMADILLO_SCUTE, EquipmentModel.builder().addLayers(EquipmentModel.LayerType.WOLF_BODY, EquipmentModel.Layer.onlyIfDyed(ResourceLocation.withDefaultNamespace("armadillo_scute"), false)).addLayers(EquipmentModel.LayerType.WOLF_BODY, EquipmentModel.Layer.onlyIfDyed(ResourceLocation.withDefaultNamespace("armadillo_scute_overlay"), true)).build());
        p_371586_.accept(ELYTRA, EquipmentModel.builder().addLayers(EquipmentModel.LayerType.WINGS, new EquipmentModel.Layer(ResourceLocation.withDefaultNamespace("elytra"), Optional.empty(), true)).build());
        for (Map.Entry<DyeColor, ResourceLocation> $$1 : CARPETS.entrySet()) {
            DyeColor $$2 = $$1.getKey();
            ResourceLocation $$3 = $$1.getValue();
            p_371586_.accept($$3, EquipmentModel.builder().addLayers(EquipmentModel.LayerType.LLAMA_BODY, new EquipmentModel.Layer(ResourceLocation.withDefaultNamespace($$2.getSerializedName()))).build());
        }
        p_371586_.accept(TRADER_LLAMA, EquipmentModel.builder().addLayers(EquipmentModel.LayerType.LLAMA_BODY, new EquipmentModel.Layer(ResourceLocation.withDefaultNamespace("trader_llama"))).build());
    }

    private static EquipmentModel onlyHumanoid(String p_371738_) {
        return EquipmentModel.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace(p_371738_)).build();
    }

    private static EquipmentModel humanoidAndHorse(String p_371340_) {
        return EquipmentModel.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace(p_371340_)).addLayers(EquipmentModel.LayerType.HORSE_BODY, EquipmentModel.Layer.leatherDyeable(ResourceLocation.withDefaultNamespace(p_371340_), false)).build();
    }
}

