/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment.trim;

import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.EquipmentModels;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public class TrimMaterials {
    public static final ResourceKey<TrimMaterial> QUARTZ = TrimMaterials.registryKey("quartz");
    public static final ResourceKey<TrimMaterial> IRON = TrimMaterials.registryKey("iron");
    public static final ResourceKey<TrimMaterial> NETHERITE = TrimMaterials.registryKey("netherite");
    public static final ResourceKey<TrimMaterial> REDSTONE = TrimMaterials.registryKey("redstone");
    public static final ResourceKey<TrimMaterial> COPPER = TrimMaterials.registryKey("copper");
    public static final ResourceKey<TrimMaterial> GOLD = TrimMaterials.registryKey("gold");
    public static final ResourceKey<TrimMaterial> EMERALD = TrimMaterials.registryKey("emerald");
    public static final ResourceKey<TrimMaterial> DIAMOND = TrimMaterials.registryKey("diamond");
    public static final ResourceKey<TrimMaterial> LAPIS = TrimMaterials.registryKey("lapis");
    public static final ResourceKey<TrimMaterial> AMETHYST = TrimMaterials.registryKey("amethyst");

    public static void bootstrap(BootstrapContext<TrimMaterial> p_371627_) {
        TrimMaterials.register(p_371627_, QUARTZ, Items.QUARTZ, Style.EMPTY.withColor(14931140), 0.1f);
        TrimMaterials.register(p_371627_, IRON, Items.IRON_INGOT, Style.EMPTY.withColor(0xECECEC), 0.2f, Map.of(EquipmentModels.IRON, "iron_darker"));
        TrimMaterials.register(p_371627_, NETHERITE, Items.NETHERITE_INGOT, Style.EMPTY.withColor(6445145), 0.3f, Map.of(EquipmentModels.NETHERITE, "netherite_darker"));
        TrimMaterials.register(p_371627_, REDSTONE, Items.REDSTONE, Style.EMPTY.withColor(9901575), 0.4f);
        TrimMaterials.register(p_371627_, COPPER, Items.COPPER_INGOT, Style.EMPTY.withColor(11823181), 0.5f);
        TrimMaterials.register(p_371627_, GOLD, Items.GOLD_INGOT, Style.EMPTY.withColor(14594349), 0.6f, Map.of(EquipmentModels.GOLD, "gold_darker"));
        TrimMaterials.register(p_371627_, EMERALD, Items.EMERALD, Style.EMPTY.withColor(1155126), 0.7f);
        TrimMaterials.register(p_371627_, DIAMOND, Items.DIAMOND, Style.EMPTY.withColor(7269586), 0.8f, Map.of(EquipmentModels.DIAMOND, "diamond_darker"));
        TrimMaterials.register(p_371627_, LAPIS, Items.LAPIS_LAZULI, Style.EMPTY.withColor(4288151), 0.9f);
        TrimMaterials.register(p_371627_, AMETHYST, Items.AMETHYST_SHARD, Style.EMPTY.withColor(10116294), 1.0f);
    }

    public static Optional<Holder.Reference<TrimMaterial>> getFromIngredient(HolderLookup.Provider p_371665_, ItemStack p_371700_) {
        return p_371665_.lookupOrThrow(Registries.TRIM_MATERIAL).listElements().filter(p_371615_ -> p_371700_.is(((TrimMaterial)p_371615_.value()).ingredient())).findFirst();
    }

    private static void register(BootstrapContext<TrimMaterial> p_371763_, ResourceKey<TrimMaterial> p_371867_, Item p_371472_, Style p_371730_, float p_371391_) {
        TrimMaterials.register(p_371763_, p_371867_, p_371472_, p_371730_, p_371391_, Map.of());
    }

    private static void register(BootstrapContext<TrimMaterial> p_371580_, ResourceKey<TrimMaterial> p_371417_, Item p_371230_, Style p_371405_, float p_371879_, Map<ResourceLocation, String> p_371548_) {
        TrimMaterial $$6 = TrimMaterial.create(p_371417_.location().getPath(), p_371230_, p_371879_, Component.translatable(Util.makeDescriptionId("trim_material", p_371417_.location())).withStyle(p_371405_), p_371548_);
        p_371580_.register(p_371417_, $$6);
    }

    private static ResourceKey<TrimMaterial> registryKey(String p_371483_) {
        return ResourceKey.create(Registries.TRIM_MATERIAL, ResourceLocation.withDefaultNamespace(p_371483_));
    }
}

