/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.AbstractIterator;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCollisions<T>
extends AbstractIterator<T> {
    private final AABB box;
    private final CollisionContext context;
    private final Cursor3D cursor;
    private final BlockPos.MutableBlockPos pos;
    private final VoxelShape entityShape;
    private final CollisionGetter collisionGetter;
    private final boolean onlySuffocatingBlocks;
    @Nullable
    private BlockGetter cachedBlockGetter;
    private long cachedBlockGetterPos;
    private final BiFunction<BlockPos.MutableBlockPos, VoxelShape, T> resultProvider;

    public BlockCollisions(CollisionGetter p_286817_, @Nullable Entity p_286246_, AABB p_286624_, boolean p_286354_, BiFunction<BlockPos.MutableBlockPos, VoxelShape, T> p_286303_) {
        this(p_286817_, p_286246_ == null ? CollisionContext.empty() : CollisionContext.of(p_286246_), p_286624_, p_286354_, p_286303_);
    }

    public BlockCollisions(CollisionGetter p_361869_, CollisionContext p_362362_, AABB p_360932_, boolean p_362824_, BiFunction<BlockPos.MutableBlockPos, VoxelShape, T> p_362971_) {
        this.context = p_362362_;
        this.pos = new BlockPos.MutableBlockPos();
        this.entityShape = Shapes.create(p_360932_);
        this.collisionGetter = p_361869_;
        this.box = p_360932_;
        this.onlySuffocatingBlocks = p_362824_;
        this.resultProvider = p_362971_;
        int $$5 = Mth.floor(p_360932_.minX - 1.0E-7) - 1;
        int $$6 = Mth.floor(p_360932_.maxX + 1.0E-7) + 1;
        int $$7 = Mth.floor(p_360932_.minY - 1.0E-7) - 1;
        int $$8 = Mth.floor(p_360932_.maxY + 1.0E-7) + 1;
        int $$9 = Mth.floor(p_360932_.minZ - 1.0E-7) - 1;
        int $$10 = Mth.floor(p_360932_.maxZ + 1.0E-7) + 1;
        this.cursor = new Cursor3D($$5, $$7, $$9, $$6, $$8, $$10);
    }

    @Nullable
    private BlockGetter getChunk(int p_186412_, int p_186413_) {
        BlockGetter $$5;
        int $$2 = SectionPos.blockToSectionCoord(p_186412_);
        int $$3 = SectionPos.blockToSectionCoord(p_186413_);
        long $$4 = ChunkPos.asLong($$2, $$3);
        if (this.cachedBlockGetter != null && this.cachedBlockGetterPos == $$4) {
            return this.cachedBlockGetter;
        }
        this.cachedBlockGetter = $$5 = this.collisionGetter.getChunkForCollisions($$2, $$3);
        this.cachedBlockGetterPos = $$4;
        return $$5;
    }

    protected T computeNext() {
        while (this.cursor.advance()) {
            BlockGetter $$4;
            int $$0 = this.cursor.nextX();
            int $$1 = this.cursor.nextY();
            int $$2 = this.cursor.nextZ();
            int $$3 = this.cursor.getNextType();
            if ($$3 == 3 || ($$4 = this.getChunk($$0, $$2)) == null) continue;
            this.pos.set($$0, $$1, $$2);
            BlockState $$5 = $$4.getBlockState(this.pos);
            if (this.onlySuffocatingBlocks && !$$5.isSuffocating($$4, this.pos) || $$3 == 1 && !$$5.hasLargeCollisionShape() || $$3 == 2 && !$$5.is(Blocks.MOVING_PISTON)) continue;
            VoxelShape $$6 = this.context.getCollisionShape($$5, this.collisionGetter, this.pos);
            if ($$6 == Shapes.block()) {
                if (!this.box.intersects($$0, $$1, $$2, (double)$$0 + 1.0, (double)$$1 + 1.0, (double)$$2 + 1.0)) continue;
                return this.resultProvider.apply(this.pos, $$6.move($$0, $$1, $$2));
            }
            VoxelShape $$7 = $$6.move($$0, $$1, $$2);
            if ($$7.isEmpty() || !Shapes.joinIsNotEmpty($$7, this.entityShape, BooleanOp.AND)) continue;
            return this.resultProvider.apply(this.pos, $$7);
        }
        return (T)this.endOfData();
    }
}

