/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface BlockGetter
extends LevelHeightAccessor {
    public static final int MAX_BLOCK_ITERATIONS_ALONG_TRAVEL = 16;

    @Nullable
    public BlockEntity getBlockEntity(BlockPos var1);

    default public <T extends BlockEntity> Optional<T> getBlockEntity(BlockPos p_151367_, BlockEntityType<T> p_151368_) {
        BlockEntity $$2 = this.getBlockEntity(p_151367_);
        if ($$2 == null || $$2.getType() != p_151368_) {
            return Optional.empty();
        }
        return Optional.of($$2);
    }

    public BlockState getBlockState(BlockPos var1);

    public FluidState getFluidState(BlockPos var1);

    default public int getLightEmission(BlockPos p_45572_) {
        return this.getBlockState(p_45572_).getLightEmission();
    }

    default public Stream<BlockState> getBlockStates(AABB p_45557_) {
        return BlockPos.betweenClosedStream(p_45557_).map(this::getBlockState);
    }

    default public BlockHitResult isBlockInLine(ClipBlockStateContext p_151354_) {
        return BlockGetter.traverseBlocks(p_151354_.getFrom(), p_151354_.getTo(), p_151354_, (p_360108_, p_360109_) -> {
            BlockState $$2 = this.getBlockState((BlockPos)p_360109_);
            Vec3 $$3 = p_360108_.getFrom().subtract(p_360108_.getTo());
            return p_360108_.isTargetBlock().test($$2) ? new BlockHitResult(p_360108_.getTo(), Direction.getApproximateNearest($$3.x, $$3.y, $$3.z), BlockPos.containing(p_360108_.getTo()), false) : null;
        }, p_360111_ -> {
            Vec3 $$1 = p_360111_.getFrom().subtract(p_360111_.getTo());
            return BlockHitResult.miss(p_360111_.getTo(), Direction.getApproximateNearest($$1.x, $$1.y, $$1.z), BlockPos.containing(p_360111_.getTo()));
        });
    }

    default public BlockHitResult clip(ClipContext p_45548_) {
        return BlockGetter.traverseBlocks(p_45548_.getFrom(), p_45548_.getTo(), p_45548_, (p_151359_, p_151360_) -> {
            BlockState $$2 = this.getBlockState((BlockPos)p_151360_);
            FluidState $$3 = this.getFluidState((BlockPos)p_151360_);
            Vec3 $$4 = p_151359_.getFrom();
            Vec3 $$5 = p_151359_.getTo();
            VoxelShape $$6 = p_151359_.getBlockShape($$2, this, (BlockPos)p_151360_);
            BlockHitResult $$7 = this.clipWithInteractionOverride($$4, $$5, (BlockPos)p_151360_, $$6, $$2);
            VoxelShape $$8 = p_151359_.getFluidShape($$3, this, (BlockPos)p_151360_);
            BlockHitResult $$9 = $$8.clip($$4, $$5, (BlockPos)p_151360_);
            double $$10 = $$7 == null ? Double.MAX_VALUE : p_151359_.getFrom().distanceToSqr($$7.getLocation());
            double $$11 = $$9 == null ? Double.MAX_VALUE : p_151359_.getFrom().distanceToSqr($$9.getLocation());
            return $$10 <= $$11 ? $$7 : $$9;
        }, p_360110_ -> {
            Vec3 $$1 = p_360110_.getFrom().subtract(p_360110_.getTo());
            return BlockHitResult.miss(p_360110_.getTo(), Direction.getApproximateNearest($$1.x, $$1.y, $$1.z), BlockPos.containing(p_360110_.getTo()));
        });
    }

    @Nullable
    default public BlockHitResult clipWithInteractionOverride(Vec3 p_45559_, Vec3 p_45560_, BlockPos p_45561_, VoxelShape p_45562_, BlockState p_45563_) {
        BlockHitResult $$6;
        BlockHitResult $$5 = p_45562_.clip(p_45559_, p_45560_, p_45561_);
        if ($$5 != null && ($$6 = p_45563_.getInteractionShape(this, p_45561_).clip(p_45559_, p_45560_, p_45561_)) != null && $$6.getLocation().subtract(p_45559_).lengthSqr() < $$5.getLocation().subtract(p_45559_).lengthSqr()) {
            return $$5.withDirection($$6.getDirection());
        }
        return $$5;
    }

    default public double getBlockFloorHeight(VoxelShape p_45565_, Supplier<VoxelShape> p_45566_) {
        if (!p_45565_.isEmpty()) {
            return p_45565_.max(Direction.Axis.Y);
        }
        double $$2 = p_45566_.get().max(Direction.Axis.Y);
        if ($$2 >= 1.0) {
            return $$2 - 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    default public double getBlockFloorHeight(BlockPos p_45574_) {
        return this.getBlockFloorHeight(this.getBlockState(p_45574_).getCollisionShape(this, p_45574_), () -> {
            BlockPos $$1 = p_45574_.below();
            return this.getBlockState($$1).getCollisionShape(this, $$1);
        });
    }

    public static <T, C> T traverseBlocks(Vec3 p_151362_, Vec3 p_151363_, C p_151364_, BiFunction<C, BlockPos, T> p_151365_, Function<C, T> p_151366_) {
        int $$13;
        int $$12;
        if (p_151362_.equals(p_151363_)) {
            return p_151366_.apply(p_151364_);
        }
        double $$5 = Mth.lerp(-1.0E-7, p_151363_.x, p_151362_.x);
        double $$6 = Mth.lerp(-1.0E-7, p_151363_.y, p_151362_.y);
        double $$7 = Mth.lerp(-1.0E-7, p_151363_.z, p_151362_.z);
        double $$8 = Mth.lerp(-1.0E-7, p_151362_.x, p_151363_.x);
        double $$9 = Mth.lerp(-1.0E-7, p_151362_.y, p_151363_.y);
        double $$10 = Mth.lerp(-1.0E-7, p_151362_.z, p_151363_.z);
        int $$11 = Mth.floor($$8);
        BlockPos.MutableBlockPos $$14 = new BlockPos.MutableBlockPos($$11, $$12 = Mth.floor($$9), $$13 = Mth.floor($$10));
        T $$15 = p_151365_.apply(p_151364_, $$14);
        if ($$15 != null) {
            return $$15;
        }
        double $$16 = $$5 - $$8;
        double $$17 = $$6 - $$9;
        double $$18 = $$7 - $$10;
        int $$19 = Mth.sign($$16);
        int $$20 = Mth.sign($$17);
        int $$21 = Mth.sign($$18);
        double $$22 = $$19 == 0 ? Double.MAX_VALUE : (double)$$19 / $$16;
        double $$23 = $$20 == 0 ? Double.MAX_VALUE : (double)$$20 / $$17;
        double $$24 = $$21 == 0 ? Double.MAX_VALUE : (double)$$21 / $$18;
        double $$25 = $$22 * ($$19 > 0 ? 1.0 - Mth.frac($$8) : Mth.frac($$8));
        double $$26 = $$23 * ($$20 > 0 ? 1.0 - Mth.frac($$9) : Mth.frac($$9));
        double $$27 = $$24 * ($$21 > 0 ? 1.0 - Mth.frac($$10) : Mth.frac($$10));
        while ($$25 <= 1.0 || $$26 <= 1.0 || $$27 <= 1.0) {
            T $$28;
            if ($$25 < $$26) {
                if ($$25 < $$27) {
                    $$11 += $$19;
                    $$25 += $$22;
                } else {
                    $$13 += $$21;
                    $$27 += $$24;
                }
            } else if ($$26 < $$27) {
                $$12 += $$20;
                $$26 += $$23;
            } else {
                $$13 += $$21;
                $$27 += $$24;
            }
            if (($$28 = p_151365_.apply(p_151364_, $$14.set($$11, $$12, $$13))) == null) continue;
            return $$28;
        }
        return p_151366_.apply(p_151364_);
    }

    public static Iterable<BlockPos> boxTraverseBlocks(Vec3 p_363615_, Vec3 p_363775_, AABB p_361346_) {
        Vec3 $$3 = p_363775_.subtract(p_363615_);
        Iterable<BlockPos> $$4 = BlockPos.betweenClosed(p_361346_);
        if ($$3.lengthSqr() < (double)Mth.square(0.99999f)) {
            return $$4;
        }
        ObjectLinkedOpenHashSet $$5 = new ObjectLinkedOpenHashSet();
        Vec3 $$6 = $$3.normalize().scale(1.0E-7);
        Vec3 $$7 = p_361346_.getMinPosition().add($$6);
        Vec3 $$8 = p_361346_.getMinPosition().subtract($$3).subtract($$6);
        BlockGetter.addCollisionsAlongTravel((Set<BlockPos>)$$5, $$8, $$7, p_361346_);
        for (BlockPos $$9 : $$4) {
            $$5.add($$9.immutable());
        }
        return $$5;
    }

    private static void addCollisionsAlongTravel(Set<BlockPos> p_361986_, Vec3 p_365197_, Vec3 p_362395_, AABB p_362649_) {
        Vec3 $$4 = p_362395_.subtract(p_365197_);
        int $$5 = Mth.floor(p_365197_.x);
        int $$6 = Mth.floor(p_365197_.y);
        int $$7 = Mth.floor(p_365197_.z);
        int $$8 = Mth.sign($$4.x);
        int $$9 = Mth.sign($$4.y);
        int $$10 = Mth.sign($$4.z);
        double $$11 = $$8 == 0 ? Double.MAX_VALUE : (double)$$8 / $$4.x;
        double $$12 = $$9 == 0 ? Double.MAX_VALUE : (double)$$9 / $$4.y;
        double $$13 = $$10 == 0 ? Double.MAX_VALUE : (double)$$10 / $$4.z;
        double $$14 = $$11 * ($$8 > 0 ? 1.0 - Mth.frac(p_365197_.x) : Mth.frac(p_365197_.x));
        double $$15 = $$12 * ($$9 > 0 ? 1.0 - Mth.frac(p_365197_.y) : Mth.frac(p_365197_.y));
        double $$16 = $$13 * ($$10 > 0 ? 1.0 - Mth.frac(p_365197_.z) : Mth.frac(p_365197_.z));
        int $$17 = 0;
        while ($$14 <= 1.0 || $$15 <= 1.0 || $$16 <= 1.0) {
            if ($$14 < $$15) {
                if ($$14 < $$16) {
                    $$5 += $$8;
                    $$14 += $$11;
                } else {
                    $$7 += $$10;
                    $$16 += $$13;
                }
            } else if ($$15 < $$16) {
                $$6 += $$9;
                $$15 += $$12;
            } else {
                $$7 += $$10;
                $$16 += $$13;
            }
            if ($$17++ > 16) break;
            Optional<Vec3> $$18 = AABB.clip($$5, $$6, $$7, $$5 + 1, $$6 + 1, $$7 + 1, p_365197_, p_362395_);
            if ($$18.isEmpty()) continue;
            Vec3 $$19 = $$18.get();
            double $$20 = Mth.clamp($$19.x, (double)$$5 + (double)1.0E-5f, (double)$$5 + 1.0 - (double)1.0E-5f);
            double $$21 = Mth.clamp($$19.y, (double)$$6 + (double)1.0E-5f, (double)$$6 + 1.0 - (double)1.0E-5f);
            double $$22 = Mth.clamp($$19.z, (double)$$7 + (double)1.0E-5f, (double)$$7 + 1.0 - (double)1.0E-5f);
            int $$23 = Mth.floor($$20 + p_362649_.getXsize());
            int $$24 = Mth.floor($$21 + p_362649_.getYsize());
            int $$25 = Mth.floor($$22 + p_362649_.getZsize());
            for (int $$26 = $$5; $$26 <= $$23; ++$$26) {
                for (int $$27 = $$6; $$27 <= $$24; ++$$27) {
                    for (int $$28 = $$7; $$28 <= $$25; ++$$28) {
                        p_361986_.add(new BlockPos($$26, $$27, $$28));
                    }
                }
            }
        }
    }
}

