/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.PotentialCalculator;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public final class NaturalSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MIN_SPAWN_DISTANCE = 24;
    public static final int SPAWN_DISTANCE_CHUNK = 8;
    public static final int SPAWN_DISTANCE_BLOCK = 128;
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    private static final MobCategory[] SPAWNING_CATEGORIES = (MobCategory[])Stream.of(MobCategory.values()).filter(p_47037_ -> p_47037_ != MobCategory.MISC).toArray(MobCategory[]::new);

    private NaturalSpawner() {
    }

    public static SpawnState createState(int p_186525_, Iterable<Entity> p_186526_, ChunkGetter p_186527_, LocalMobCapCalculator p_186528_) {
        PotentialCalculator $$4 = new PotentialCalculator();
        Object2IntOpenHashMap $$5 = new Object2IntOpenHashMap();
        for (Entity $$6 : p_186526_) {
            MobCategory $$8;
            Mob $$7;
            if ($$6 instanceof Mob && (($$7 = (Mob)$$6).isPersistenceRequired() || $$7.requiresCustomPersistence()) || ($$8 = $$6.getType().getCategory()) == MobCategory.MISC) continue;
            BlockPos $$9 = $$6.blockPosition();
            p_186527_.query(ChunkPos.asLong($$9), p_275163_ -> {
                MobSpawnSettings.MobSpawnCost $$7 = NaturalSpawner.getRoughBiome($$9, p_275163_).getMobSettings().getMobSpawnCost($$6.getType());
                if ($$7 != null) {
                    $$4.addCharge($$6.blockPosition(), $$7.charge());
                }
                if ($$6 instanceof Mob) {
                    p_186528_.addMob(p_275163_.getPos(), $$8);
                }
                $$5.addTo((Object)$$8, 1);
            });
        }
        return new SpawnState(p_186525_, (Object2IntOpenHashMap<MobCategory>)$$5, $$4, p_186528_);
    }

    static Biome getRoughBiome(BlockPos p_47096_, ChunkAccess p_47097_) {
        return p_47097_.getNoiseBiome(QuartPos.fromBlock(p_47096_.getX()), QuartPos.fromBlock(p_47096_.getY()), QuartPos.fromBlock(p_47096_.getZ())).value();
    }

    public static List<MobCategory> getFilteredSpawningCategories(SpawnState p_363093_, boolean p_365226_, boolean p_360321_, boolean p_364513_) {
        ArrayList<MobCategory> $$4 = new ArrayList<MobCategory>(SPAWNING_CATEGORIES.length);
        for (MobCategory $$5 : SPAWNING_CATEGORIES) {
            if (!p_365226_ && $$5.isFriendly() || !p_360321_ && !$$5.isFriendly() || !p_364513_ && $$5.isPersistent() || !p_363093_.canSpawnForCategoryGlobal($$5)) continue;
            $$4.add($$5);
        }
        return $$4;
    }

    public static void spawnForChunk(ServerLevel p_47030_, LevelChunk p_47031_, SpawnState p_47032_, List<MobCategory> p_362270_) {
        ProfilerFiller $$4 = Profiler.get();
        $$4.push("spawner");
        for (MobCategory $$5 : p_362270_) {
            if (!p_47032_.canSpawnForCategoryLocal($$5, p_47031_.getPos())) continue;
            NaturalSpawner.spawnCategoryForChunk($$5, p_47030_, p_47031_, p_47032_::canSpawn, p_47032_::afterSpawn);
        }
        $$4.pop();
    }

    public static void spawnCategoryForChunk(MobCategory p_47046_, ServerLevel p_47047_, LevelChunk p_47048_, SpawnPredicate p_47049_, AfterSpawnCallback p_47050_) {
        BlockPos $$5 = NaturalSpawner.getRandomPosWithin(p_47047_, p_47048_);
        if ($$5.getY() < p_47047_.getMinY() + 1) {
            return;
        }
        NaturalSpawner.spawnCategoryForPosition(p_47046_, p_47047_, p_47048_, $$5, p_47049_, p_47050_);
    }

    @VisibleForDebug
    public static void spawnCategoryForPosition(MobCategory p_151613_, ServerLevel p_151614_, BlockPos p_151615_) {
        NaturalSpawner.spawnCategoryForPosition(p_151613_, p_151614_, p_151614_.getChunk(p_151615_), p_151615_, (p_151606_, p_151607_, p_151608_) -> true, (p_151610_, p_151611_) -> {});
    }

    public static void spawnCategoryForPosition(MobCategory p_47039_, ServerLevel p_47040_, ChunkAccess p_47041_, BlockPos p_47042_, SpawnPredicate p_47043_, AfterSpawnCallback p_47044_) {
        StructureManager $$6 = p_47040_.structureManager();
        ChunkGenerator $$7 = p_47040_.getChunkSource().getGenerator();
        int $$8 = p_47042_.getY();
        BlockState $$9 = p_47041_.getBlockState(p_47042_);
        if ($$9.isRedstoneConductor(p_47041_, p_47042_)) {
            return;
        }
        BlockPos.MutableBlockPos $$10 = new BlockPos.MutableBlockPos();
        int $$11 = 0;
        block0: for (int $$12 = 0; $$12 < 3; ++$$12) {
            int $$13 = p_47042_.getX();
            int $$14 = p_47042_.getZ();
            int $$15 = 6;
            MobSpawnSettings.SpawnerData $$16 = null;
            SpawnGroupData $$17 = null;
            int $$18 = Mth.ceil(p_47040_.random.nextFloat() * 4.0f);
            int $$19 = 0;
            for (int $$20 = 0; $$20 < $$18; ++$$20) {
                double $$24;
                $$10.set($$13 += p_47040_.random.nextInt(6) - p_47040_.random.nextInt(6), $$8, $$14 += p_47040_.random.nextInt(6) - p_47040_.random.nextInt(6));
                double $$21 = (double)$$13 + 0.5;
                double $$22 = (double)$$14 + 0.5;
                Player $$23 = p_47040_.getNearestPlayer($$21, (double)$$8, $$22, -1.0, false);
                if ($$23 == null || !NaturalSpawner.isRightDistanceToPlayerAndSpawnPoint(p_47040_, p_47041_, $$10, $$24 = $$23.distanceToSqr($$21, $$8, $$22))) continue;
                if ($$16 == null) {
                    Optional<MobSpawnSettings.SpawnerData> $$25 = NaturalSpawner.getRandomSpawnMobAt(p_47040_, $$6, $$7, p_47039_, p_47040_.random, $$10);
                    if ($$25.isEmpty()) continue block0;
                    $$16 = $$25.get();
                    $$18 = $$16.minCount + p_47040_.random.nextInt(1 + $$16.maxCount - $$16.minCount);
                }
                if (!NaturalSpawner.isValidSpawnPostitionForType(p_47040_, p_47039_, $$6, $$7, $$16, $$10, $$24) || !p_47043_.test($$16.type, $$10, p_47041_)) continue;
                Mob $$26 = NaturalSpawner.getMobForSpawn(p_47040_, $$16.type);
                if ($$26 == null) {
                    return;
                }
                $$26.moveTo($$21, $$8, $$22, p_47040_.random.nextFloat() * 360.0f, 0.0f);
                if (!NaturalSpawner.isValidPositionForMob(p_47040_, $$26, $$24)) continue;
                $$17 = $$26.finalizeSpawn(p_47040_, p_47040_.getCurrentDifficultyAt($$26.blockPosition()), EntitySpawnReason.NATURAL, $$17);
                ++$$19;
                p_47040_.addFreshEntityWithPassengers($$26);
                p_47044_.run($$26, p_47041_);
                if (++$$11 >= $$26.getMaxSpawnClusterSize()) {
                    return;
                }
                if ($$26.isMaxGroupSizeReached($$19)) continue block0;
            }
        }
    }

    private static boolean isRightDistanceToPlayerAndSpawnPoint(ServerLevel p_47025_, ChunkAccess p_47026_, BlockPos.MutableBlockPos p_47027_, double p_47028_) {
        if (p_47028_ <= 576.0) {
            return false;
        }
        if (p_47025_.getSharedSpawnPos().closerToCenterThan(new Vec3((double)p_47027_.getX() + 0.5, p_47027_.getY(), (double)p_47027_.getZ() + 0.5), 24.0)) {
            return false;
        }
        return Objects.equals(new ChunkPos(p_47027_), p_47026_.getPos()) || p_47025_.isNaturalSpawningAllowed(p_47027_);
    }

    private static boolean isValidSpawnPostitionForType(ServerLevel p_220422_, MobCategory p_220423_, StructureManager p_220424_, ChunkGenerator p_220425_, MobSpawnSettings.SpawnerData p_220426_, BlockPos.MutableBlockPos p_220427_, double p_220428_) {
        EntityType<?> $$7 = p_220426_.type;
        if ($$7.getCategory() == MobCategory.MISC) {
            return false;
        }
        if (!$$7.canSpawnFarFromPlayer() && p_220428_ > (double)($$7.getCategory().getDespawnDistance() * $$7.getCategory().getDespawnDistance())) {
            return false;
        }
        if (!$$7.canSummon() || !NaturalSpawner.canSpawnMobAt(p_220422_, p_220424_, p_220425_, p_220423_, p_220426_, p_220427_)) {
            return false;
        }
        if (!SpawnPlacements.isSpawnPositionOk($$7, p_220422_, p_220427_)) {
            return false;
        }
        if (!SpawnPlacements.checkSpawnRules($$7, p_220422_, EntitySpawnReason.NATURAL, p_220427_, p_220422_.random)) {
            return false;
        }
        return p_220422_.noCollision($$7.getSpawnAABB((double)p_220427_.getX() + 0.5, p_220427_.getY(), (double)p_220427_.getZ() + 0.5));
    }

    @Nullable
    private static Mob getMobForSpawn(ServerLevel p_46989_, EntityType<?> p_46990_) {
        try {
            Object obj = p_46990_.create(p_46989_, EntitySpawnReason.NATURAL);
            if (obj instanceof Mob) {
                Mob $$2 = (Mob)obj;
                return $$2;
            }
            LOGGER.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(p_46990_));
        }
        catch (Exception $$3) {
            LOGGER.warn("Failed to create mob", (Throwable)$$3);
        }
        return null;
    }

    private static boolean isValidPositionForMob(ServerLevel p_46992_, Mob p_46993_, double p_46994_) {
        if (p_46994_ > (double)(p_46993_.getType().getCategory().getDespawnDistance() * p_46993_.getType().getCategory().getDespawnDistance()) && p_46993_.removeWhenFarAway(p_46994_)) {
            return false;
        }
        return p_46993_.checkSpawnRules(p_46992_, EntitySpawnReason.NATURAL) && p_46993_.checkSpawnObstruction(p_46992_);
    }

    private static Optional<MobSpawnSettings.SpawnerData> getRandomSpawnMobAt(ServerLevel p_220430_, StructureManager p_220431_, ChunkGenerator p_220432_, MobCategory p_220433_, RandomSource p_220434_, BlockPos p_220435_) {
        Holder<Biome> $$6 = p_220430_.getBiome(p_220435_);
        if (p_220433_ == MobCategory.WATER_AMBIENT && $$6.is(BiomeTags.REDUCED_WATER_AMBIENT_SPAWNS) && p_220434_.nextFloat() < 0.98f) {
            return Optional.empty();
        }
        return NaturalSpawner.mobsAt(p_220430_, p_220431_, p_220432_, p_220433_, p_220435_, $$6).getRandom(p_220434_);
    }

    private static boolean canSpawnMobAt(ServerLevel p_220437_, StructureManager p_220438_, ChunkGenerator p_220439_, MobCategory p_220440_, MobSpawnSettings.SpawnerData p_220441_, BlockPos p_220442_) {
        return NaturalSpawner.mobsAt(p_220437_, p_220438_, p_220439_, p_220440_, p_220442_, null).unwrap().contains(p_220441_);
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel p_220444_, StructureManager p_220445_, ChunkGenerator p_220446_, MobCategory p_220447_, BlockPos p_220448_, @Nullable Holder<Biome> p_220449_) {
        if (NaturalSpawner.isInNetherFortressBounds(p_220448_, p_220444_, p_220447_, p_220445_)) {
            return NetherFortressStructure.FORTRESS_ENEMIES;
        }
        return p_220446_.getMobsAt(p_220449_ != null ? p_220449_ : p_220444_.getBiome(p_220448_), p_220445_, p_220447_, p_220448_);
    }

    public static boolean isInNetherFortressBounds(BlockPos p_220456_, ServerLevel p_220457_, MobCategory p_220458_, StructureManager p_220459_) {
        if (p_220458_ != MobCategory.MONSTER || !p_220457_.getBlockState(p_220456_.below()).is(Blocks.NETHER_BRICKS)) {
            return false;
        }
        Structure $$4 = p_220459_.registryAccess().lookupOrThrow(Registries.STRUCTURE).getValue(BuiltinStructures.FORTRESS);
        if ($$4 == null) {
            return false;
        }
        return p_220459_.getStructureAt(p_220456_, $$4).isValid();
    }

    private static BlockPos getRandomPosWithin(Level p_47063_, LevelChunk p_47064_) {
        ChunkPos $$2 = p_47064_.getPos();
        int $$3 = $$2.getMinBlockX() + p_47063_.random.nextInt(16);
        int $$4 = $$2.getMinBlockZ() + p_47063_.random.nextInt(16);
        int $$5 = p_47064_.getHeight(Heightmap.Types.WORLD_SURFACE, $$3, $$4) + 1;
        int $$6 = Mth.randomBetweenInclusive(p_47063_.random, p_47063_.getMinY(), $$5);
        return new BlockPos($$3, $$6, $$4);
    }

    public static boolean isValidEmptySpawnBlock(BlockGetter p_47057_, BlockPos p_47058_, BlockState p_47059_, FluidState p_47060_, EntityType<?> p_47061_) {
        if (p_47059_.isCollisionShapeFullBlock(p_47057_, p_47058_)) {
            return false;
        }
        if (p_47059_.isSignalSource()) {
            return false;
        }
        if (!p_47060_.isEmpty()) {
            return false;
        }
        if (p_47059_.is(BlockTags.PREVENT_MOB_SPAWNING_INSIDE)) {
            return false;
        }
        return !p_47061_.isBlockDangerous(p_47059_);
    }

    /*
     * WARNING - void declaration
     */
    public static void spawnMobsForChunkGeneration(ServerLevelAccessor p_220451_, Holder<Biome> p_220452_, ChunkPos p_220453_, RandomSource p_220454_) {
        MobSpawnSettings $$4 = p_220452_.value().getMobSettings();
        WeightedRandomList<MobSpawnSettings.SpawnerData> $$5 = $$4.getMobs(MobCategory.CREATURE);
        if ($$5.isEmpty()) {
            return;
        }
        int $$6 = p_220453_.getMinBlockX();
        int $$7 = p_220453_.getMinBlockZ();
        while (p_220454_.nextFloat() < $$4.getCreatureProbability()) {
            Optional<MobSpawnSettings.SpawnerData> $$8 = $$5.getRandom(p_220454_);
            if ($$8.isEmpty()) continue;
            MobSpawnSettings.SpawnerData $$9 = $$8.get();
            int $$10 = $$9.minCount + p_220454_.nextInt(1 + $$9.maxCount - $$9.minCount);
            SpawnGroupData $$11 = null;
            int $$12 = $$6 + p_220454_.nextInt(16);
            int $$13 = $$7 + p_220454_.nextInt(16);
            int $$14 = $$12;
            int $$15 = $$13;
            for (int $$16 = 0; $$16 < $$10; ++$$16) {
                boolean $$17 = false;
                for (int $$18 = 0; !$$17 && $$18 < 4; ++$$18) {
                    BlockPos $$19 = NaturalSpawner.getTopNonCollidingPos(p_220451_, $$9.type, $$12, $$13);
                    if ($$9.type.canSummon() && SpawnPlacements.isSpawnPositionOk($$9.type, p_220451_, $$19)) {
                        Mob $$26;
                        void $$25;
                        float $$20 = $$9.type.getWidth();
                        double $$21 = Mth.clamp((double)$$12, (double)$$6 + (double)$$20, (double)$$6 + 16.0 - (double)$$20);
                        double $$22 = Mth.clamp((double)$$13, (double)$$7 + (double)$$20, (double)$$7 + 16.0 - (double)$$20);
                        if (!p_220451_.noCollision($$9.type.getSpawnAABB($$21, $$19.getY(), $$22)) || !SpawnPlacements.checkSpawnRules($$9.type, p_220451_, EntitySpawnReason.CHUNK_GENERATION, BlockPos.containing($$21, $$19.getY(), $$22), p_220451_.getRandom())) continue;
                        try {
                            Object $$23 = $$9.type.create(p_220451_.getLevel(), EntitySpawnReason.NATURAL);
                        }
                        catch (Exception $$24) {
                            LOGGER.warn("Failed to create mob", (Throwable)$$24);
                            continue;
                        }
                        if ($$25 == null) continue;
                        $$25.moveTo($$21, $$19.getY(), $$22, p_220454_.nextFloat() * 360.0f, 0.0f);
                        if ($$25 instanceof Mob && ($$26 = (Mob)$$25).checkSpawnRules(p_220451_, EntitySpawnReason.CHUNK_GENERATION) && $$26.checkSpawnObstruction(p_220451_)) {
                            $$11 = $$26.finalizeSpawn(p_220451_, p_220451_.getCurrentDifficultyAt($$26.blockPosition()), EntitySpawnReason.CHUNK_GENERATION, $$11);
                            p_220451_.addFreshEntityWithPassengers($$26);
                            $$17 = true;
                        }
                    }
                    $$12 += p_220454_.nextInt(5) - p_220454_.nextInt(5);
                    $$13 += p_220454_.nextInt(5) - p_220454_.nextInt(5);
                    while ($$12 < $$6 || $$12 >= $$6 + 16 || $$13 < $$7 || $$13 >= $$7 + 16) {
                        $$12 = $$14 + p_220454_.nextInt(5) - p_220454_.nextInt(5);
                        $$13 = $$15 + p_220454_.nextInt(5) - p_220454_.nextInt(5);
                    }
                }
            }
        }
    }

    private static BlockPos getTopNonCollidingPos(LevelReader p_47066_, EntityType<?> p_47067_, int p_47068_, int p_47069_) {
        int $$4 = p_47066_.getHeight(SpawnPlacements.getHeightmapType(p_47067_), p_47068_, p_47069_);
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos(p_47068_, $$4, p_47069_);
        if (p_47066_.dimensionType().hasCeiling()) {
            do {
                $$5.move(Direction.DOWN);
            } while (!p_47066_.getBlockState($$5).isAir());
            do {
                $$5.move(Direction.DOWN);
            } while (p_47066_.getBlockState($$5).isAir() && $$5.getY() > p_47066_.getMinY());
        }
        return SpawnPlacements.getPlacementType(p_47067_).adjustSpawnPosition(p_47066_, $$5.immutable());
    }

    @FunctionalInterface
    public static interface ChunkGetter {
        public void query(long var1, Consumer<LevelChunk> var3);
    }

    public static class SpawnState {
        private final int spawnableChunkCount;
        private final Object2IntOpenHashMap<MobCategory> mobCategoryCounts;
        private final PotentialCalculator spawnPotential;
        private final Object2IntMap<MobCategory> unmodifiableMobCategoryCounts;
        private final LocalMobCapCalculator localMobCapCalculator;
        @Nullable
        private BlockPos lastCheckedPos;
        @Nullable
        private EntityType<?> lastCheckedType;
        private double lastCharge;

        SpawnState(int p_186544_, Object2IntOpenHashMap<MobCategory> p_186545_, PotentialCalculator p_186546_, LocalMobCapCalculator p_186547_) {
            this.spawnableChunkCount = p_186544_;
            this.mobCategoryCounts = p_186545_;
            this.spawnPotential = p_186546_;
            this.localMobCapCalculator = p_186547_;
            this.unmodifiableMobCategoryCounts = Object2IntMaps.unmodifiable(p_186545_);
        }

        private boolean canSpawn(EntityType<?> p_47128_, BlockPos p_47129_, ChunkAccess p_47130_) {
            double $$4;
            this.lastCheckedPos = p_47129_;
            this.lastCheckedType = p_47128_;
            MobSpawnSettings.MobSpawnCost $$3 = NaturalSpawner.getRoughBiome(p_47129_, p_47130_).getMobSettings().getMobSpawnCost(p_47128_);
            if ($$3 == null) {
                this.lastCharge = 0.0;
                return true;
            }
            this.lastCharge = $$4 = $$3.charge();
            double $$5 = this.spawnPotential.getPotentialEnergyChange(p_47129_, $$4);
            return $$5 <= $$3.energyBudget();
        }

        private void afterSpawn(Mob p_47132_, ChunkAccess p_47133_) {
            double $$7;
            EntityType<?> $$2 = p_47132_.getType();
            BlockPos $$3 = p_47132_.blockPosition();
            if ($$3.equals(this.lastCheckedPos) && $$2 == this.lastCheckedType) {
                double $$4 = this.lastCharge;
            } else {
                MobSpawnSettings.MobSpawnCost $$5 = NaturalSpawner.getRoughBiome($$3, p_47133_).getMobSettings().getMobSpawnCost($$2);
                if ($$5 != null) {
                    double $$6 = $$5.charge();
                } else {
                    $$7 = 0.0;
                }
            }
            this.spawnPotential.addCharge($$3, $$7);
            MobCategory $$8 = $$2.getCategory();
            this.mobCategoryCounts.addTo((Object)$$8, 1);
            this.localMobCapCalculator.addMob(new ChunkPos($$3), $$8);
        }

        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        public Object2IntMap<MobCategory> getMobCategoryCounts() {
            return this.unmodifiableMobCategoryCounts;
        }

        boolean canSpawnForCategoryGlobal(MobCategory p_361715_) {
            int $$1 = p_361715_.getMaxInstancesPerChunk() * this.spawnableChunkCount / MAGIC_NUMBER;
            return this.mobCategoryCounts.getInt((Object)p_361715_) < $$1;
        }

        boolean canSpawnForCategoryLocal(MobCategory p_362658_, ChunkPos p_360784_) {
            return this.localMobCapCalculator.canSpawn(p_362658_, p_360784_);
        }
    }

    @FunctionalInterface
    public static interface SpawnPredicate {
        public boolean test(EntityType<?> var1, BlockPos var2, ChunkAccess var3);
    }

    @FunctionalInterface
    public static interface AfterSpawnCallback {
        public void run(Mob var1, ChunkAccess var2);
    }
}

