/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class MultiNoiseBiomeSourceParameterList {
    public static final Codec<MultiNoiseBiomeSourceParameterList> DIRECT_CODEC = RecordCodecBuilder.create(p_275469_ -> p_275469_.group((App)Preset.CODEC.fieldOf("preset").forGetter(p_275196_ -> p_275196_.preset), RegistryOps.retrieveGetter(Registries.BIOME)).apply((Applicative)p_275469_, MultiNoiseBiomeSourceParameterList::new));
    public static final Codec<Holder<MultiNoiseBiomeSourceParameterList>> CODEC = RegistryFileCodec.create(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, DIRECT_CODEC);
    private final Preset preset;
    private final Climate.ParameterList<Holder<Biome>> parameters;

    public MultiNoiseBiomeSourceParameterList(Preset p_275275_, HolderGetter<Biome> p_275192_) {
        this.preset = p_275275_;
        this.parameters = p_275275_.provider.apply(p_275192_::getOrThrow);
    }

    public Climate.ParameterList<Holder<Biome>> parameters() {
        return this.parameters;
    }

    public static Map<Preset, Climate.ParameterList<ResourceKey<Biome>>> knownPresets() {
        return Preset.BY_NAME.values().stream().collect(Collectors.toMap(p_275210_ -> p_275210_, p_275480_ -> p_275480_.provider().apply(p_275406_ -> p_275406_)));
    }

    public record Preset(ResourceLocation id, SourceProvider provider) {
        public static final Preset NETHER = new Preset(ResourceLocation.withDefaultNamespace("nether"), new SourceProvider(){

            @Override
            public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> p_275356_) {
                return new Climate.ParameterList(List.of(Pair.of((Object)Climate.parameters(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), p_275356_.apply(Biomes.NETHER_WASTES)), Pair.of((Object)Climate.parameters(0.0f, -0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), p_275356_.apply(Biomes.SOUL_SAND_VALLEY)), Pair.of((Object)Climate.parameters(0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), p_275356_.apply(Biomes.CRIMSON_FOREST)), Pair.of((Object)Climate.parameters(0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.375f), p_275356_.apply(Biomes.WARPED_FOREST)), Pair.of((Object)Climate.parameters(-0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.175f), p_275356_.apply(Biomes.BASALT_DELTAS))));
            }
        });
        public static final Preset OVERWORLD = new Preset(ResourceLocation.withDefaultNamespace("overworld"), new SourceProvider(){

            @Override
            public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> p_275530_) {
                return Preset.generateOverworldBiomes(p_275530_, OverworldBiomeBuilder.Modifier.NONE);
            }
        });
        public static final Preset OVERWORLD_WINTER_DROP = new Preset(ResourceLocation.withDefaultNamespace("overworld_winter_drop"), new SourceProvider(){

            @Override
            public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> p_379572_) {
                return Preset.generateOverworldBiomes(p_379572_, OverworldBiomeBuilder.Modifier.WINTER_DROP);
            }
        });
        static final Map<ResourceLocation, Preset> BY_NAME = Stream.of(NETHER, OVERWORLD, OVERWORLD_WINTER_DROP).collect(Collectors.toMap(Preset::id, p_275365_ -> p_275365_));
        public static final Codec<Preset> CODEC = ResourceLocation.CODEC.flatXmap(p_275567_ -> Optional.ofNullable(BY_NAME.get(p_275567_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown preset: " + String.valueOf(p_275567_))), p_275325_ -> DataResult.success((Object)p_275325_.id));

        static <T> Climate.ParameterList<T> generateOverworldBiomes(Function<ResourceKey<Biome>, T> p_277826_, OverworldBiomeBuilder.Modifier p_379650_) {
            ImmutableList.Builder $$2 = ImmutableList.builder();
            new OverworldBiomeBuilder(p_379650_).addBiomes(p_275579_ -> $$2.add((Object)p_275579_.mapSecond(p_277826_)));
            return new Climate.ParameterList($$2.build());
        }

        public Stream<ResourceKey<Biome>> usedBiomes() {
            return this.provider.apply(p_275429_ -> p_275429_).values().stream().map(Pair::getSecond).distinct();
        }

        @FunctionalInterface
        static interface SourceProvider {
            public <T> Climate.ParameterList<T> apply(Function<ResourceKey<Biome>, T> var1);
        }
    }
}

