/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BambooStalkBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<BambooStalkBlock> CODEC = BambooStalkBlock.simpleCodec(BambooStalkBlock::new);
    protected static final float SMALL_LEAVES_AABB_OFFSET = 3.0f;
    protected static final float LARGE_LEAVES_AABB_OFFSET = 5.0f;
    protected static final float COLLISION_AABB_OFFSET = 1.5f;
    protected static final VoxelShape SMALL_SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape LARGE_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape COLLISION_SHAPE = Block.box(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final EnumProperty<BambooLeaves> LEAVES = BlockStateProperties.BAMBOO_LEAVES;
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    public static final int MAX_HEIGHT = 16;
    public static final int STAGE_GROWING = 0;
    public static final int STAGE_DONE_GROWING = 1;
    public static final int AGE_THIN_BAMBOO = 0;
    public static final int AGE_THICK_BAMBOO = 1;

    public MapCodec<BambooStalkBlock> codec() {
        return CODEC;
    }

    public BambooStalkBlock(BlockBehaviour.Properties p_261753_) {
        super(p_261753_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0)).setValue(LEAVES, BambooLeaves.NONE)).setValue(STAGE, 0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_261641_) {
        p_261641_.add(AGE, LEAVES, STAGE);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState p_261479_) {
        return true;
    }

    @Override
    protected VoxelShape getShape(BlockState p_261515_, BlockGetter p_261586_, BlockPos p_261526_, CollisionContext p_261930_) {
        VoxelShape $$4 = p_261515_.getValue(LEAVES) == BambooLeaves.LARGE ? LARGE_SHAPE : SMALL_SHAPE;
        Vec3 $$5 = p_261515_.getOffset(p_261526_);
        return $$4.move($$5.x, $$5.y, $$5.z);
    }

    @Override
    protected boolean isPathfindable(BlockState p_262166_, PathComputationType p_261513_) {
        return false;
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState p_261560_, BlockGetter p_261965_, BlockPos p_261950_, CollisionContext p_261571_) {
        Vec3 $$4 = p_261560_.getOffset(p_261950_);
        return COLLISION_SHAPE.move($$4.x, $$4.y, $$4.z);
    }

    @Override
    protected boolean isCollisionShapeFullBlock(BlockState p_262062_, BlockGetter p_261848_, BlockPos p_261466_) {
        return false;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_261764_) {
        FluidState $$1 = p_261764_.getLevel().getFluidState(p_261764_.getClickedPos());
        if (!$$1.isEmpty()) {
            return null;
        }
        BlockState $$2 = p_261764_.getLevel().getBlockState(p_261764_.getClickedPos().below());
        if ($$2.is(BlockTags.BAMBOO_PLANTABLE_ON)) {
            if ($$2.is(Blocks.BAMBOO_SAPLING)) {
                return (BlockState)this.defaultBlockState().setValue(AGE, 0);
            }
            if ($$2.is(Blocks.BAMBOO)) {
                int $$3 = $$2.getValue(AGE) > 0 ? 1 : 0;
                return (BlockState)this.defaultBlockState().setValue(AGE, $$3);
            }
            BlockState $$4 = p_261764_.getLevel().getBlockState(p_261764_.getClickedPos().above());
            if ($$4.is(Blocks.BAMBOO)) {
                return (BlockState)this.defaultBlockState().setValue(AGE, $$4.getValue(AGE));
            }
            return Blocks.BAMBOO_SAPLING.defaultBlockState();
        }
        return null;
    }

    @Override
    protected void tick(BlockState p_261612_, ServerLevel p_261527_, BlockPos p_261846_, RandomSource p_261638_) {
        if (!p_261612_.canSurvive(p_261527_, p_261846_)) {
            p_261527_.destroyBlock(p_261846_, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(BlockState p_262083_) {
        return p_262083_.getValue(STAGE) == 0;
    }

    @Override
    protected void randomTick(BlockState p_261931_, ServerLevel p_261751_, BlockPos p_261616_, RandomSource p_261766_) {
        int $$4;
        if (p_261931_.getValue(STAGE) != 0) {
            return;
        }
        if (p_261766_.nextInt(3) == 0 && p_261751_.isEmptyBlock(p_261616_.above()) && p_261751_.getRawBrightness(p_261616_.above(), 0) >= 9 && ($$4 = this.getHeightBelowUpToMax(p_261751_, p_261616_) + 1) < 16) {
            this.growBamboo(p_261931_, p_261751_, p_261616_, p_261766_, $$4);
        }
    }

    @Override
    protected boolean canSurvive(BlockState p_261860_, LevelReader p_262154_, BlockPos p_261493_) {
        return p_262154_.getBlockState(p_261493_.below()).is(BlockTags.BAMBOO_PLANTABLE_ON);
    }

    @Override
    protected BlockState updateShape(BlockState p_261476_, LevelReader p_374219_, ScheduledTickAccess p_374048_, BlockPos p_261876_, Direction p_261512_, BlockPos p_262140_, BlockState p_262167_, RandomSource p_374194_) {
        if (!p_261476_.canSurvive(p_374219_, p_261876_)) {
            p_374048_.scheduleTick(p_261876_, this, 1);
        }
        if (p_261512_ == Direction.UP && p_262167_.is(Blocks.BAMBOO) && p_262167_.getValue(AGE) > p_261476_.getValue(AGE)) {
            return (BlockState)p_261476_.cycle(AGE);
        }
        return super.updateShape(p_261476_, p_374219_, p_374048_, p_261876_, p_261512_, p_262140_, p_262167_, p_374194_);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader p_262065_, BlockPos p_262033_, BlockState p_261700_) {
        int $$4;
        int $$3 = this.getHeightAboveUpToMax(p_262065_, p_262033_);
        return $$3 + ($$4 = this.getHeightBelowUpToMax(p_262065_, p_262033_)) + 1 < 16 && p_262065_.getBlockState(p_262033_.above($$3)).getValue(STAGE) != 1;
    }

    @Override
    public boolean isBonemealSuccess(Level p_261870_, RandomSource p_261802_, BlockPos p_262123_, BlockState p_261972_) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel p_261845_, RandomSource p_262034_, BlockPos p_261955_, BlockState p_261685_) {
        int $$4 = this.getHeightAboveUpToMax(p_261845_, p_261955_);
        int $$5 = this.getHeightBelowUpToMax(p_261845_, p_261955_);
        int $$6 = $$4 + $$5 + 1;
        int $$7 = 1 + p_262034_.nextInt(2);
        for (int $$8 = 0; $$8 < $$7; ++$$8) {
            BlockPos $$9 = p_261955_.above($$4);
            BlockState $$10 = p_261845_.getBlockState($$9);
            if ($$6 >= 16 || $$10.getValue(STAGE) == 1 || !p_261845_.isEmptyBlock($$9.above())) {
                return;
            }
            this.growBamboo($$10, p_261845_, $$9, p_262034_, $$6);
            ++$$4;
            ++$$6;
        }
    }

    @Override
    protected float getDestroyProgress(BlockState p_261691_, Player p_262171_, BlockGetter p_261621_, BlockPos p_261500_) {
        if (p_262171_.getMainHandItem().getItem() instanceof SwordItem) {
            return 1.0f;
        }
        return super.getDestroyProgress(p_261691_, p_262171_, p_261621_, p_261500_);
    }

    protected void growBamboo(BlockState p_261855_, Level p_262076_, BlockPos p_262109_, RandomSource p_261633_, int p_261759_) {
        BlockState $$5 = p_262076_.getBlockState(p_262109_.below());
        BlockPos $$6 = p_262109_.below(2);
        BlockState $$7 = p_262076_.getBlockState($$6);
        BambooLeaves $$8 = BambooLeaves.NONE;
        if (p_261759_ >= 1) {
            if (!$$5.is(Blocks.BAMBOO) || $$5.getValue(LEAVES) == BambooLeaves.NONE) {
                $$8 = BambooLeaves.SMALL;
            } else if ($$5.is(Blocks.BAMBOO) && $$5.getValue(LEAVES) != BambooLeaves.NONE) {
                $$8 = BambooLeaves.LARGE;
                if ($$7.is(Blocks.BAMBOO)) {
                    p_262076_.setBlock(p_262109_.below(), (BlockState)$$5.setValue(LEAVES, BambooLeaves.SMALL), 3);
                    p_262076_.setBlock($$6, (BlockState)$$7.setValue(LEAVES, BambooLeaves.NONE), 3);
                }
            }
        }
        int $$9 = p_261855_.getValue(AGE) == 1 || $$7.is(Blocks.BAMBOO) ? 1 : 0;
        int $$10 = p_261759_ >= 11 && p_261633_.nextFloat() < 0.25f || p_261759_ == 15 ? 1 : 0;
        p_262076_.setBlock(p_262109_.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AGE, $$9)).setValue(LEAVES, $$8)).setValue(STAGE, $$10), 3);
    }

    protected int getHeightAboveUpToMax(BlockGetter p_261541_, BlockPos p_261593_) {
        int $$2;
        for ($$2 = 0; $$2 < 16 && p_261541_.getBlockState(p_261593_.above($$2 + 1)).is(Blocks.BAMBOO); ++$$2) {
        }
        return $$2;
    }

    protected int getHeightBelowUpToMax(BlockGetter p_261927_, BlockPos p_261481_) {
        int $$2;
        for ($$2 = 0; $$2 < 16 && p_261927_.getBlockState(p_261481_.below($$2 + 1)).is(Blocks.BAMBOO); ++$$2) {
        }
        return $$2;
    }
}

