/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BeehiveBlock
extends BaseEntityBlock {
    public static final MapCodec<BeehiveBlock> CODEC = BeehiveBlock.simpleCodec(BeehiveBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty HONEY_LEVEL = BlockStateProperties.LEVEL_HONEY;
    public static final int MAX_HONEY_LEVELS = 5;
    private static final int SHEARED_HONEYCOMB_COUNT = 3;

    public MapCodec<BeehiveBlock> codec() {
        return CODEC;
    }

    public BeehiveBlock(BlockBehaviour.Properties p_49568_) {
        super(p_49568_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HONEY_LEVEL, 0)).setValue(FACING, Direction.NORTH));
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_49618_) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState p_49620_, Level p_49621_, BlockPos p_49622_) {
        return p_49620_.getValue(HONEY_LEVEL);
    }

    @Override
    public void playerDestroy(Level p_49584_, Player p_49585_, BlockPos p_49586_, BlockState p_49587_, @Nullable BlockEntity p_49588_, ItemStack p_49589_) {
        super.playerDestroy(p_49584_, p_49585_, p_49586_, p_49587_, p_49588_, p_49589_);
        if (!p_49584_.isClientSide && p_49588_ instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity $$6 = (BeehiveBlockEntity)p_49588_;
            if (!EnchantmentHelper.hasTag(p_49589_, EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING)) {
                $$6.emptyAllLivingFromHive(p_49585_, p_49587_, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                p_49584_.updateNeighbourForOutputSignal(p_49586_, this);
                this.angerNearbyBees(p_49584_, p_49586_);
            }
            CriteriaTriggers.BEE_NEST_DESTROYED.trigger((ServerPlayer)p_49585_, p_49587_, p_49589_, $$6.getOccupantCount());
        }
    }

    @Override
    protected void onExplosionHit(BlockState p_364770_, ServerLevel p_364089_, BlockPos p_363677_, Explosion p_365390_, BiConsumer<ItemStack, BlockPos> p_360830_) {
        super.onExplosionHit(p_364770_, p_364089_, p_363677_, p_365390_, p_360830_);
        this.angerNearbyBees(p_364089_, p_363677_);
    }

    private void angerNearbyBees(Level p_49650_, BlockPos p_49651_) {
        AABB $$2 = new AABB(p_49651_).inflate(8.0, 6.0, 8.0);
        List<Bee> $$3 = p_49650_.getEntitiesOfClass(Bee.class, $$2);
        if (!$$3.isEmpty()) {
            List<Player> $$4 = p_49650_.getEntitiesOfClass(Player.class, $$2);
            if ($$4.isEmpty()) {
                return;
            }
            for (Bee $$5 : $$3) {
                if ($$5.getTarget() != null) continue;
                Player $$6 = Util.getRandom($$4, p_49650_.random);
                $$5.setTarget($$6);
            }
        }
    }

    public static void dropHoneycomb(Level p_49601_, BlockPos p_49602_) {
        BeehiveBlock.popResource(p_49601_, p_49602_, new ItemStack(Items.HONEYCOMB, 3));
    }

    @Override
    protected InteractionResult useItemOn(ItemStack p_316844_, BlockState p_316365_, Level p_316306_, BlockPos p_316497_, Player p_316824_, InteractionHand p_316436_, BlockHitResult p_316125_) {
        int $$7 = p_316365_.getValue(HONEY_LEVEL);
        boolean $$8 = false;
        if ($$7 >= 5) {
            Item $$9 = p_316844_.getItem();
            if (p_316844_.is(Items.SHEARS)) {
                p_316306_.playSound(p_316824_, p_316824_.getX(), p_316824_.getY(), p_316824_.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                BeehiveBlock.dropHoneycomb(p_316306_, p_316497_);
                p_316844_.hurtAndBreak(1, p_316824_, LivingEntity.getSlotForHand(p_316436_));
                $$8 = true;
                p_316306_.gameEvent((Entity)p_316824_, GameEvent.SHEAR, p_316497_);
            } else if (p_316844_.is(Items.GLASS_BOTTLE)) {
                p_316844_.shrink(1);
                p_316306_.playSound(p_316824_, p_316824_.getX(), p_316824_.getY(), p_316824_.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (p_316844_.isEmpty()) {
                    p_316824_.setItemInHand(p_316436_, new ItemStack(Items.HONEY_BOTTLE));
                } else if (!p_316824_.getInventory().add(new ItemStack(Items.HONEY_BOTTLE))) {
                    p_316824_.drop(new ItemStack(Items.HONEY_BOTTLE), false);
                }
                $$8 = true;
                p_316306_.gameEvent((Entity)p_316824_, GameEvent.FLUID_PICKUP, p_316497_);
            }
            if (!p_316306_.isClientSide() && $$8) {
                p_316824_.awardStat(Stats.ITEM_USED.get($$9));
            }
        }
        if ($$8) {
            if (!CampfireBlock.isSmokeyPos(p_316306_, p_316497_)) {
                if (this.hiveContainsBees(p_316306_, p_316497_)) {
                    this.angerNearbyBees(p_316306_, p_316497_);
                }
                this.releaseBeesAndResetHoneyLevel(p_316306_, p_316365_, p_316497_, p_316824_, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
            } else {
                this.resetHoneyLevel(p_316306_, p_316365_, p_316497_);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(p_316844_, p_316365_, p_316306_, p_316497_, p_316824_, p_316436_, p_316125_);
    }

    private boolean hiveContainsBees(Level p_49655_, BlockPos p_49656_) {
        BlockEntity $$2 = p_49655_.getBlockEntity(p_49656_);
        if ($$2 instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity $$3 = (BeehiveBlockEntity)$$2;
            return !$$3.isEmpty();
        }
        return false;
    }

    public void releaseBeesAndResetHoneyLevel(Level p_49595_, BlockState p_49596_, BlockPos p_49597_, @Nullable Player p_49598_, BeehiveBlockEntity.BeeReleaseStatus p_49599_) {
        this.resetHoneyLevel(p_49595_, p_49596_, p_49597_);
        BlockEntity $$5 = p_49595_.getBlockEntity(p_49597_);
        if ($$5 instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity $$6 = (BeehiveBlockEntity)$$5;
            $$6.emptyAllLivingFromHive(p_49598_, p_49596_, p_49599_);
        }
    }

    public void resetHoneyLevel(Level p_49591_, BlockState p_49592_, BlockPos p_49593_) {
        p_49591_.setBlock(p_49593_, (BlockState)p_49592_.setValue(HONEY_LEVEL, 0), 3);
    }

    @Override
    public void animateTick(BlockState p_220773_, Level p_220774_, BlockPos p_220775_, RandomSource p_220776_) {
        if (p_220773_.getValue(HONEY_LEVEL) >= 5) {
            for (int $$4 = 0; $$4 < p_220776_.nextInt(1) + 1; ++$$4) {
                this.trySpawnDripParticles(p_220774_, p_220775_, p_220773_);
            }
        }
    }

    private void trySpawnDripParticles(Level p_49604_, BlockPos p_49605_, BlockState p_49606_) {
        if (!p_49606_.getFluidState().isEmpty() || p_49604_.random.nextFloat() < 0.3f) {
            return;
        }
        VoxelShape $$3 = p_49606_.getCollisionShape(p_49604_, p_49605_);
        double $$4 = $$3.max(Direction.Axis.Y);
        if ($$4 >= 1.0 && !p_49606_.is(BlockTags.IMPERMEABLE)) {
            double $$5 = $$3.min(Direction.Axis.Y);
            if ($$5 > 0.0) {
                this.spawnParticle(p_49604_, p_49605_, $$3, (double)p_49605_.getY() + $$5 - 0.05);
            } else {
                BlockPos $$6 = p_49605_.below();
                BlockState $$7 = p_49604_.getBlockState($$6);
                VoxelShape $$8 = $$7.getCollisionShape(p_49604_, $$6);
                double $$9 = $$8.max(Direction.Axis.Y);
                if (($$9 < 1.0 || !$$7.isCollisionShapeFullBlock(p_49604_, $$6)) && $$7.getFluidState().isEmpty()) {
                    this.spawnParticle(p_49604_, p_49605_, $$3, (double)p_49605_.getY() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(Level p_49613_, BlockPos p_49614_, VoxelShape p_49615_, double p_49616_) {
        this.spawnFluidParticle(p_49613_, (double)p_49614_.getX() + p_49615_.min(Direction.Axis.X), (double)p_49614_.getX() + p_49615_.max(Direction.Axis.X), (double)p_49614_.getZ() + p_49615_.min(Direction.Axis.Z), (double)p_49614_.getZ() + p_49615_.max(Direction.Axis.Z), p_49616_);
    }

    private void spawnFluidParticle(Level p_49577_, double p_49578_, double p_49579_, double p_49580_, double p_49581_, double p_49582_) {
        p_49577_.addParticle(ParticleTypes.DRIPPING_HONEY, Mth.lerp(p_49577_.random.nextDouble(), p_49578_, p_49579_), p_49582_, Mth.lerp(p_49577_.random.nextDouble(), p_49580_, p_49581_), 0.0, 0.0, 0.0);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_49573_) {
        return (BlockState)this.defaultBlockState().setValue(FACING, p_49573_.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49646_) {
        p_49646_.add(HONEY_LEVEL, FACING);
    }

    @Override
    protected RenderShape getRenderShape(BlockState p_49653_) {
        return RenderShape.MODEL;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_152184_, BlockState p_152185_) {
        return new BeehiveBlockEntity(p_152184_, p_152185_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return p_152180_.isClientSide ? null : BeehiveBlock.createTickerHelper(p_152182_, BlockEntityType.BEEHIVE, BeehiveBlockEntity::serverTick);
    }

    @Override
    public BlockState playerWillDestroy(Level p_49608_, BlockPos p_49609_, BlockState p_49610_, Player p_49611_) {
        if (p_49608_ instanceof ServerLevel) {
            BlockEntity $$5;
            ServerLevel $$4 = (ServerLevel)p_49608_;
            if (p_49611_.isCreative() && $$4.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && ($$5 = p_49608_.getBlockEntity(p_49609_)) instanceof BeehiveBlockEntity) {
                boolean $$8;
                BeehiveBlockEntity $$6 = (BeehiveBlockEntity)$$5;
                int $$7 = p_49610_.getValue(HONEY_LEVEL);
                boolean bl = $$8 = !$$6.isEmpty();
                if ($$8 || $$7 > 0) {
                    ItemStack $$9 = new ItemStack(this);
                    $$9.applyComponents($$6.collectComponents());
                    $$9.set(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY.with(HONEY_LEVEL, $$7));
                    ItemEntity $$10 = new ItemEntity(p_49608_, p_49609_.getX(), p_49609_.getY(), p_49609_.getZ(), $$9);
                    $$10.setDefaultPickUpDelay();
                    p_49608_.addFreshEntity($$10);
                }
            }
        }
        return super.playerWillDestroy(p_49608_, p_49609_, p_49610_, p_49611_);
    }

    @Override
    protected List<ItemStack> getDrops(BlockState p_49636_, LootParams.Builder p_287581_) {
        BlockEntity $$3;
        Entity $$2 = p_287581_.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (($$2 instanceof PrimedTnt || $$2 instanceof Creeper || $$2 instanceof WitherSkull || $$2 instanceof WitherBoss || $$2 instanceof MinecartTNT) && ($$3 = p_287581_.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity $$4 = (BeehiveBlockEntity)$$3;
            $$4.emptyAllLivingFromHive(null, p_49636_, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.getDrops(p_49636_, p_287581_);
    }

    @Override
    protected BlockState updateShape(BlockState p_49639_, LevelReader p_374043_, ScheduledTickAccess p_374351_, BlockPos p_49643_, Direction p_49640_, BlockPos p_49644_, BlockState p_49641_, RandomSource p_374258_) {
        BlockEntity $$8;
        if (p_374043_.getBlockState(p_49644_).getBlock() instanceof FireBlock && ($$8 = p_374043_.getBlockEntity(p_49643_)) instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity $$9 = (BeehiveBlockEntity)$$8;
            $$9.emptyAllLivingFromHive(null, p_49639_, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.updateShape(p_49639_, p_374043_, p_374351_, p_49643_, p_49640_, p_49644_, p_49641_, p_374258_);
    }

    @Override
    public BlockState rotate(BlockState p_304785_, Rotation p_304624_) {
        return (BlockState)p_304785_.setValue(FACING, p_304624_.rotate(p_304785_.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState p_304677_, Mirror p_304660_) {
        return p_304677_.rotate(p_304660_.getRotation(p_304677_.getValue(FACING)));
    }

    @Override
    public void appendHoverText(ItemStack p_368727_, Item.TooltipContext p_368610_, List<Component> p_368681_, TooltipFlag p_368553_) {
        super.appendHoverText(p_368727_, p_368610_, p_368681_, p_368553_);
        BlockItemStateProperties $$4 = p_368727_.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY);
        int $$5 = Objects.requireNonNullElse($$4.get(HONEY_LEVEL), 0);
        int $$6 = p_368727_.getOrDefault(DataComponents.BEES, List.of()).size();
        p_368681_.add(Component.translatable("container.beehive.bees", $$6, 3).withStyle(ChatFormatting.GRAY));
        p_368681_.add(Component.translatable("container.beehive.honey", $$5, 5).withStyle(ChatFormatting.GRAY));
    }
}

