/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeilingHangingSignBlock
extends SignBlock {
    public static final MapCodec<CeilingHangingSignBlock> CODEC = RecordCodecBuilder.mapCodec(p_368410_ -> p_368410_.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(SignBlock::type), CeilingHangingSignBlock.propertiesCodec()).apply((Applicative)p_368410_, CeilingHangingSignBlock::new));
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    protected static final float AABB_OFFSET = 5.0f;
    protected static final VoxelShape SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final Map<Integer, VoxelShape> AABBS = Maps.newHashMap((Map)ImmutableMap.of((Object)0, (Object)Block.box(1.0, 0.0, 7.0, 15.0, 10.0, 9.0), (Object)4, (Object)Block.box(7.0, 0.0, 1.0, 9.0, 10.0, 15.0), (Object)8, (Object)Block.box(1.0, 0.0, 7.0, 15.0, 10.0, 9.0), (Object)12, (Object)Block.box(7.0, 0.0, 1.0, 9.0, 10.0, 15.0)));

    public MapCodec<CeilingHangingSignBlock> codec() {
        return CODEC;
    }

    public CeilingHangingSignBlock(WoodType p_248716_, BlockBehaviour.Properties p_250481_) {
        super(p_248716_, p_250481_.sound(p_248716_.hangingSignSoundType()));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(ROTATION, 0)).setValue(ATTACHED, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected InteractionResult useItemOn(ItemStack p_316602_, BlockState p_316839_, Level p_316805_, BlockPos p_316894_, Player p_316202_, InteractionHand p_316538_, BlockHitResult p_316895_) {
        SignBlockEntity $$7;
        BlockEntity blockEntity = p_316805_.getBlockEntity(p_316894_);
        if (blockEntity instanceof SignBlockEntity && this.shouldTryToChainAnotherHangingSign(p_316202_, p_316895_, $$7 = (SignBlockEntity)blockEntity, p_316602_)) {
            return InteractionResult.PASS;
        }
        return super.useItemOn(p_316602_, p_316839_, p_316805_, p_316894_, p_316202_, p_316538_, p_316895_);
    }

    private boolean shouldTryToChainAnotherHangingSign(Player p_278279_, BlockHitResult p_278273_, SignBlockEntity p_278236_, ItemStack p_278343_) {
        return !p_278236_.canExecuteClickCommands(p_278236_.isFacingFrontText(p_278279_), p_278279_) && p_278343_.getItem() instanceof HangingSignItem && p_278273_.getDirection().equals(Direction.DOWN);
    }

    @Override
    protected boolean canSurvive(BlockState p_248994_, LevelReader p_249061_, BlockPos p_249490_) {
        return p_249061_.getBlockState(p_249490_.above()).isFaceSturdy(p_249061_, p_249490_.above(), Direction.DOWN, SupportType.CENTER);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_252121_) {
        boolean $$7;
        Level $$1 = p_252121_.getLevel();
        FluidState $$2 = $$1.getFluidState(p_252121_.getClickedPos());
        BlockPos $$3 = p_252121_.getClickedPos().above();
        BlockState $$4 = $$1.getBlockState($$3);
        boolean $$5 = $$4.is(BlockTags.ALL_HANGING_SIGNS);
        Direction $$6 = Direction.fromYRot(p_252121_.getRotation());
        boolean bl = $$7 = !Block.isFaceFull($$4.getCollisionShape($$1, $$3), Direction.DOWN) || p_252121_.isSecondaryUseActive();
        if ($$5 && !p_252121_.isSecondaryUseActive()) {
            Optional<Direction> $$9;
            if ($$4.hasProperty(WallHangingSignBlock.FACING)) {
                Direction $$8 = $$4.getValue(WallHangingSignBlock.FACING);
                if ($$8.getAxis().test($$6)) {
                    $$7 = false;
                }
            } else if ($$4.hasProperty(ROTATION) && ($$9 = RotationSegment.convertToDirection($$4.getValue(ROTATION))).isPresent() && $$9.get().getAxis().test($$6)) {
                $$7 = false;
            }
        }
        int $$10 = !$$7 ? RotationSegment.convertToSegment($$6.getOpposite()) : RotationSegment.convertToSegment(p_252121_.getRotation() + 180.0f);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHED, $$7)).setValue(ROTATION, $$10)).setValue(WATERLOGGED, $$2.getType() == Fluids.WATER);
    }

    @Override
    protected VoxelShape getShape(BlockState p_250564_, BlockGetter p_248998_, BlockPos p_249501_, CollisionContext p_248978_) {
        VoxelShape $$4 = AABBS.get(p_250564_.getValue(ROTATION));
        return $$4 == null ? SHAPE : $$4;
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState p_254482_, BlockGetter p_253669_, BlockPos p_253916_) {
        return this.getShape(p_254482_, p_253669_, p_253916_, CollisionContext.empty());
    }

    @Override
    protected BlockState updateShape(BlockState p_251270_, LevelReader p_374479_, ScheduledTickAccess p_374489_, BlockPos p_249685_, Direction p_250331_, BlockPos p_251506_, BlockState p_249591_, RandomSource p_374041_) {
        if (p_250331_ == Direction.UP && !this.canSurvive(p_251270_, p_374479_, p_249685_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_251270_, p_374479_, p_374489_, p_249685_, p_250331_, p_251506_, p_249591_, p_374041_);
    }

    @Override
    public float getYRotationDegrees(BlockState p_277758_) {
        return RotationSegment.convertToDegrees(p_277758_.getValue(ROTATION));
    }

    @Override
    protected BlockState rotate(BlockState p_251162_, Rotation p_250515_) {
        return (BlockState)p_251162_.setValue(ROTATION, p_250515_.rotate(p_251162_.getValue(ROTATION), 16));
    }

    @Override
    protected BlockState mirror(BlockState p_249682_, Mirror p_250199_) {
        return (BlockState)p_249682_.setValue(ROTATION, p_250199_.mirror(p_249682_.getValue(ROTATION), 16));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_251174_) {
        p_251174_.add(ROTATION, ATTACHED, WATERLOGGED);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_249338_, BlockState p_250706_) {
        return new HangingSignBlockEntity(p_249338_, p_250706_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_279379_, BlockState p_279390_, BlockEntityType<T> p_279231_) {
        return CeilingHangingSignBlock.createTickerHelper(p_279231_, BlockEntityType.HANGING_SIGN, SignBlockEntity::tick);
    }
}

