/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class CreakingHeartBlock
extends BaseEntityBlock {
    public static final MapCodec<CreakingHeartBlock> CODEC = CreakingHeartBlock.simpleCodec(CreakingHeartBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<CreakingHeartState> CREAKING = BlockStateProperties.CREAKING;

    public MapCodec<CreakingHeartBlock> codec() {
        return CODEC;
    }

    protected CreakingHeartBlock(BlockBehaviour.Properties p_380228_) {
        super(p_380228_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, Direction.Axis.Y)).setValue(CREAKING, CreakingHeartState.DISABLED));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_380178_, BlockState p_380317_) {
        return new CreakingHeartBlockEntity(p_380178_, p_380317_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_379447_, BlockState p_379641_, BlockEntityType<T> p_380325_) {
        if (p_379447_.isClientSide) {
            return null;
        }
        if (p_379641_.getValue(CREAKING) != CreakingHeartState.DISABLED) {
            return CreakingHeartBlock.createTickerHelper(p_380325_, BlockEntityType.CREAKING_HEART, CreakingHeartBlockEntity::serverTick);
        }
        return null;
    }

    public static boolean canSummonCreaking(Level p_380307_) {
        return p_380307_.dimensionType().natural() && p_380307_.isNight();
    }

    @Override
    public void animateTick(BlockState p_379556_, Level p_379594_, BlockPos p_379297_, RandomSource p_379301_) {
        if (!CreakingHeartBlock.canSummonCreaking(p_379594_)) {
            return;
        }
        if (p_379556_.getValue(CREAKING) == CreakingHeartState.DISABLED) {
            return;
        }
        if (p_379301_.nextInt(16) == 0 && CreakingHeartBlock.isSurroundedByLogs(p_379594_, p_379297_)) {
            p_379594_.playLocalSound(p_379297_.getX(), p_379297_.getY(), p_379297_.getZ(), SoundEvents.CREAKING_HEART_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected BlockState updateShape(BlockState p_379552_, LevelReader p_379446_, ScheduledTickAccess p_379318_, BlockPos p_379343_, Direction p_380340_, BlockPos p_380150_, BlockState p_379791_, RandomSource p_379888_) {
        BlockState $$8 = super.updateShape(p_379552_, p_379446_, p_379318_, p_379343_, p_380340_, p_380150_, p_379791_, p_379888_);
        return CreakingHeartBlock.updateState($$8, p_379446_, p_379343_);
    }

    private static BlockState updateState(BlockState p_380049_, LevelReader p_379463_, BlockPos p_379599_) {
        boolean $$3 = CreakingHeartBlock.hasRequiredLogs(p_380049_, p_379463_, p_379599_);
        CreakingHeartState $$4 = p_380049_.getValue(CREAKING);
        if ($$3 && $$4 == CreakingHeartState.DISABLED) {
            return (BlockState)p_380049_.setValue(CREAKING, CreakingHeartState.DORMANT);
        }
        return p_380049_;
    }

    public static boolean hasRequiredLogs(BlockState p_379990_, LevelReader p_380123_, BlockPos p_380405_) {
        Direction.Axis $$3 = p_379990_.getValue(AXIS);
        for (Direction $$4 : $$3.getDirections()) {
            BlockState $$5 = p_380123_.getBlockState(p_380405_.relative($$4));
            if ($$5.is(BlockTags.PALE_OAK_LOGS) && $$5.getValue(AXIS) == $$3) continue;
            return false;
        }
        return true;
    }

    private static boolean isSurroundedByLogs(LevelAccessor p_379444_, BlockPos p_380241_) {
        for (Direction $$2 : Direction.values()) {
            BlockPos $$3 = p_380241_.relative($$2);
            BlockState $$4 = p_379444_.getBlockState($$3);
            if ($$4.is(BlockTags.PALE_OAK_LOGS)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_379431_) {
        return CreakingHeartBlock.updateState((BlockState)this.defaultBlockState().setValue(AXIS, p_379431_.getClickedFace().getAxis()), p_379431_.getLevel(), p_379431_.getClickedPos());
    }

    @Override
    protected RenderShape getRenderShape(BlockState p_380006_) {
        return RenderShape.MODEL;
    }

    @Override
    protected BlockState rotate(BlockState p_380251_, Rotation p_379529_) {
        return RotatedPillarBlock.rotatePillar(p_380251_, p_379529_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_379898_) {
        p_379898_.add(AXIS, CREAKING);
    }

    @Override
    protected void onRemove(BlockState p_380377_, Level p_380022_, BlockPos p_379876_, BlockState p_379979_, boolean p_379655_) {
        BlockEntity blockEntity = p_380022_.getBlockEntity(p_379876_);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity $$5 = (CreakingHeartBlockEntity)blockEntity;
            $$5.removeProtector(null);
        }
        super.onRemove(p_380377_, p_380022_, p_379876_, p_379979_, p_379655_);
    }

    @Override
    public BlockState playerWillDestroy(Level p_380319_, BlockPos p_379939_, BlockState p_379928_, Player p_380097_) {
        BlockEntity blockEntity = p_380319_.getBlockEntity(p_379939_);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity $$4 = (CreakingHeartBlockEntity)blockEntity;
            $$4.removeProtector(p_380097_.damageSources().playerAttack(p_380097_));
        }
        return super.playerWillDestroy(p_380319_, p_379939_, p_379928_, p_380097_);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_380993_) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getAnalogOutputSignal(BlockState p_381152_, Level p_381142_, BlockPos p_381148_) {
        void $$4;
        if (p_381152_.getValue(CREAKING) != CreakingHeartState.ACTIVE) {
            return 0;
        }
        BlockEntity blockEntity = p_381142_.getBlockEntity(p_381148_);
        if (!(blockEntity instanceof CreakingHeartBlockEntity)) {
            return 0;
        }
        CreakingHeartBlockEntity $$3 = (CreakingHeartBlockEntity)blockEntity;
        return $$4.getAnalogOutputSignal();
    }

    public static enum CreakingHeartState implements StringRepresentable
    {
        DISABLED("disabled"),
        DORMANT("dormant"),
        ACTIVE("active");

        private final String name;

        private CreakingHeartState(String p_380239_) {
            this.name = p_380239_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }
}

