/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CropBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<CropBlock> CODEC = CropBlock.simpleCodec(CropBlock::new);
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    public MapCodec<? extends CropBlock> codec() {
        return CODEC;
    }

    protected CropBlock(BlockBehaviour.Properties p_52247_) {
        super(p_52247_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(this.getAgeProperty(), 0));
    }

    @Override
    protected VoxelShape getShape(BlockState p_52297_, BlockGetter p_52298_, BlockPos p_52299_, CollisionContext p_52300_) {
        return SHAPE_BY_AGE[this.getAge(p_52297_)];
    }

    @Override
    protected boolean mayPlaceOn(BlockState p_52302_, BlockGetter p_52303_, BlockPos p_52304_) {
        return p_52302_.is(Blocks.FARMLAND);
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(BlockState p_52306_) {
        return p_52306_.getValue(this.getAgeProperty());
    }

    public BlockState getStateForAge(int p_52290_) {
        return (BlockState)this.defaultBlockState().setValue(this.getAgeProperty(), p_52290_);
    }

    public final boolean isMaxAge(BlockState p_52308_) {
        return this.getAge(p_52308_) >= this.getMaxAge();
    }

    @Override
    protected boolean isRandomlyTicking(BlockState p_52288_) {
        return !this.isMaxAge(p_52288_);
    }

    @Override
    protected void randomTick(BlockState p_221050_, ServerLevel p_221051_, BlockPos p_221052_, RandomSource p_221053_) {
        float $$5;
        int $$4;
        if (p_221051_.getRawBrightness(p_221052_, 0) >= 9 && ($$4 = this.getAge(p_221050_)) < this.getMaxAge() && p_221053_.nextInt((int)(25.0f / ($$5 = CropBlock.getGrowthSpeed(this, p_221051_, p_221052_))) + 1) == 0) {
            p_221051_.setBlock(p_221052_, this.getStateForAge($$4 + 1), 2);
        }
    }

    public void growCrops(Level p_52264_, BlockPos p_52265_, BlockState p_52266_) {
        int $$4;
        int $$3 = this.getAge(p_52266_) + this.getBonemealAgeIncrease(p_52264_);
        if ($$3 > ($$4 = this.getMaxAge())) {
            $$3 = $$4;
        }
        p_52264_.setBlock(p_52265_, this.getStateForAge($$3), 2);
    }

    protected int getBonemealAgeIncrease(Level p_52262_) {
        return Mth.nextInt(p_52262_.random, 2, 5);
    }

    protected static float getGrowthSpeed(Block p_52273_, BlockGetter p_52274_, BlockPos p_52275_) {
        boolean $$14;
        float $$3 = 1.0f;
        BlockPos $$4 = p_52275_.below();
        for (int $$5 = -1; $$5 <= 1; ++$$5) {
            for (int $$6 = -1; $$6 <= 1; ++$$6) {
                float $$7 = 0.0f;
                BlockState $$8 = p_52274_.getBlockState($$4.offset($$5, 0, $$6));
                if ($$8.is(Blocks.FARMLAND)) {
                    $$7 = 1.0f;
                    if ($$8.getValue(FarmBlock.MOISTURE) > 0) {
                        $$7 = 3.0f;
                    }
                }
                if ($$5 != 0 || $$6 != 0) {
                    $$7 /= 4.0f;
                }
                $$3 += $$7;
            }
        }
        BlockPos $$9 = p_52275_.north();
        BlockPos $$10 = p_52275_.south();
        BlockPos $$11 = p_52275_.west();
        BlockPos $$12 = p_52275_.east();
        boolean $$13 = p_52274_.getBlockState($$11).is(p_52273_) || p_52274_.getBlockState($$12).is(p_52273_);
        boolean bl = $$14 = p_52274_.getBlockState($$9).is(p_52273_) || p_52274_.getBlockState($$10).is(p_52273_);
        if ($$13 && $$14) {
            $$3 /= 2.0f;
        } else {
            boolean $$15;
            boolean bl2 = $$15 = p_52274_.getBlockState($$11.north()).is(p_52273_) || p_52274_.getBlockState($$12.north()).is(p_52273_) || p_52274_.getBlockState($$12.south()).is(p_52273_) || p_52274_.getBlockState($$11.south()).is(p_52273_);
            if ($$15) {
                $$3 /= 2.0f;
            }
        }
        return $$3;
    }

    @Override
    protected boolean canSurvive(BlockState p_52282_, LevelReader p_52283_, BlockPos p_52284_) {
        return CropBlock.hasSufficientLight(p_52283_, p_52284_) && super.canSurvive(p_52282_, p_52283_, p_52284_);
    }

    protected static boolean hasSufficientLight(LevelReader p_294828_, BlockPos p_295989_) {
        return p_294828_.getRawBrightness(p_295989_, 0) >= 8;
    }

    @Override
    protected void entityInside(BlockState p_52277_, Level p_52278_, BlockPos p_52279_, Entity p_52280_) {
        if (p_52278_ instanceof ServerLevel) {
            ServerLevel $$4 = (ServerLevel)p_52278_;
            if (p_52280_ instanceof Ravager && $$4.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                $$4.destroyBlock(p_52279_, true, p_52280_);
            }
        }
        super.entityInside(p_52277_, p_52278_, p_52279_, p_52280_);
    }

    protected ItemLike getBaseSeedId() {
        return Items.WHEAT_SEEDS;
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader p_304482_, BlockPos p_52255_, BlockState p_52256_) {
        return new ItemStack(this.getBaseSeedId());
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader p_255715_, BlockPos p_52259_, BlockState p_52260_) {
        return !this.isMaxAge(p_52260_);
    }

    @Override
    public boolean isBonemealSuccess(Level p_221045_, RandomSource p_221046_, BlockPos p_221047_, BlockState p_221048_) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel p_221040_, RandomSource p_221041_, BlockPos p_221042_, BlockState p_221043_) {
        this.growCrops(p_221040_, p_221042_, p_221043_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_52286_) {
        p_52286_.add(AGE);
    }
}

