/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;

public class DetectorRailBlock
extends BaseRailBlock {
    public static final MapCodec<DetectorRailBlock> CODEC = DetectorRailBlock.simpleCodec(DetectorRailBlock::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final int PRESSED_CHECK_PERIOD = 20;

    public MapCodec<DetectorRailBlock> codec() {
        return CODEC;
    }

    public DetectorRailBlock(BlockBehaviour.Properties p_52431_) {
        super(true, p_52431_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(POWERED, false)).setValue(SHAPE, RailShape.NORTH_SOUTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected boolean isSignalSource(BlockState p_52489_) {
        return true;
    }

    @Override
    protected void entityInside(BlockState p_52458_, Level p_52459_, BlockPos p_52460_, Entity p_52461_) {
        if (p_52459_.isClientSide) {
            return;
        }
        if (p_52458_.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(p_52459_, p_52460_, p_52458_);
    }

    @Override
    protected void tick(BlockState p_221060_, ServerLevel p_221061_, BlockPos p_221062_, RandomSource p_221063_) {
        if (!p_221060_.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(p_221061_, p_221062_, p_221060_);
    }

    @Override
    protected int getSignal(BlockState p_52449_, BlockGetter p_52450_, BlockPos p_52451_, Direction p_52452_) {
        return p_52449_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState p_52478_, BlockGetter p_52479_, BlockPos p_52480_, Direction p_52481_) {
        if (!p_52478_.getValue(POWERED).booleanValue()) {
            return 0;
        }
        return p_52481_ == Direction.UP ? 15 : 0;
    }

    private void checkPressed(Level p_52433_, BlockPos p_52434_, BlockState p_52435_) {
        if (!this.canSurvive(p_52435_, p_52433_, p_52434_)) {
            return;
        }
        boolean $$3 = p_52435_.getValue(POWERED);
        boolean $$4 = false;
        List<AbstractMinecart> $$5 = this.getInteractingMinecartOfType(p_52433_, p_52434_, AbstractMinecart.class, p_153125_ -> true);
        if (!$$5.isEmpty()) {
            $$4 = true;
        }
        if ($$4 && !$$3) {
            BlockState $$6 = (BlockState)p_52435_.setValue(POWERED, true);
            p_52433_.setBlock(p_52434_, $$6, 3);
            this.updatePowerToConnected(p_52433_, p_52434_, $$6, true);
            p_52433_.updateNeighborsAt(p_52434_, this);
            p_52433_.updateNeighborsAt(p_52434_.below(), this);
            p_52433_.setBlocksDirty(p_52434_, p_52435_, $$6);
        }
        if (!$$4 && $$3) {
            BlockState $$7 = (BlockState)p_52435_.setValue(POWERED, false);
            p_52433_.setBlock(p_52434_, $$7, 3);
            this.updatePowerToConnected(p_52433_, p_52434_, $$7, false);
            p_52433_.updateNeighborsAt(p_52434_, this);
            p_52433_.updateNeighborsAt(p_52434_.below(), this);
            p_52433_.setBlocksDirty(p_52434_, p_52435_, $$7);
        }
        if ($$4) {
            p_52433_.scheduleTick(p_52434_, this, 20);
        }
        p_52433_.updateNeighbourForOutputSignal(p_52434_, this);
    }

    protected void updatePowerToConnected(Level p_52473_, BlockPos p_52474_, BlockState p_52475_, boolean p_52476_) {
        RailState $$4 = new RailState(p_52473_, p_52474_, p_52475_);
        List<BlockPos> $$5 = $$4.getConnections();
        for (BlockPos $$6 : $$5) {
            BlockState $$7 = p_52473_.getBlockState($$6);
            p_52473_.neighborChanged($$7, $$6, $$7.getBlock(), null, false);
        }
    }

    @Override
    protected void onPlace(BlockState p_52483_, Level p_52484_, BlockPos p_52485_, BlockState p_52486_, boolean p_52487_) {
        if (p_52486_.is(p_52483_.getBlock())) {
            return;
        }
        BlockState $$5 = this.updateState(p_52483_, p_52484_, p_52485_, p_52487_);
        this.checkPressed(p_52484_, p_52485_, $$5);
    }

    @Override
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_52442_) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState p_52454_, Level p_52455_, BlockPos p_52456_) {
        if (p_52454_.getValue(POWERED).booleanValue()) {
            List<MinecartCommandBlock> $$3 = this.getInteractingMinecartOfType(p_52455_, p_52456_, MinecartCommandBlock.class, p_153123_ -> true);
            if (!$$3.isEmpty()) {
                return $$3.get(0).getCommandBlock().getSuccessCount();
            }
            List<AbstractMinecart> $$4 = this.getInteractingMinecartOfType(p_52455_, p_52456_, AbstractMinecart.class, EntitySelector.CONTAINER_ENTITY_SELECTOR);
            if (!$$4.isEmpty()) {
                return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Object)$$4.get(0)));
            }
        }
        return 0;
    }

    private <T extends AbstractMinecart> List<T> getInteractingMinecartOfType(Level p_52437_, BlockPos p_52438_, Class<T> p_52439_, Predicate<Entity> p_52440_) {
        return p_52437_.getEntitiesOfClass(p_52439_, this.getSearchBB(p_52438_), p_52440_);
    }

    private AABB getSearchBB(BlockPos p_52471_) {
        double $$1 = 0.2;
        return new AABB((double)p_52471_.getX() + 0.2, p_52471_.getY(), (double)p_52471_.getZ() + 0.2, (double)(p_52471_.getX() + 1) - 0.2, (double)(p_52471_.getY() + 1) - 0.2, (double)(p_52471_.getZ() + 1) - 0.2);
    }

    @Override
    protected BlockState rotate(BlockState p_52466_, Rotation p_52467_) {
        switch (p_52467_) {
            case CLOCKWISE_180: {
                switch (p_52466_.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (p_52466_.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (p_52466_.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52466_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                }
            }
        }
        return p_52466_;
    }

    @Override
    protected BlockState mirror(BlockState p_52463_, Mirror p_52464_) {
        RailShape $$2 = p_52463_.getValue(SHAPE);
        switch (p_52464_) {
            case LEFT_RIGHT: {
                switch ($$2) {
                    case ASCENDING_NORTH: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                }
                break;
            }
            case FRONT_BACK: {
                switch ($$2) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52463_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                }
                break;
            }
        }
        return super.mirror(p_52463_, p_52464_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_52469_) {
        p_52469_.add(SHAPE, POWERED, WATERLOGGED);
    }
}

