/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoorBlock
extends Block {
    public static final MapCodec<DoorBlock> CODEC = RecordCodecBuilder.mapCodec(p_368420_ -> p_368420_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(DoorBlock::type), DoorBlock.propertiesCodec()).apply((Applicative)p_368420_, DoorBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final float AABB_DOOR_THICKNESS = 3.0f;
    protected static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    private final BlockSetType type;

    public MapCodec<? extends DoorBlock> codec() {
        return CODEC;
    }

    protected DoorBlock(BlockSetType p_272854_, BlockBehaviour.Properties p_273303_) {
        super(p_273303_.sound(p_272854_.soundType()));
        this.type = p_272854_;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(OPEN, false)).setValue(HINGE, DoorHingeSide.LEFT)).setValue(POWERED, false)).setValue(HALF, DoubleBlockHalf.LOWER));
    }

    public BlockSetType type() {
        return this.type;
    }

    @Override
    protected VoxelShape getShape(BlockState p_52807_, BlockGetter p_52808_, BlockPos p_52809_, CollisionContext p_52810_) {
        Direction $$4 = p_52807_.getValue(FACING);
        boolean $$5 = p_52807_.getValue(OPEN) == false;
        boolean $$6 = p_52807_.getValue(HINGE) == DoorHingeSide.RIGHT;
        return switch ($$4) {
            default -> {
                if ($$5) {
                    yield EAST_AABB;
                }
                if ($$6) {
                    yield NORTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.SOUTH -> {
                if ($$5) {
                    yield SOUTH_AABB;
                }
                if ($$6) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if ($$5) {
                    yield WEST_AABB;
                }
                if ($$6) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> $$5 ? NORTH_AABB : ($$6 ? WEST_AABB : EAST_AABB);
        };
    }

    @Override
    protected BlockState updateShape(BlockState p_52796_, LevelReader p_374501_, ScheduledTickAccess p_374380_, BlockPos p_52800_, Direction p_52797_, BlockPos p_52801_, BlockState p_52798_, RandomSource p_374395_) {
        DoubleBlockHalf $$8 = p_52796_.getValue(HALF);
        if (p_52797_.getAxis() == Direction.Axis.Y && $$8 == DoubleBlockHalf.LOWER == (p_52797_ == Direction.UP)) {
            if (p_52798_.getBlock() instanceof DoorBlock && p_52798_.getValue(HALF) != $$8) {
                return (BlockState)p_52798_.setValue(HALF, $$8);
            }
            return Blocks.AIR.defaultBlockState();
        }
        if ($$8 == DoubleBlockHalf.LOWER && p_52797_ == Direction.DOWN && !p_52796_.canSurvive(p_374501_, p_52800_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_52796_, p_374501_, p_374380_, p_52800_, p_52797_, p_52801_, p_52798_, p_374395_);
    }

    @Override
    protected void onExplosionHit(BlockState p_312769_, ServerLevel p_363080_, BlockPos p_311900_, Explosion p_312544_, BiConsumer<ItemStack, BlockPos> p_312107_) {
        if (p_312544_.canTriggerBlocks() && p_312769_.getValue(HALF) == DoubleBlockHalf.LOWER && this.type.canOpenByWindCharge() && !p_312769_.getValue(POWERED).booleanValue()) {
            this.setOpen(null, p_363080_, p_312769_, p_311900_, !this.isOpen(p_312769_));
        }
        super.onExplosionHit(p_312769_, p_363080_, p_311900_, p_312544_, p_312107_);
    }

    @Override
    public BlockState playerWillDestroy(Level p_52755_, BlockPos p_52756_, BlockState p_52757_, Player p_52758_) {
        if (!(p_52755_.isClientSide || !p_52758_.isCreative() && p_52758_.hasCorrectToolForDrops(p_52757_))) {
            DoublePlantBlock.preventDropFromBottomPart(p_52755_, p_52756_, p_52757_, p_52758_);
        }
        return super.playerWillDestroy(p_52755_, p_52756_, p_52757_, p_52758_);
    }

    @Override
    protected boolean isPathfindable(BlockState p_52764_, PathComputationType p_52767_) {
        return switch (p_52767_) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> p_52764_.getValue(OPEN);
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_52739_) {
        BlockPos $$1 = p_52739_.getClickedPos();
        Level $$2 = p_52739_.getLevel();
        if ($$1.getY() < $$2.getMaxY() && $$2.getBlockState($$1.above()).canBeReplaced(p_52739_)) {
            boolean $$3 = $$2.hasNeighborSignal($$1) || $$2.hasNeighborSignal($$1.above());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, p_52739_.getHorizontalDirection())).setValue(HINGE, this.getHinge(p_52739_))).setValue(POWERED, $$3)).setValue(OPEN, $$3)).setValue(HALF, DoubleBlockHalf.LOWER);
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level p_52749_, BlockPos p_52750_, BlockState p_52751_, LivingEntity p_52752_, ItemStack p_52753_) {
        p_52749_.setBlock(p_52750_.above(), (BlockState)p_52751_.setValue(HALF, DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext p_52805_) {
        boolean $$17;
        Level $$1 = p_52805_.getLevel();
        BlockPos $$2 = p_52805_.getClickedPos();
        Direction $$3 = p_52805_.getHorizontalDirection();
        BlockPos $$4 = $$2.above();
        Direction $$5 = $$3.getCounterClockWise();
        BlockPos $$6 = $$2.relative($$5);
        BlockState $$7 = $$1.getBlockState($$6);
        BlockPos $$8 = $$4.relative($$5);
        BlockState $$9 = $$1.getBlockState($$8);
        Direction $$10 = $$3.getClockWise();
        BlockPos $$11 = $$2.relative($$10);
        BlockState $$12 = $$1.getBlockState($$11);
        BlockPos $$13 = $$4.relative($$10);
        BlockState $$14 = $$1.getBlockState($$13);
        int $$15 = ($$7.isCollisionShapeFullBlock($$1, $$6) ? -1 : 0) + ($$9.isCollisionShapeFullBlock($$1, $$8) ? -1 : 0) + ($$12.isCollisionShapeFullBlock($$1, $$11) ? 1 : 0) + ($$14.isCollisionShapeFullBlock($$1, $$13) ? 1 : 0);
        boolean $$16 = $$7.getBlock() instanceof DoorBlock && $$7.getValue(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = $$17 = $$12.getBlock() instanceof DoorBlock && $$12.getValue(HALF) == DoubleBlockHalf.LOWER;
        if ($$16 && !$$17 || $$15 > 0) {
            return DoorHingeSide.RIGHT;
        }
        if ($$17 && !$$16 || $$15 < 0) {
            return DoorHingeSide.LEFT;
        }
        int $$18 = $$3.getStepX();
        int $$19 = $$3.getStepZ();
        Vec3 $$20 = p_52805_.getClickLocation();
        double $$21 = $$20.x - (double)$$2.getX();
        double $$22 = $$20.z - (double)$$2.getZ();
        return $$18 < 0 && $$22 < 0.5 || $$18 > 0 && $$22 > 0.5 || $$19 < 0 && $$21 > 0.5 || $$19 > 0 && $$21 < 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_52769_, Level p_52770_, BlockPos p_52771_, Player p_52772_, BlockHitResult p_52774_) {
        if (!this.type.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        p_52769_ = (BlockState)p_52769_.cycle(OPEN);
        p_52770_.setBlock(p_52771_, p_52769_, 10);
        this.playSound(p_52772_, p_52770_, p_52771_, p_52769_.getValue(OPEN));
        p_52770_.gameEvent((Entity)p_52772_, this.isOpen(p_52769_) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_52771_);
        return InteractionResult.SUCCESS;
    }

    public boolean isOpen(BlockState p_52816_) {
        return p_52816_.getValue(OPEN);
    }

    public void setOpen(@Nullable Entity p_153166_, Level p_153167_, BlockState p_153168_, BlockPos p_153169_, boolean p_153170_) {
        if (!p_153168_.is(this) || p_153168_.getValue(OPEN) == p_153170_) {
            return;
        }
        p_153167_.setBlock(p_153169_, (BlockState)p_153168_.setValue(OPEN, p_153170_), 10);
        this.playSound(p_153166_, p_153167_, p_153169_, p_153170_);
        p_153167_.gameEvent(p_153166_, p_153170_ ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_153169_);
    }

    @Override
    protected void neighborChanged(BlockState p_52776_, Level p_52777_, BlockPos p_52778_, Block p_52779_, @Nullable Orientation p_361881_, boolean p_52781_) {
        boolean $$6;
        boolean bl = p_52777_.hasNeighborSignal(p_52778_) || p_52777_.hasNeighborSignal(p_52778_.relative(p_52776_.getValue(HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : ($$6 = false);
        if (!this.defaultBlockState().is(p_52779_) && $$6 != p_52776_.getValue(POWERED)) {
            if ($$6 != p_52776_.getValue(OPEN)) {
                this.playSound(null, p_52777_, p_52778_, $$6);
                p_52777_.gameEvent(null, $$6 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_52778_);
            }
            p_52777_.setBlock(p_52778_, (BlockState)((BlockState)p_52776_.setValue(POWERED, $$6)).setValue(OPEN, $$6), 2);
        }
    }

    @Override
    protected boolean canSurvive(BlockState p_52783_, LevelReader p_52784_, BlockPos p_52785_) {
        BlockPos $$3 = p_52785_.below();
        BlockState $$4 = p_52784_.getBlockState($$3);
        if (p_52783_.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return $$4.isFaceSturdy(p_52784_, $$3, Direction.UP);
        }
        return $$4.is(this);
    }

    private void playSound(@Nullable Entity p_251616_, Level p_249656_, BlockPos p_249439_, boolean p_251628_) {
        p_249656_.playSound(p_251616_, p_249439_, p_251628_ ? this.type.doorOpen() : this.type.doorClose(), SoundSource.BLOCKS, 1.0f, p_249656_.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected BlockState rotate(BlockState p_52790_, Rotation p_52791_) {
        return (BlockState)p_52790_.setValue(FACING, p_52791_.rotate(p_52790_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_52787_, Mirror p_52788_) {
        if (p_52788_ == Mirror.NONE) {
            return p_52787_;
        }
        return (BlockState)p_52787_.rotate(p_52788_.getRotation(p_52787_.getValue(FACING))).cycle(HINGE);
    }

    @Override
    protected long getSeed(BlockState p_52793_, BlockPos p_52794_) {
        return Mth.getSeed(p_52794_.getX(), p_52794_.below(p_52793_.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), p_52794_.getZ());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_52803_) {
        p_52803_.add(HALF, FACING, OPEN, HINGE, POWERED);
    }

    public static boolean isWoodenDoor(Level p_52746_, BlockPos p_52747_) {
        return DoorBlock.isWoodenDoor(p_52746_.getBlockState(p_52747_));
    }

    public static boolean isWoodenDoor(BlockState p_52818_) {
        DoorBlock $$1;
        Block block = p_52818_.getBlock();
        return block instanceof DoorBlock && ($$1 = (DoorBlock)block).type().canOpenByHand();
    }
}

