/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnderChestBlock
extends AbstractChestBlock<EnderChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final MapCodec<EnderChestBlock> CODEC = EnderChestBlock.simpleCodec(EnderChestBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final Component CONTAINER_TITLE = Component.translatable("container.enderchest");

    @Override
    public MapCodec<EnderChestBlock> codec() {
        return CODEC;
    }

    protected EnderChestBlock(BlockBehaviour.Properties p_53121_) {
        super(p_53121_, () -> BlockEntityType.ENDER_CHEST);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    public DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> combine(BlockState p_53149_, Level p_53150_, BlockPos p_53151_, boolean p_53152_) {
        return DoubleBlockCombiner.Combiner::acceptNone;
    }

    @Override
    protected VoxelShape getShape(BlockState p_53171_, BlockGetter p_53172_, BlockPos p_53173_, CollisionContext p_53174_) {
        return SHAPE;
    }

    @Override
    protected RenderShape getRenderShape(BlockState p_53169_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_53128_) {
        FluidState $$1 = p_53128_.getLevel().getFluidState(p_53128_.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, p_53128_.getHorizontalDirection().getOpposite())).setValue(WATERLOGGED, $$1.getType() == Fluids.WATER);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected InteractionResult useWithoutItem(BlockState p_53137_, Level p_53138_, BlockPos p_53139_, Player p_53140_, BlockHitResult p_53142_) {
        PlayerEnderChestContainer $$5 = p_53140_.getEnderChestInventory();
        BlockEntity $$6 = p_53138_.getBlockEntity(p_53139_);
        if ($$5 == null || !($$6 instanceof EnderChestBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        EnderChestBlockEntity $$7 = (EnderChestBlockEntity)$$6;
        BlockPos $$9 = p_53139_.above();
        if (p_53138_.getBlockState($$9).isRedstoneConductor(p_53138_, $$9)) {
            return InteractionResult.SUCCESS;
        }
        if (p_53138_ instanceof ServerLevel) {
            void $$8;
            ServerLevel $$10 = (ServerLevel)p_53138_;
            $$5.setActiveChest((EnderChestBlockEntity)$$8);
            p_53140_.openMenu(new SimpleMenuProvider((p_53124_, p_53125_, p_53126_) -> ChestMenu.threeRows(p_53124_, p_53125_, $$5), CONTAINER_TITLE));
            p_53140_.awardStat(Stats.OPEN_ENDERCHEST);
            PiglinAi.angerNearbyPiglins($$10, p_53140_, true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_153208_, BlockState p_153209_) {
        return new EnderChestBlockEntity(p_153208_, p_153209_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153199_, BlockState p_153200_, BlockEntityType<T> p_153201_) {
        return p_153199_.isClientSide ? EnderChestBlock.createTickerHelper(p_153201_, BlockEntityType.ENDER_CHEST, EnderChestBlockEntity::lidAnimateTick) : null;
    }

    @Override
    public void animateTick(BlockState p_221117_, Level p_221118_, BlockPos p_221119_, RandomSource p_221120_) {
        for (int $$4 = 0; $$4 < 3; ++$$4) {
            int $$5 = p_221120_.nextInt(2) * 2 - 1;
            int $$6 = p_221120_.nextInt(2) * 2 - 1;
            double $$7 = (double)p_221119_.getX() + 0.5 + 0.25 * (double)$$5;
            double $$8 = (float)p_221119_.getY() + p_221120_.nextFloat();
            double $$9 = (double)p_221119_.getZ() + 0.5 + 0.25 * (double)$$6;
            double $$10 = p_221120_.nextFloat() * (float)$$5;
            double $$11 = ((double)p_221120_.nextFloat() - 0.5) * 0.125;
            double $$12 = p_221120_.nextFloat() * (float)$$6;
            p_221118_.addParticle(ParticleTypes.PORTAL, $$7, $$8, $$9, $$10, $$11, $$12);
        }
    }

    @Override
    protected BlockState rotate(BlockState p_53157_, Rotation p_53158_) {
        return (BlockState)p_53157_.setValue(FACING, p_53158_.rotate(p_53157_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_53154_, Mirror p_53155_) {
        return p_53154_.rotate(p_53155_.getRotation(p_53154_.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53167_) {
        p_53167_.add(FACING, WATERLOGGED);
    }

    @Override
    protected FluidState getFluidState(BlockState p_53177_) {
        if (p_53177_.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(p_53177_);
    }

    @Override
    protected BlockState updateShape(BlockState p_53160_, LevelReader p_374322_, ScheduledTickAccess p_374149_, BlockPos p_53164_, Direction p_53161_, BlockPos p_53165_, BlockState p_53162_, RandomSource p_374199_) {
        if (p_53160_.getValue(WATERLOGGED).booleanValue()) {
            p_374149_.scheduleTick(p_53164_, Fluids.WATER, Fluids.WATER.getTickDelay(p_374322_));
        }
        return super.updateShape(p_53160_, p_374322_, p_374149_, p_53164_, p_53161_, p_53165_, p_53162_, p_374199_);
    }

    @Override
    protected boolean isPathfindable(BlockState p_53132_, PathComputationType p_53135_) {
        return false;
    }

    @Override
    protected void tick(BlockState p_221112_, ServerLevel p_221113_, BlockPos p_221114_, RandomSource p_221115_) {
        BlockEntity $$4 = p_221113_.getBlockEntity(p_221114_);
        if ($$4 instanceof EnderChestBlockEntity) {
            ((EnderChestBlockEntity)$$4).recheckOpen();
        }
    }
}

