/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FireBlock
extends BaseFireBlock {
    public static final MapCodec<FireBlock> CODEC = FireBlock.simpleCodec(FireBlock::new);
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_53467_ -> p_53467_.getKey() != Direction.DOWN).collect(Util.toMap());
    private static final VoxelShape UP_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    private static final int IGNITE_INSTANT = 60;
    private static final int IGNITE_EASY = 30;
    private static final int IGNITE_MEDIUM = 15;
    private static final int IGNITE_HARD = 5;
    private static final int BURN_INSTANT = 100;
    private static final int BURN_EASY = 60;
    private static final int BURN_MEDIUM = 20;
    private static final int BURN_HARD = 5;
    private final Object2IntMap<Block> igniteOdds = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> burnOdds = new Object2IntOpenHashMap();

    public MapCodec<FireBlock> codec() {
        return CODEC;
    }

    public FireBlock(BlockBehaviour.Properties p_53425_) {
        super(p_53425_, 1.0f);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(UP, false));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().filter(p_53497_ -> p_53497_.getValue(AGE) == 0).collect(Collectors.toMap(Function.identity(), FireBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_53491_) {
        VoxelShape $$1 = Shapes.empty();
        if (p_53491_.getValue(UP).booleanValue()) {
            $$1 = UP_AABB;
        }
        if (p_53491_.getValue(NORTH).booleanValue()) {
            $$1 = Shapes.or($$1, NORTH_AABB);
        }
        if (p_53491_.getValue(SOUTH).booleanValue()) {
            $$1 = Shapes.or($$1, SOUTH_AABB);
        }
        if (p_53491_.getValue(EAST).booleanValue()) {
            $$1 = Shapes.or($$1, EAST_AABB);
        }
        if (p_53491_.getValue(WEST).booleanValue()) {
            $$1 = Shapes.or($$1, WEST_AABB);
        }
        return $$1.isEmpty() ? DOWN_AABB : $$1;
    }

    @Override
    protected BlockState updateShape(BlockState p_53458_, LevelReader p_374288_, ScheduledTickAccess p_374582_, BlockPos p_53462_, Direction p_53459_, BlockPos p_53463_, BlockState p_53460_, RandomSource p_374484_) {
        if (this.canSurvive(p_53458_, p_374288_, p_53462_)) {
            return this.getStateWithAge(p_374288_, p_53462_, p_53458_.getValue(AGE));
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected VoxelShape getShape(BlockState p_53474_, BlockGetter p_53475_, BlockPos p_53476_, CollisionContext p_53477_) {
        return this.shapesCache.get(p_53474_.setValue(AGE, 0));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_53427_) {
        return this.getStateForPlacement(p_53427_.getLevel(), p_53427_.getClickedPos());
    }

    protected BlockState getStateForPlacement(BlockGetter p_53471_, BlockPos p_53472_) {
        BlockPos $$2 = p_53472_.below();
        BlockState $$3 = p_53471_.getBlockState($$2);
        if (this.canBurn($$3) || $$3.isFaceSturdy(p_53471_, $$2, Direction.UP)) {
            return this.defaultBlockState();
        }
        BlockState $$4 = this.defaultBlockState();
        for (Direction $$5 : Direction.values()) {
            BooleanProperty $$6 = PROPERTY_BY_DIRECTION.get($$5);
            if ($$6 == null) continue;
            $$4 = (BlockState)$$4.setValue($$6, this.canBurn(p_53471_.getBlockState(p_53472_.relative($$5))));
        }
        return $$4;
    }

    @Override
    protected boolean canSurvive(BlockState p_53454_, LevelReader p_53455_, BlockPos p_53456_) {
        BlockPos $$3 = p_53456_.below();
        return p_53455_.getBlockState($$3).isFaceSturdy(p_53455_, $$3, Direction.UP) || this.isValidFireLocation(p_53455_, p_53456_);
    }

    @Override
    protected void tick(BlockState p_221160_, ServerLevel p_221161_, BlockPos p_221162_, RandomSource p_221163_) {
        boolean $$9;
        p_221161_.scheduleTick(p_221162_, this, FireBlock.getFireTickDelay(p_221161_.random));
        if (!p_221161_.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            return;
        }
        if (!p_221160_.canSurvive(p_221161_, p_221162_)) {
            p_221161_.removeBlock(p_221162_, false);
        }
        BlockState $$4 = p_221161_.getBlockState(p_221162_.below());
        boolean $$5 = $$4.is(p_221161_.dimensionType().infiniburn());
        int $$6 = p_221160_.getValue(AGE);
        if (!$$5 && p_221161_.isRaining() && this.isNearRain(p_221161_, p_221162_) && p_221163_.nextFloat() < 0.2f + (float)$$6 * 0.03f) {
            p_221161_.removeBlock(p_221162_, false);
            return;
        }
        int $$7 = Math.min(15, $$6 + p_221163_.nextInt(3) / 2);
        if ($$6 != $$7) {
            p_221160_ = (BlockState)p_221160_.setValue(AGE, $$7);
            p_221161_.setBlock(p_221162_, p_221160_, 4);
        }
        if (!$$5) {
            if (!this.isValidFireLocation(p_221161_, p_221162_)) {
                BlockPos $$8 = p_221162_.below();
                if (!p_221161_.getBlockState($$8).isFaceSturdy(p_221161_, $$8, Direction.UP) || $$6 > 3) {
                    p_221161_.removeBlock(p_221162_, false);
                }
                return;
            }
            if ($$6 == 15 && p_221163_.nextInt(4) == 0 && !this.canBurn(p_221161_.getBlockState(p_221162_.below()))) {
                p_221161_.removeBlock(p_221162_, false);
                return;
            }
        }
        int $$10 = ($$9 = p_221161_.getBiome(p_221162_).is(BiomeTags.INCREASED_FIRE_BURNOUT)) ? -50 : 0;
        this.checkBurnOut(p_221161_, p_221162_.east(), 300 + $$10, p_221163_, $$6);
        this.checkBurnOut(p_221161_, p_221162_.west(), 300 + $$10, p_221163_, $$6);
        this.checkBurnOut(p_221161_, p_221162_.below(), 250 + $$10, p_221163_, $$6);
        this.checkBurnOut(p_221161_, p_221162_.above(), 250 + $$10, p_221163_, $$6);
        this.checkBurnOut(p_221161_, p_221162_.north(), 300 + $$10, p_221163_, $$6);
        this.checkBurnOut(p_221161_, p_221162_.south(), 300 + $$10, p_221163_, $$6);
        BlockPos.MutableBlockPos $$11 = new BlockPos.MutableBlockPos();
        for (int $$12 = -1; $$12 <= 1; ++$$12) {
            for (int $$13 = -1; $$13 <= 1; ++$$13) {
                for (int $$14 = -1; $$14 <= 4; ++$$14) {
                    if ($$12 == 0 && $$14 == 0 && $$13 == 0) continue;
                    int $$15 = 100;
                    if ($$14 > 1) {
                        $$15 += ($$14 - 1) * 100;
                    }
                    $$11.setWithOffset(p_221162_, $$12, $$14, $$13);
                    int $$16 = this.getIgniteOdds(p_221161_, $$11);
                    if ($$16 <= 0) continue;
                    int $$17 = ($$16 + 40 + p_221161_.getDifficulty().getId() * 7) / ($$6 + 30);
                    if ($$9) {
                        $$17 /= 2;
                    }
                    if ($$17 <= 0 || p_221163_.nextInt($$15) > $$17 || p_221161_.isRaining() && this.isNearRain(p_221161_, $$11)) continue;
                    int $$18 = Math.min(15, $$6 + p_221163_.nextInt(5) / 4);
                    p_221161_.setBlock($$11, this.getStateWithAge(p_221161_, $$11, $$18), 3);
                }
            }
        }
    }

    protected boolean isNearRain(Level p_53429_, BlockPos p_53430_) {
        return p_53429_.isRainingAt(p_53430_) || p_53429_.isRainingAt(p_53430_.west()) || p_53429_.isRainingAt(p_53430_.east()) || p_53429_.isRainingAt(p_53430_.north()) || p_53429_.isRainingAt(p_53430_.south());
    }

    private int getBurnOdds(BlockState p_221165_) {
        if (p_221165_.hasProperty(BlockStateProperties.WATERLOGGED) && p_221165_.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
            return 0;
        }
        return this.burnOdds.getInt((Object)p_221165_.getBlock());
    }

    private int getIgniteOdds(BlockState p_221167_) {
        if (p_221167_.hasProperty(BlockStateProperties.WATERLOGGED) && p_221167_.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
            return 0;
        }
        return this.igniteOdds.getInt((Object)p_221167_.getBlock());
    }

    private void checkBurnOut(Level p_221151_, BlockPos p_221152_, int p_221153_, RandomSource p_221154_, int p_221155_) {
        int $$5 = this.getBurnOdds(p_221151_.getBlockState(p_221152_));
        if (p_221154_.nextInt(p_221153_) < $$5) {
            BlockState $$6 = p_221151_.getBlockState(p_221152_);
            if (p_221154_.nextInt(p_221155_ + 10) < 5 && !p_221151_.isRainingAt(p_221152_)) {
                int $$7 = Math.min(p_221155_ + p_221154_.nextInt(5) / 4, 15);
                p_221151_.setBlock(p_221152_, this.getStateWithAge(p_221151_, p_221152_, $$7), 3);
            } else {
                p_221151_.removeBlock(p_221152_, false);
            }
            Block $$8 = $$6.getBlock();
            if ($$8 instanceof TntBlock) {
                TntBlock.explode(p_221151_, p_221152_);
            }
        }
    }

    private BlockState getStateWithAge(LevelReader p_374519_, BlockPos p_53439_, int p_53440_) {
        BlockState $$3 = FireBlock.getState(p_374519_, p_53439_);
        if ($$3.is(Blocks.FIRE)) {
            return (BlockState)$$3.setValue(AGE, p_53440_);
        }
        return $$3;
    }

    private boolean isValidFireLocation(BlockGetter p_53486_, BlockPos p_53487_) {
        for (Direction $$2 : Direction.values()) {
            if (!this.canBurn(p_53486_.getBlockState(p_53487_.relative($$2)))) continue;
            return true;
        }
        return false;
    }

    private int getIgniteOdds(LevelReader p_221157_, BlockPos p_221158_) {
        if (!p_221157_.isEmptyBlock(p_221158_)) {
            return 0;
        }
        int $$2 = 0;
        for (Direction $$3 : Direction.values()) {
            BlockState $$4 = p_221157_.getBlockState(p_221158_.relative($$3));
            $$2 = Math.max(this.getIgniteOdds($$4), $$2);
        }
        return $$2;
    }

    @Override
    protected boolean canBurn(BlockState p_53489_) {
        return this.getIgniteOdds(p_53489_) > 0;
    }

    @Override
    protected void onPlace(BlockState p_53479_, Level p_53480_, BlockPos p_53481_, BlockState p_53482_, boolean p_53483_) {
        super.onPlace(p_53479_, p_53480_, p_53481_, p_53482_, p_53483_);
        p_53480_.scheduleTick(p_53481_, this, FireBlock.getFireTickDelay(p_53480_.random));
    }

    private static int getFireTickDelay(RandomSource p_221149_) {
        return 30 + p_221149_.nextInt(10);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53465_) {
        p_53465_.add(AGE, NORTH, EAST, SOUTH, WEST, UP);
    }

    public void setFlammable(Block p_53445_, int p_53446_, int p_53447_) {
        this.igniteOdds.put((Object)p_53445_, p_53446_);
        this.burnOdds.put((Object)p_53445_, p_53447_);
    }

    public static void bootStrap() {
        FireBlock $$0 = (FireBlock)Blocks.FIRE;
        $$0.setFlammable(Blocks.OAK_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.SPRUCE_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.BIRCH_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.JUNGLE_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.ACACIA_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.CHERRY_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.DARK_OAK_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.PALE_OAK_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.MANGROVE_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.BAMBOO_PLANKS, 5, 20);
        $$0.setFlammable(Blocks.BAMBOO_MOSAIC, 5, 20);
        $$0.setFlammable(Blocks.OAK_SLAB, 5, 20);
        $$0.setFlammable(Blocks.SPRUCE_SLAB, 5, 20);
        $$0.setFlammable(Blocks.BIRCH_SLAB, 5, 20);
        $$0.setFlammable(Blocks.JUNGLE_SLAB, 5, 20);
        $$0.setFlammable(Blocks.ACACIA_SLAB, 5, 20);
        $$0.setFlammable(Blocks.CHERRY_SLAB, 5, 20);
        $$0.setFlammable(Blocks.DARK_OAK_SLAB, 5, 20);
        $$0.setFlammable(Blocks.PALE_OAK_SLAB, 5, 20);
        $$0.setFlammable(Blocks.MANGROVE_SLAB, 5, 20);
        $$0.setFlammable(Blocks.BAMBOO_SLAB, 5, 20);
        $$0.setFlammable(Blocks.BAMBOO_MOSAIC_SLAB, 5, 20);
        $$0.setFlammable(Blocks.OAK_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.SPRUCE_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.BIRCH_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.JUNGLE_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.ACACIA_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.CHERRY_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.DARK_OAK_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.PALE_OAK_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.MANGROVE_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.BAMBOO_FENCE_GATE, 5, 20);
        $$0.setFlammable(Blocks.OAK_FENCE, 5, 20);
        $$0.setFlammable(Blocks.SPRUCE_FENCE, 5, 20);
        $$0.setFlammable(Blocks.BIRCH_FENCE, 5, 20);
        $$0.setFlammable(Blocks.JUNGLE_FENCE, 5, 20);
        $$0.setFlammable(Blocks.ACACIA_FENCE, 5, 20);
        $$0.setFlammable(Blocks.CHERRY_FENCE, 5, 20);
        $$0.setFlammable(Blocks.DARK_OAK_FENCE, 5, 20);
        $$0.setFlammable(Blocks.PALE_OAK_FENCE, 5, 20);
        $$0.setFlammable(Blocks.MANGROVE_FENCE, 5, 20);
        $$0.setFlammable(Blocks.BAMBOO_FENCE, 5, 20);
        $$0.setFlammable(Blocks.OAK_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.BIRCH_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.SPRUCE_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.JUNGLE_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.ACACIA_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.CHERRY_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.DARK_OAK_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.PALE_OAK_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.MANGROVE_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.BAMBOO_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.BAMBOO_MOSAIC_STAIRS, 5, 20);
        $$0.setFlammable(Blocks.OAK_LOG, 5, 5);
        $$0.setFlammable(Blocks.SPRUCE_LOG, 5, 5);
        $$0.setFlammable(Blocks.BIRCH_LOG, 5, 5);
        $$0.setFlammable(Blocks.JUNGLE_LOG, 5, 5);
        $$0.setFlammable(Blocks.ACACIA_LOG, 5, 5);
        $$0.setFlammable(Blocks.CHERRY_LOG, 5, 5);
        $$0.setFlammable(Blocks.PALE_OAK_LOG, 5, 5);
        $$0.setFlammable(Blocks.DARK_OAK_LOG, 5, 5);
        $$0.setFlammable(Blocks.MANGROVE_LOG, 5, 5);
        $$0.setFlammable(Blocks.BAMBOO_BLOCK, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_OAK_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_SPRUCE_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_BIRCH_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_JUNGLE_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_ACACIA_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_CHERRY_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_DARK_OAK_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_PALE_OAK_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_MANGROVE_LOG, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_BAMBOO_BLOCK, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_OAK_WOOD, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_SPRUCE_WOOD, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_BIRCH_WOOD, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_JUNGLE_WOOD, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_ACACIA_WOOD, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_CHERRY_WOOD, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_DARK_OAK_WOOD, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_PALE_OAK_WOOD, 5, 5);
        $$0.setFlammable(Blocks.STRIPPED_MANGROVE_WOOD, 5, 5);
        $$0.setFlammable(Blocks.OAK_WOOD, 5, 5);
        $$0.setFlammable(Blocks.SPRUCE_WOOD, 5, 5);
        $$0.setFlammable(Blocks.BIRCH_WOOD, 5, 5);
        $$0.setFlammable(Blocks.JUNGLE_WOOD, 5, 5);
        $$0.setFlammable(Blocks.ACACIA_WOOD, 5, 5);
        $$0.setFlammable(Blocks.CHERRY_WOOD, 5, 5);
        $$0.setFlammable(Blocks.PALE_OAK_WOOD, 5, 5);
        $$0.setFlammable(Blocks.DARK_OAK_WOOD, 5, 5);
        $$0.setFlammable(Blocks.MANGROVE_WOOD, 5, 5);
        $$0.setFlammable(Blocks.MANGROVE_ROOTS, 5, 20);
        $$0.setFlammable(Blocks.OAK_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.SPRUCE_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.BIRCH_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.JUNGLE_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.ACACIA_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.CHERRY_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.DARK_OAK_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.PALE_OAK_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.MANGROVE_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.BOOKSHELF, 30, 20);
        $$0.setFlammable(Blocks.TNT, 15, 100);
        $$0.setFlammable(Blocks.SHORT_GRASS, 60, 100);
        $$0.setFlammable(Blocks.FERN, 60, 100);
        $$0.setFlammable(Blocks.DEAD_BUSH, 60, 100);
        $$0.setFlammable(Blocks.SUNFLOWER, 60, 100);
        $$0.setFlammable(Blocks.LILAC, 60, 100);
        $$0.setFlammable(Blocks.ROSE_BUSH, 60, 100);
        $$0.setFlammable(Blocks.PEONY, 60, 100);
        $$0.setFlammable(Blocks.TALL_GRASS, 60, 100);
        $$0.setFlammable(Blocks.LARGE_FERN, 60, 100);
        $$0.setFlammable(Blocks.DANDELION, 60, 100);
        $$0.setFlammable(Blocks.POPPY, 60, 100);
        $$0.setFlammable(Blocks.BLUE_ORCHID, 60, 100);
        $$0.setFlammable(Blocks.ALLIUM, 60, 100);
        $$0.setFlammable(Blocks.AZURE_BLUET, 60, 100);
        $$0.setFlammable(Blocks.RED_TULIP, 60, 100);
        $$0.setFlammable(Blocks.ORANGE_TULIP, 60, 100);
        $$0.setFlammable(Blocks.WHITE_TULIP, 60, 100);
        $$0.setFlammable(Blocks.PINK_TULIP, 60, 100);
        $$0.setFlammable(Blocks.OXEYE_DAISY, 60, 100);
        $$0.setFlammable(Blocks.CORNFLOWER, 60, 100);
        $$0.setFlammable(Blocks.LILY_OF_THE_VALLEY, 60, 100);
        $$0.setFlammable(Blocks.TORCHFLOWER, 60, 100);
        $$0.setFlammable(Blocks.PITCHER_PLANT, 60, 100);
        $$0.setFlammable(Blocks.WITHER_ROSE, 60, 100);
        $$0.setFlammable(Blocks.PINK_PETALS, 60, 100);
        $$0.setFlammable(Blocks.WHITE_WOOL, 30, 60);
        $$0.setFlammable(Blocks.ORANGE_WOOL, 30, 60);
        $$0.setFlammable(Blocks.MAGENTA_WOOL, 30, 60);
        $$0.setFlammable(Blocks.LIGHT_BLUE_WOOL, 30, 60);
        $$0.setFlammable(Blocks.YELLOW_WOOL, 30, 60);
        $$0.setFlammable(Blocks.LIME_WOOL, 30, 60);
        $$0.setFlammable(Blocks.PINK_WOOL, 30, 60);
        $$0.setFlammable(Blocks.GRAY_WOOL, 30, 60);
        $$0.setFlammable(Blocks.LIGHT_GRAY_WOOL, 30, 60);
        $$0.setFlammable(Blocks.CYAN_WOOL, 30, 60);
        $$0.setFlammable(Blocks.PURPLE_WOOL, 30, 60);
        $$0.setFlammable(Blocks.BLUE_WOOL, 30, 60);
        $$0.setFlammable(Blocks.BROWN_WOOL, 30, 60);
        $$0.setFlammable(Blocks.GREEN_WOOL, 30, 60);
        $$0.setFlammable(Blocks.RED_WOOL, 30, 60);
        $$0.setFlammable(Blocks.BLACK_WOOL, 30, 60);
        $$0.setFlammable(Blocks.VINE, 15, 100);
        $$0.setFlammable(Blocks.COAL_BLOCK, 5, 5);
        $$0.setFlammable(Blocks.HAY_BLOCK, 60, 20);
        $$0.setFlammable(Blocks.TARGET, 15, 20);
        $$0.setFlammable(Blocks.WHITE_CARPET, 60, 20);
        $$0.setFlammable(Blocks.ORANGE_CARPET, 60, 20);
        $$0.setFlammable(Blocks.MAGENTA_CARPET, 60, 20);
        $$0.setFlammable(Blocks.LIGHT_BLUE_CARPET, 60, 20);
        $$0.setFlammable(Blocks.YELLOW_CARPET, 60, 20);
        $$0.setFlammable(Blocks.LIME_CARPET, 60, 20);
        $$0.setFlammable(Blocks.PINK_CARPET, 60, 20);
        $$0.setFlammable(Blocks.GRAY_CARPET, 60, 20);
        $$0.setFlammable(Blocks.LIGHT_GRAY_CARPET, 60, 20);
        $$0.setFlammable(Blocks.CYAN_CARPET, 60, 20);
        $$0.setFlammable(Blocks.PURPLE_CARPET, 60, 20);
        $$0.setFlammable(Blocks.BLUE_CARPET, 60, 20);
        $$0.setFlammable(Blocks.BROWN_CARPET, 60, 20);
        $$0.setFlammable(Blocks.GREEN_CARPET, 60, 20);
        $$0.setFlammable(Blocks.RED_CARPET, 60, 20);
        $$0.setFlammable(Blocks.BLACK_CARPET, 60, 20);
        $$0.setFlammable(Blocks.PALE_MOSS_BLOCK, 60, 20);
        $$0.setFlammable(Blocks.PALE_MOSS_CARPET, 60, 20);
        $$0.setFlammable(Blocks.PALE_HANGING_MOSS, 60, 100);
        $$0.setFlammable(Blocks.DRIED_KELP_BLOCK, 30, 60);
        $$0.setFlammable(Blocks.BAMBOO, 60, 60);
        $$0.setFlammable(Blocks.SCAFFOLDING, 60, 60);
        $$0.setFlammable(Blocks.LECTERN, 30, 20);
        $$0.setFlammable(Blocks.COMPOSTER, 5, 20);
        $$0.setFlammable(Blocks.SWEET_BERRY_BUSH, 60, 100);
        $$0.setFlammable(Blocks.BEEHIVE, 5, 20);
        $$0.setFlammable(Blocks.BEE_NEST, 30, 20);
        $$0.setFlammable(Blocks.AZALEA_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.FLOWERING_AZALEA_LEAVES, 30, 60);
        $$0.setFlammable(Blocks.CAVE_VINES, 15, 60);
        $$0.setFlammable(Blocks.CAVE_VINES_PLANT, 15, 60);
        $$0.setFlammable(Blocks.SPORE_BLOSSOM, 60, 100);
        $$0.setFlammable(Blocks.AZALEA, 30, 60);
        $$0.setFlammable(Blocks.FLOWERING_AZALEA, 30, 60);
        $$0.setFlammable(Blocks.BIG_DRIPLEAF, 60, 100);
        $$0.setFlammable(Blocks.BIG_DRIPLEAF_STEM, 60, 100);
        $$0.setFlammable(Blocks.SMALL_DRIPLEAF, 60, 100);
        $$0.setFlammable(Blocks.HANGING_ROOTS, 30, 60);
        $$0.setFlammable(Blocks.GLOW_LICHEN, 15, 100);
    }
}

