/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerBlock
extends BushBlock
implements SuspiciousEffectHolder {
    protected static final MapCodec<SuspiciousStewEffects> EFFECTS_FIELD = SuspiciousStewEffects.CODEC.fieldOf("suspicious_stew_effects");
    public static final MapCodec<FlowerBlock> CODEC = RecordCodecBuilder.mapCodec(p_368423_ -> p_368423_.group((App)EFFECTS_FIELD.forGetter(FlowerBlock::getSuspiciousEffects), FlowerBlock.propertiesCodec()).apply((Applicative)p_368423_, FlowerBlock::new));
    protected static final float AABB_OFFSET = 3.0f;
    protected static final VoxelShape SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 10.0, 11.0);
    private final SuspiciousStewEffects suspiciousStewEffects;

    public MapCodec<? extends FlowerBlock> codec() {
        return CODEC;
    }

    public FlowerBlock(Holder<MobEffect> p_316154_, float p_332744_, BlockBehaviour.Properties p_53514_) {
        this(FlowerBlock.makeEffectList(p_316154_, p_332744_), p_53514_);
    }

    public FlowerBlock(SuspiciousStewEffects p_330645_, BlockBehaviour.Properties p_304822_) {
        super(p_304822_);
        this.suspiciousStewEffects = p_330645_;
    }

    protected static SuspiciousStewEffects makeEffectList(Holder<MobEffect> p_316817_, float p_332817_) {
        return new SuspiciousStewEffects(List.of(new SuspiciousStewEffects.Entry(p_316817_, Mth.floor(p_332817_ * 20.0f))));
    }

    @Override
    protected VoxelShape getShape(BlockState p_53517_, BlockGetter p_53518_, BlockPos p_53519_, CollisionContext p_53520_) {
        Vec3 $$4 = p_53517_.getOffset(p_53519_);
        return SHAPE.move($$4.x, $$4.y, $$4.z);
    }

    @Override
    public SuspiciousStewEffects getSuspiciousEffects() {
        return this.suspiciousStewEffects;
    }
}

