/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class MultifaceBlock
extends Block {
    private static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = Util.make(Maps.newEnumMap(Direction.class), p_153923_ -> {
        p_153923_.put(Direction.NORTH, NORTH_AABB);
        p_153923_.put(Direction.EAST, EAST_AABB);
        p_153923_.put(Direction.SOUTH, SOUTH_AABB);
        p_153923_.put(Direction.WEST, WEST_AABB);
        p_153923_.put(Direction.UP, UP_AABB);
        p_153923_.put(Direction.DOWN, DOWN_AABB);
    });
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public MultifaceBlock(BlockBehaviour.Properties p_153822_) {
        super(p_153822_);
        this.registerDefaultState(MultifaceBlock.getDefaultMultifaceState(this.stateDefinition));
        this.shapesCache = this.getShapeForEachState(MultifaceBlock::calculateMultifaceShape);
        this.canRotate = Direction.Plane.HORIZONTAL.stream().allMatch(this::isFaceSupported);
        this.canMirrorX = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    protected abstract MapCodec<? extends MultifaceBlock> codec();

    public static Set<Direction> availableFaces(BlockState p_221585_) {
        if (!(p_221585_.getBlock() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<Direction> $$1 = EnumSet.noneOf(Direction.class);
        for (Direction $$2 : Direction.values()) {
            if (!MultifaceBlock.hasFace(p_221585_, $$2)) continue;
            $$1.add($$2);
        }
        return $$1;
    }

    public static Set<Direction> unpack(byte p_221570_) {
        EnumSet<Direction> $$1 = EnumSet.noneOf(Direction.class);
        for (Direction $$2 : Direction.values()) {
            if ((p_221570_ & (byte)(1 << $$2.ordinal())) <= 0) continue;
            $$1.add($$2);
        }
        return $$1;
    }

    public static byte pack(Collection<Direction> p_221577_) {
        byte $$1 = 0;
        for (Direction $$2 : p_221577_) {
            $$1 = (byte)($$1 | 1 << $$2.ordinal());
        }
        return $$1;
    }

    protected boolean isFaceSupported(Direction p_153921_) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_153917_) {
        for (Direction $$1 : DIRECTIONS) {
            if (!this.isFaceSupported($$1)) continue;
            p_153917_.add(MultifaceBlock.getFaceProperty($$1));
        }
    }

    @Override
    protected BlockState updateShape(BlockState p_153904_, LevelReader p_374463_, ScheduledTickAccess p_374073_, BlockPos p_153908_, Direction p_153905_, BlockPos p_153909_, BlockState p_153906_, RandomSource p_374390_) {
        if (!MultifaceBlock.hasAnyFace(p_153904_)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!MultifaceBlock.hasFace(p_153904_, p_153905_) || MultifaceBlock.canAttachTo(p_374463_, p_153905_, p_153909_, p_153906_)) {
            return p_153904_;
        }
        return MultifaceBlock.removeFace(p_153904_, MultifaceBlock.getFaceProperty(p_153905_));
    }

    @Override
    protected VoxelShape getShape(BlockState p_153851_, BlockGetter p_153852_, BlockPos p_153853_, CollisionContext p_153854_) {
        return (VoxelShape)this.shapesCache.get((Object)p_153851_);
    }

    @Override
    protected boolean canSurvive(BlockState p_153888_, LevelReader p_153889_, BlockPos p_153890_) {
        boolean $$3 = false;
        for (Direction $$4 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(p_153888_, $$4)) continue;
            BlockPos $$5 = p_153890_.relative($$4);
            if (!MultifaceBlock.canAttachTo(p_153889_, $$4, $$5, p_153889_.getBlockState($$5))) {
                return false;
            }
            $$3 = true;
        }
        return $$3;
    }

    @Override
    protected boolean canBeReplaced(BlockState p_153848_, BlockPlaceContext p_153849_) {
        return MultifaceBlock.hasAnyVacantFace(p_153848_);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_153824_) {
        Level $$1 = p_153824_.getLevel();
        BlockPos $$2 = p_153824_.getClickedPos();
        BlockState $$3 = $$1.getBlockState($$2);
        return Arrays.stream(p_153824_.getNearestLookingDirections()).map(p_153865_ -> this.getStateForPlacement($$3, $$1, $$2, (Direction)p_153865_)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isValidStateForPlacement(BlockGetter p_221572_, BlockState p_221573_, BlockPos p_221574_, Direction p_221575_) {
        if (!this.isFaceSupported(p_221575_) || p_221573_.is(this) && MultifaceBlock.hasFace(p_221573_, p_221575_)) {
            return false;
        }
        BlockPos $$4 = p_221574_.relative(p_221575_);
        return MultifaceBlock.canAttachTo(p_221572_, p_221575_, $$4, p_221572_.getBlockState($$4));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockState p_153941_, BlockGetter p_153942_, BlockPos p_153943_, Direction p_153944_) {
        BlockState $$6;
        if (!this.isValidStateForPlacement(p_153942_, p_153941_, p_153943_, p_153944_)) {
            return null;
        }
        if (p_153941_.is(this)) {
            BlockState $$4 = p_153941_;
        } else if (this.isWaterloggable() && p_153941_.getFluidState().isSourceOfType(Fluids.WATER)) {
            BlockState $$5 = (BlockState)this.defaultBlockState().setValue(BlockStateProperties.WATERLOGGED, true);
        } else {
            $$6 = this.defaultBlockState();
        }
        return (BlockState)$$6.setValue(MultifaceBlock.getFaceProperty(p_153944_), true);
    }

    @Override
    protected BlockState rotate(BlockState p_153895_, Rotation p_153896_) {
        if (!this.canRotate) {
            return p_153895_;
        }
        return this.mapDirections(p_153895_, p_153896_::rotate);
    }

    @Override
    protected BlockState mirror(BlockState p_153892_, Mirror p_153893_) {
        if (p_153893_ == Mirror.FRONT_BACK && !this.canMirrorX) {
            return p_153892_;
        }
        if (p_153893_ == Mirror.LEFT_RIGHT && !this.canMirrorZ) {
            return p_153892_;
        }
        return this.mapDirections(p_153892_, p_153893_::mirror);
    }

    private BlockState mapDirections(BlockState p_153911_, Function<Direction, Direction> p_153912_) {
        BlockState $$2 = p_153911_;
        for (Direction $$3 : DIRECTIONS) {
            if (!this.isFaceSupported($$3)) continue;
            $$2 = (BlockState)$$2.setValue(MultifaceBlock.getFaceProperty(p_153912_.apply($$3)), p_153911_.getValue(MultifaceBlock.getFaceProperty($$3)));
        }
        return $$2;
    }

    public static boolean hasFace(BlockState p_153901_, Direction p_153902_) {
        BooleanProperty $$2 = MultifaceBlock.getFaceProperty(p_153902_);
        return p_153901_.getValueOrElse($$2, false);
    }

    public static boolean canAttachTo(BlockGetter p_153830_, Direction p_153831_, BlockPos p_153832_, BlockState p_153833_) {
        return Block.isFaceFull(p_153833_.getBlockSupportShape(p_153830_, p_153832_), p_153831_.getOpposite()) || Block.isFaceFull(p_153833_.getCollisionShape(p_153830_, p_153832_), p_153831_.getOpposite());
    }

    private boolean isWaterloggable() {
        return this.stateDefinition.getProperties().contains(BlockStateProperties.WATERLOGGED);
    }

    private static BlockState removeFace(BlockState p_153898_, BooleanProperty p_153899_) {
        BlockState $$2 = (BlockState)p_153898_.setValue(p_153899_, false);
        if (MultifaceBlock.hasAnyFace($$2)) {
            return $$2;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static BooleanProperty getFaceProperty(Direction p_153934_) {
        return PROPERTY_BY_DIRECTION.get(p_153934_);
    }

    private static BlockState getDefaultMultifaceState(StateDefinition<Block, BlockState> p_153919_) {
        BlockState $$1 = p_153919_.any();
        for (BooleanProperty $$2 : PROPERTY_BY_DIRECTION.values()) {
            $$1 = (BlockState)$$1.trySetValue($$2, false);
        }
        return $$1;
    }

    private static VoxelShape calculateMultifaceShape(BlockState p_153959_) {
        VoxelShape $$1 = Shapes.empty();
        for (Direction $$2 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(p_153959_, $$2)) continue;
            $$1 = Shapes.or($$1, SHAPE_BY_DIRECTION.get($$2));
        }
        return $$1.isEmpty() ? Shapes.block() : $$1;
    }

    protected static boolean hasAnyFace(BlockState p_153961_) {
        for (Direction $$1 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(p_153961_, $$1)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyVacantFace(BlockState p_153963_) {
        for (Direction $$1 : DIRECTIONS) {
            if (MultifaceBlock.hasFace(p_153963_, $$1)) continue;
            return true;
        }
        return false;
    }

    public abstract MultifaceSpreader getSpreader();
}

