/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class PoweredRailBlock
extends BaseRailBlock {
    public static final MapCodec<PoweredRailBlock> CODEC = PoweredRailBlock.simpleCodec(PoweredRailBlock::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<PoweredRailBlock> codec() {
        return CODEC;
    }

    protected PoweredRailBlock(BlockBehaviour.Properties p_55218_) {
        super(true, p_55218_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, RailShape.NORTH_SOUTH)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    protected boolean findPoweredRailSignal(Level p_55220_, BlockPos p_55221_, BlockState p_55222_, boolean p_55223_, int p_55224_) {
        if (p_55224_ >= 8) {
            return false;
        }
        int $$5 = p_55221_.getX();
        int $$6 = p_55221_.getY();
        int $$7 = p_55221_.getZ();
        boolean $$8 = true;
        RailShape $$9 = p_55222_.getValue(SHAPE);
        switch ($$9) {
            case NORTH_SOUTH: {
                if (p_55223_) {
                    ++$$7;
                    break;
                }
                --$$7;
                break;
            }
            case EAST_WEST: {
                if (p_55223_) {
                    --$$5;
                    break;
                }
                ++$$5;
                break;
            }
            case ASCENDING_EAST: {
                if (p_55223_) {
                    --$$5;
                } else {
                    ++$$5;
                    ++$$6;
                    $$8 = false;
                }
                $$9 = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (p_55223_) {
                    --$$5;
                    ++$$6;
                    $$8 = false;
                } else {
                    ++$$5;
                }
                $$9 = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (p_55223_) {
                    ++$$7;
                } else {
                    --$$7;
                    ++$$6;
                    $$8 = false;
                }
                $$9 = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (p_55223_) {
                    ++$$7;
                    ++$$6;
                    $$8 = false;
                } else {
                    --$$7;
                }
                $$9 = RailShape.NORTH_SOUTH;
            }
        }
        if (this.isSameRailWithPower(p_55220_, new BlockPos($$5, $$6, $$7), p_55223_, p_55224_, $$9)) {
            return true;
        }
        return $$8 && this.isSameRailWithPower(p_55220_, new BlockPos($$5, $$6 - 1, $$7), p_55223_, p_55224_, $$9);
    }

    protected boolean isSameRailWithPower(Level p_55226_, BlockPos p_55227_, boolean p_55228_, int p_55229_, RailShape p_55230_) {
        BlockState $$5 = p_55226_.getBlockState(p_55227_);
        if (!$$5.is(this)) {
            return false;
        }
        RailShape $$6 = $$5.getValue(SHAPE);
        if (p_55230_ == RailShape.EAST_WEST && ($$6 == RailShape.NORTH_SOUTH || $$6 == RailShape.ASCENDING_NORTH || $$6 == RailShape.ASCENDING_SOUTH)) {
            return false;
        }
        if (p_55230_ == RailShape.NORTH_SOUTH && ($$6 == RailShape.EAST_WEST || $$6 == RailShape.ASCENDING_EAST || $$6 == RailShape.ASCENDING_WEST)) {
            return false;
        }
        if ($$5.getValue(POWERED).booleanValue()) {
            if (p_55226_.hasNeighborSignal(p_55227_)) {
                return true;
            }
            return this.findPoweredRailSignal(p_55226_, p_55227_, $$5, p_55228_, p_55229_ + 1);
        }
        return false;
    }

    @Override
    protected void updateState(BlockState p_55232_, Level p_55233_, BlockPos p_55234_, Block p_55235_) {
        boolean $$5;
        boolean $$4 = p_55232_.getValue(POWERED);
        boolean bl = $$5 = p_55233_.hasNeighborSignal(p_55234_) || this.findPoweredRailSignal(p_55233_, p_55234_, p_55232_, true, 0) || this.findPoweredRailSignal(p_55233_, p_55234_, p_55232_, false, 0);
        if ($$5 != $$4) {
            p_55233_.setBlock(p_55234_, (BlockState)p_55232_.setValue(POWERED, $$5), 3);
            p_55233_.updateNeighborsAt(p_55234_.below(), this);
            if (p_55232_.getValue(SHAPE).isSlope()) {
                p_55233_.updateNeighborsAt(p_55234_.above(), this);
            }
        }
    }

    @Override
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    @Override
    protected BlockState rotate(BlockState p_55240_, Rotation p_55241_) {
        switch (p_55241_) {
            case CLOCKWISE_180: {
                switch (p_55240_.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (p_55240_.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (p_55240_.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_55240_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                }
            }
        }
        return p_55240_;
    }

    @Override
    protected BlockState mirror(BlockState p_55237_, Mirror p_55238_) {
        RailShape $$2 = p_55237_.getValue(SHAPE);
        switch (p_55238_) {
            case LEFT_RIGHT: {
                switch ($$2) {
                    case ASCENDING_NORTH: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                }
                break;
            }
            case FRONT_BACK: {
                switch ($$2) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_55237_.setValue(SHAPE, RailShape.NORTH_WEST);
                    }
                }
                break;
            }
        }
        return super.mirror(p_55237_, p_55238_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55243_) {
        p_55243_.add(SHAPE, POWERED, WATERLOGGED);
    }
}

