/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public class SnowyDirtBlock
extends Block {
    public static final MapCodec<SnowyDirtBlock> CODEC = SnowyDirtBlock.simpleCodec(SnowyDirtBlock::new);
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;

    protected MapCodec<? extends SnowyDirtBlock> codec() {
        return CODEC;
    }

    protected SnowyDirtBlock(BlockBehaviour.Properties p_56640_) {
        super(p_56640_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(SNOWY, false));
    }

    @Override
    protected BlockState updateShape(BlockState p_56644_, LevelReader p_374564_, ScheduledTickAccess p_374201_, BlockPos p_56648_, Direction p_56645_, BlockPos p_56649_, BlockState p_56646_, RandomSource p_374447_) {
        if (p_56645_ == Direction.UP) {
            return (BlockState)p_56644_.setValue(SNOWY, SnowyDirtBlock.isSnowySetting(p_56646_));
        }
        return super.updateShape(p_56644_, p_374564_, p_374201_, p_56648_, p_56645_, p_56649_, p_56646_, p_374447_);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_56642_) {
        BlockState $$1 = p_56642_.getLevel().getBlockState(p_56642_.getClickedPos().above());
        return (BlockState)this.defaultBlockState().setValue(SNOWY, SnowyDirtBlock.isSnowySetting($$1));
    }

    private static boolean isSnowySetting(BlockState p_154649_) {
        return p_154649_.is(BlockTags.SNOW);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_56651_) {
        p_56651_.add(SNOWY);
    }
}

