/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SugarCaneBlock
extends Block {
    public static final MapCodec<SugarCaneBlock> CODEC = SugarCaneBlock.simpleCodec(SugarCaneBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    public MapCodec<SugarCaneBlock> codec() {
        return CODEC;
    }

    protected SugarCaneBlock(BlockBehaviour.Properties p_57168_) {
        super(p_57168_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected VoxelShape getShape(BlockState p_57193_, BlockGetter p_57194_, BlockPos p_57195_, CollisionContext p_57196_) {
        return SHAPE;
    }

    @Override
    protected void tick(BlockState p_222543_, ServerLevel p_222544_, BlockPos p_222545_, RandomSource p_222546_) {
        if (!p_222543_.canSurvive(p_222544_, p_222545_)) {
            p_222544_.destroyBlock(p_222545_, true);
        }
    }

    @Override
    protected void randomTick(BlockState p_222548_, ServerLevel p_222549_, BlockPos p_222550_, RandomSource p_222551_) {
        if (p_222549_.isEmptyBlock(p_222550_.above())) {
            int $$4 = 1;
            while (p_222549_.getBlockState(p_222550_.below($$4)).is(this)) {
                ++$$4;
            }
            if ($$4 < 3) {
                int $$5 = p_222548_.getValue(AGE);
                if ($$5 == 15) {
                    p_222549_.setBlockAndUpdate(p_222550_.above(), this.defaultBlockState());
                    p_222549_.setBlock(p_222550_, (BlockState)p_222548_.setValue(AGE, 0), 4);
                } else {
                    p_222549_.setBlock(p_222550_, (BlockState)p_222548_.setValue(AGE, $$5 + 1), 4);
                }
            }
        }
    }

    @Override
    protected BlockState updateShape(BlockState p_57179_, LevelReader p_374168_, ScheduledTickAccess p_374217_, BlockPos p_57183_, Direction p_57180_, BlockPos p_57184_, BlockState p_57181_, RandomSource p_374240_) {
        if (!p_57179_.canSurvive(p_374168_, p_57183_)) {
            p_374217_.scheduleTick(p_57183_, this, 1);
        }
        return super.updateShape(p_57179_, p_374168_, p_374217_, p_57183_, p_57180_, p_57184_, p_57181_, p_374240_);
    }

    @Override
    protected boolean canSurvive(BlockState p_57175_, LevelReader p_57176_, BlockPos p_57177_) {
        BlockState $$3 = p_57176_.getBlockState(p_57177_.below());
        if ($$3.is(this)) {
            return true;
        }
        if ($$3.is(BlockTags.DIRT) || $$3.is(BlockTags.SAND)) {
            BlockPos $$4 = p_57177_.below();
            for (Direction $$5 : Direction.Plane.HORIZONTAL) {
                BlockState $$6 = p_57176_.getBlockState($$4.relative($$5));
                FluidState $$7 = p_57176_.getFluidState($$4.relative($$5));
                if (!$$7.is(FluidTags.WATER) && !$$6.is(Blocks.FROSTED_ICE)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57186_) {
        p_57186_.add(AGE);
    }
}

