/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TripWireBlock
extends Block {
    public static final MapCodec<TripWireBlock> CODEC = RecordCodecBuilder.mapCodec(p_368444_ -> p_368444_.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("hook").forGetter(p_304664_ -> p_304664_.hook), TripWireBlock.propertiesCodec()).apply((Applicative)p_368444_, TripWireBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    public static final BooleanProperty DISARMED = BlockStateProperties.DISARMED;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = CrossCollisionBlock.PROPERTY_BY_DIRECTION;
    protected static final VoxelShape AABB = Block.box(0.0, 1.0, 0.0, 16.0, 2.5, 16.0);
    protected static final VoxelShape NOT_ATTACHED_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final int RECHECK_PERIOD = 10;
    private final Block hook;

    public MapCodec<TripWireBlock> codec() {
        return CODEC;
    }

    public TripWireBlock(Block p_304873_, BlockBehaviour.Properties p_57604_) {
        super(p_57604_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(POWERED, false)).setValue(ATTACHED, false)).setValue(DISARMED, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.hook = p_304873_;
    }

    @Override
    protected VoxelShape getShape(BlockState p_57654_, BlockGetter p_57655_, BlockPos p_57656_, CollisionContext p_57657_) {
        return p_57654_.getValue(ATTACHED) != false ? AABB : NOT_ATTACHED_AABB;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_57606_) {
        Level $$1 = p_57606_.getLevel();
        BlockPos $$2 = p_57606_.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, this.shouldConnectTo($$1.getBlockState($$2.north()), Direction.NORTH))).setValue(EAST, this.shouldConnectTo($$1.getBlockState($$2.east()), Direction.EAST))).setValue(SOUTH, this.shouldConnectTo($$1.getBlockState($$2.south()), Direction.SOUTH))).setValue(WEST, this.shouldConnectTo($$1.getBlockState($$2.west()), Direction.WEST));
    }

    @Override
    protected BlockState updateShape(BlockState p_57645_, LevelReader p_374437_, ScheduledTickAccess p_374214_, BlockPos p_57649_, Direction p_57646_, BlockPos p_57650_, BlockState p_57647_, RandomSource p_374065_) {
        if (p_57646_.getAxis().isHorizontal()) {
            return (BlockState)p_57645_.setValue(PROPERTY_BY_DIRECTION.get(p_57646_), this.shouldConnectTo(p_57647_, p_57646_));
        }
        return super.updateShape(p_57645_, p_374437_, p_374214_, p_57649_, p_57646_, p_57650_, p_57647_, p_374065_);
    }

    @Override
    protected void onPlace(BlockState p_57659_, Level p_57660_, BlockPos p_57661_, BlockState p_57662_, boolean p_57663_) {
        if (p_57662_.is(p_57659_.getBlock())) {
            return;
        }
        this.updateSource(p_57660_, p_57661_, p_57659_);
    }

    @Override
    protected void onRemove(BlockState p_57630_, Level p_57631_, BlockPos p_57632_, BlockState p_57633_, boolean p_57634_) {
        if (p_57634_ || p_57630_.is(p_57633_.getBlock())) {
            return;
        }
        this.updateSource(p_57631_, p_57632_, (BlockState)p_57630_.setValue(POWERED, true));
    }

    @Override
    public BlockState playerWillDestroy(Level p_57615_, BlockPos p_57616_, BlockState p_57617_, Player p_57618_) {
        if (!p_57615_.isClientSide && !p_57618_.getMainHandItem().isEmpty() && p_57618_.getMainHandItem().is(Items.SHEARS)) {
            p_57615_.setBlock(p_57616_, (BlockState)p_57617_.setValue(DISARMED, true), 4);
            p_57615_.gameEvent((Entity)p_57618_, GameEvent.SHEAR, p_57616_);
        }
        return super.playerWillDestroy(p_57615_, p_57616_, p_57617_, p_57618_);
    }

    private void updateSource(Level p_57611_, BlockPos p_57612_, BlockState p_57613_) {
        block0: for (Direction $$3 : new Direction[]{Direction.SOUTH, Direction.WEST}) {
            for (int $$4 = 1; $$4 < 42; ++$$4) {
                BlockPos $$5 = p_57612_.relative($$3, $$4);
                BlockState $$6 = p_57611_.getBlockState($$5);
                if ($$6.is(this.hook)) {
                    if ($$6.getValue(TripWireHookBlock.FACING) != $$3.getOpposite()) continue block0;
                    TripWireHookBlock.calculateState(p_57611_, $$5, $$6, false, true, $$4, p_57613_);
                    continue block0;
                }
                if (!$$6.is(this)) continue block0;
            }
        }
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(BlockState p_371595_, Level p_371620_, BlockPos p_371231_) {
        return p_371595_.getShape(p_371620_, p_371231_);
    }

    @Override
    protected void entityInside(BlockState p_57625_, Level p_57626_, BlockPos p_57627_, Entity p_57628_) {
        if (p_57626_.isClientSide) {
            return;
        }
        if (p_57625_.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(p_57626_, p_57627_, List.of(p_57628_));
    }

    @Override
    protected void tick(BlockState p_222598_, ServerLevel p_222599_, BlockPos p_222600_, RandomSource p_222601_) {
        if (!p_222599_.getBlockState(p_222600_).getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(p_222599_, p_222600_);
    }

    private void checkPressed(Level p_57608_, BlockPos p_57609_) {
        BlockState $$2 = p_57608_.getBlockState(p_57609_);
        List<Entity> $$3 = p_57608_.getEntities(null, $$2.getShape(p_57608_, p_57609_).bounds().move(p_57609_));
        this.checkPressed(p_57608_, p_57609_, $$3);
    }

    private void checkPressed(Level p_371409_, BlockPos p_371396_, List<? extends Entity> p_371326_) {
        BlockState $$3 = p_371409_.getBlockState(p_371396_);
        boolean $$4 = $$3.getValue(POWERED);
        boolean $$5 = false;
        if (!p_371326_.isEmpty()) {
            for (Entity entity : p_371326_) {
                if (entity.isIgnoringBlockTriggers()) continue;
                $$5 = true;
                break;
            }
        }
        if ($$5 != $$4) {
            $$3 = (BlockState)$$3.setValue(POWERED, $$5);
            p_371409_.setBlock(p_371396_, $$3, 3);
            this.updateSource(p_371409_, p_371396_, $$3);
        }
        if ($$5) {
            p_371409_.scheduleTick(new BlockPos(p_371396_), this, 10);
        }
    }

    public boolean shouldConnectTo(BlockState p_57642_, Direction p_57643_) {
        if (p_57642_.is(this.hook)) {
            return p_57642_.getValue(TripWireHookBlock.FACING) == p_57643_.getOpposite();
        }
        return p_57642_.is(this);
    }

    @Override
    protected BlockState rotate(BlockState p_57639_, Rotation p_57640_) {
        switch (p_57640_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57639_.setValue(NORTH, p_57639_.getValue(SOUTH))).setValue(EAST, p_57639_.getValue(WEST))).setValue(SOUTH, p_57639_.getValue(NORTH))).setValue(WEST, p_57639_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57639_.setValue(NORTH, p_57639_.getValue(EAST))).setValue(EAST, p_57639_.getValue(SOUTH))).setValue(SOUTH, p_57639_.getValue(WEST))).setValue(WEST, p_57639_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57639_.setValue(NORTH, p_57639_.getValue(WEST))).setValue(EAST, p_57639_.getValue(NORTH))).setValue(SOUTH, p_57639_.getValue(EAST))).setValue(WEST, p_57639_.getValue(SOUTH));
            }
        }
        return p_57639_;
    }

    @Override
    protected BlockState mirror(BlockState p_57636_, Mirror p_57637_) {
        switch (p_57637_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_57636_.setValue(NORTH, p_57636_.getValue(SOUTH))).setValue(SOUTH, p_57636_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_57636_.setValue(EAST, p_57636_.getValue(WEST))).setValue(WEST, p_57636_.getValue(EAST));
            }
        }
        return super.mirror(p_57636_, p_57637_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57652_) {
        p_57652_.add(POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH);
    }
}

