/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TripWireHookBlock
extends Block {
    public static final MapCodec<TripWireHookBlock> CODEC = TripWireHookBlock.simpleCodec(TripWireHookBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    protected static final int WIRE_DIST_MIN = 1;
    protected static final int WIRE_DIST_MAX = 42;
    private static final int RECHECK_PERIOD = 10;
    protected static final int AABB_OFFSET = 3;
    protected static final VoxelShape NORTH_AABB = Block.box(5.0, 0.0, 10.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(5.0, 0.0, 0.0, 11.0, 10.0, 6.0);
    protected static final VoxelShape WEST_AABB = Block.box(10.0, 0.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 5.0, 6.0, 10.0, 11.0);

    public MapCodec<TripWireHookBlock> codec() {
        return CODEC;
    }

    public TripWireHookBlock(BlockBehaviour.Properties p_57676_) {
        super(p_57676_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(ATTACHED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState p_57740_, BlockGetter p_57741_, BlockPos p_57742_, CollisionContext p_57743_) {
        switch (p_57740_.getValue(FACING)) {
            default: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: 
        }
        return NORTH_AABB;
    }

    @Override
    protected boolean canSurvive(BlockState p_57721_, LevelReader p_57722_, BlockPos p_57723_) {
        Direction $$3 = p_57721_.getValue(FACING);
        BlockPos $$4 = p_57723_.relative($$3.getOpposite());
        BlockState $$5 = p_57722_.getBlockState($$4);
        return $$3.getAxis().isHorizontal() && $$5.isFaceSturdy(p_57722_, $$4, $$3);
    }

    @Override
    protected BlockState updateShape(BlockState p_57731_, LevelReader p_374415_, ScheduledTickAccess p_374046_, BlockPos p_57735_, Direction p_57732_, BlockPos p_57736_, BlockState p_57733_, RandomSource p_374155_) {
        if (p_57732_.getOpposite() == p_57731_.getValue(FACING) && !p_57731_.canSurvive(p_374415_, p_57735_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_57731_, p_374415_, p_374046_, p_57735_, p_57732_, p_57736_, p_57733_, p_374155_);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_57678_) {
        Direction[] $$4;
        BlockState $$1 = (BlockState)((BlockState)this.defaultBlockState().setValue(POWERED, false)).setValue(ATTACHED, false);
        Level $$2 = p_57678_.getLevel();
        BlockPos $$3 = p_57678_.getClickedPos();
        for (Direction $$5 : $$4 = p_57678_.getNearestLookingDirections()) {
            Direction $$6;
            if (!$$5.getAxis().isHorizontal() || !($$1 = (BlockState)$$1.setValue(FACING, $$6 = $$5.getOpposite())).canSurvive($$2, $$3)) continue;
            return $$1;
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level p_57680_, BlockPos p_57681_, BlockState p_57682_, LivingEntity p_57683_, ItemStack p_57684_) {
        TripWireHookBlock.calculateState(p_57680_, p_57681_, p_57682_, false, false, -1, null);
    }

    public static void calculateState(Level p_57686_, BlockPos p_57687_, BlockState p_57688_, boolean p_57689_, boolean p_57690_, int p_57691_, @Nullable BlockState p_57692_) {
        Optional<Direction> $$7 = p_57688_.getOptionalValue(FACING);
        if (!$$7.isPresent()) {
            return;
        }
        Direction $$8 = $$7.get();
        boolean $$9 = p_57688_.getOptionalValue(ATTACHED).orElse(false);
        boolean $$10 = p_57688_.getOptionalValue(POWERED).orElse(false);
        Block $$11 = p_57688_.getBlock();
        boolean $$12 = !p_57689_;
        boolean $$13 = false;
        int $$14 = 0;
        BlockState[] $$15 = new BlockState[42];
        for (int $$16 = 1; $$16 < 42; ++$$16) {
            BlockPos $$17 = p_57687_.relative($$8, $$16);
            BlockState $$18 = p_57686_.getBlockState($$17);
            if ($$18.is(Blocks.TRIPWIRE_HOOK)) {
                if ($$18.getValue(FACING) != $$8.getOpposite()) break;
                $$14 = $$16;
                break;
            }
            if ($$18.is(Blocks.TRIPWIRE) || $$16 == p_57691_) {
                if ($$16 == p_57691_) {
                    $$18 = (BlockState)MoreObjects.firstNonNull((Object)p_57692_, (Object)$$18);
                }
                boolean $$19 = $$18.getValue(TripWireBlock.DISARMED) == false;
                boolean $$20 = $$18.getValue(TripWireBlock.POWERED);
                $$13 |= $$19 && $$20;
                $$15[$$16] = $$18;
                if ($$16 != p_57691_) continue;
                p_57686_.scheduleTick(p_57687_, $$11, 10);
                $$12 &= $$19;
                continue;
            }
            $$15[$$16] = null;
            $$12 = false;
        }
        BlockState $$21 = (BlockState)((BlockState)$$11.defaultBlockState().trySetValue(ATTACHED, $$12)).trySetValue(POWERED, $$13 &= ($$12 &= $$14 > 1));
        if ($$14 > 0) {
            BlockPos $$22 = p_57687_.relative($$8, $$14);
            Direction $$23 = $$8.getOpposite();
            p_57686_.setBlock($$22, (BlockState)$$21.setValue(FACING, $$23), 3);
            TripWireHookBlock.notifyNeighbors($$11, p_57686_, $$22, $$23);
            TripWireHookBlock.emitState(p_57686_, $$22, $$12, $$13, $$9, $$10);
        }
        TripWireHookBlock.emitState(p_57686_, p_57687_, $$12, $$13, $$9, $$10);
        if (!p_57689_) {
            p_57686_.setBlock(p_57687_, (BlockState)$$21.setValue(FACING, $$8), 3);
            if (p_57690_) {
                TripWireHookBlock.notifyNeighbors($$11, p_57686_, p_57687_, $$8);
            }
        }
        if ($$9 != $$12) {
            for (int $$24 = 1; $$24 < $$14; ++$$24) {
                BlockState $$27;
                BlockPos $$25 = p_57687_.relative($$8, $$24);
                BlockState $$26 = $$15[$$24];
                if ($$26 == null || !($$27 = p_57686_.getBlockState($$25)).is(Blocks.TRIPWIRE) && !$$27.is(Blocks.TRIPWIRE_HOOK)) continue;
                p_57686_.setBlock($$25, (BlockState)$$26.trySetValue(ATTACHED, $$12), 3);
            }
        }
    }

    @Override
    protected void tick(BlockState p_222610_, ServerLevel p_222611_, BlockPos p_222612_, RandomSource p_222613_) {
        TripWireHookBlock.calculateState(p_222611_, p_222612_, p_222610_, false, true, -1, null);
    }

    private static void emitState(Level p_222603_, BlockPos p_222604_, boolean p_222605_, boolean p_222606_, boolean p_222607_, boolean p_222608_) {
        if (p_222606_ && !p_222608_) {
            p_222603_.playSound(null, p_222604_, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 0.4f, 0.6f);
            p_222603_.gameEvent(null, GameEvent.BLOCK_ACTIVATE, p_222604_);
        } else if (!p_222606_ && p_222608_) {
            p_222603_.playSound(null, p_222604_, SoundEvents.TRIPWIRE_CLICK_OFF, SoundSource.BLOCKS, 0.4f, 0.5f);
            p_222603_.gameEvent(null, GameEvent.BLOCK_DEACTIVATE, p_222604_);
        } else if (p_222605_ && !p_222607_) {
            p_222603_.playSound(null, p_222604_, SoundEvents.TRIPWIRE_ATTACH, SoundSource.BLOCKS, 0.4f, 0.7f);
            p_222603_.gameEvent(null, GameEvent.BLOCK_ATTACH, p_222604_);
        } else if (!p_222605_ && p_222607_) {
            p_222603_.playSound(null, p_222604_, SoundEvents.TRIPWIRE_DETACH, SoundSource.BLOCKS, 0.4f, 1.2f / (p_222603_.random.nextFloat() * 0.2f + 0.9f));
            p_222603_.gameEvent(null, GameEvent.BLOCK_DETACH, p_222604_);
        }
    }

    private static void notifyNeighbors(Block p_304466_, Level p_57694_, BlockPos p_57695_, Direction p_57696_) {
        Direction $$4 = p_57696_.getOpposite();
        Orientation $$5 = ExperimentalRedstoneUtils.initialOrientation(p_57694_, $$4, Direction.UP);
        p_57694_.updateNeighborsAt(p_57695_, p_304466_, $$5);
        p_57694_.updateNeighborsAt(p_57695_.relative($$4), p_304466_, $$5);
    }

    @Override
    protected void onRemove(BlockState p_57715_, Level p_57716_, BlockPos p_57717_, BlockState p_57718_, boolean p_57719_) {
        if (p_57719_ || p_57715_.is(p_57718_.getBlock())) {
            return;
        }
        boolean $$5 = p_57715_.getValue(ATTACHED);
        boolean $$6 = p_57715_.getValue(POWERED);
        if ($$5 || $$6) {
            TripWireHookBlock.calculateState(p_57716_, p_57717_, p_57715_, true, false, -1, null);
        }
        if ($$6) {
            TripWireHookBlock.notifyNeighbors(this, p_57716_, p_57717_, p_57715_.getValue(FACING));
        }
        super.onRemove(p_57715_, p_57716_, p_57717_, p_57718_, p_57719_);
    }

    @Override
    protected int getSignal(BlockState p_57710_, BlockGetter p_57711_, BlockPos p_57712_, Direction p_57713_) {
        return p_57710_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState p_57745_, BlockGetter p_57746_, BlockPos p_57747_, Direction p_57748_) {
        if (!p_57745_.getValue(POWERED).booleanValue()) {
            return 0;
        }
        if (p_57745_.getValue(FACING) == p_57748_) {
            return 15;
        }
        return 0;
    }

    @Override
    protected boolean isSignalSource(BlockState p_57750_) {
        return true;
    }

    @Override
    protected BlockState rotate(BlockState p_57728_, Rotation p_57729_) {
        return (BlockState)p_57728_.setValue(FACING, p_57729_.rotate(p_57728_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_57725_, Mirror p_57726_) {
        return p_57725_.rotate(p_57726_.getRotation(p_57725_.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57738_) {
        p_57738_.add(FACING, POWERED, ATTACHED);
    }
}

