/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallBannerBlock
extends AbstractBannerBlock {
    public static final MapCodec<WallBannerBlock> CODEC = RecordCodecBuilder.mapCodec(p_368445_ -> p_368445_.group((App)DyeColor.CODEC.fieldOf("color").forGetter(AbstractBannerBlock::getColor), WallBannerBlock.propertiesCodec()).apply((Applicative)p_368445_, WallBannerBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box(0.0, 0.0, 14.0, 16.0, 12.5, 16.0), (Object)Direction.SOUTH, (Object)Block.box(0.0, 0.0, 0.0, 16.0, 12.5, 2.0), (Object)Direction.WEST, (Object)Block.box(14.0, 0.0, 0.0, 16.0, 12.5, 16.0), (Object)Direction.EAST, (Object)Block.box(0.0, 0.0, 0.0, 2.0, 12.5, 16.0)));

    public MapCodec<WallBannerBlock> codec() {
        return CODEC;
    }

    public WallBannerBlock(DyeColor p_57920_, BlockBehaviour.Properties p_57921_) {
        super(p_57920_, p_57921_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH));
    }

    @Override
    protected boolean canSurvive(BlockState p_57925_, LevelReader p_57926_, BlockPos p_57927_) {
        return p_57926_.getBlockState(p_57927_.relative(p_57925_.getValue(FACING).getOpposite())).isSolid();
    }

    @Override
    protected BlockState updateShape(BlockState p_57935_, LevelReader p_374553_, ScheduledTickAccess p_374106_, BlockPos p_57939_, Direction p_57936_, BlockPos p_57940_, BlockState p_57937_, RandomSource p_374162_) {
        if (p_57936_ == p_57935_.getValue(FACING).getOpposite() && !p_57935_.canSurvive(p_374553_, p_57939_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_57935_, p_374553_, p_374106_, p_57939_, p_57936_, p_57940_, p_57937_, p_374162_);
    }

    @Override
    protected VoxelShape getShape(BlockState p_57944_, BlockGetter p_57945_, BlockPos p_57946_, CollisionContext p_57947_) {
        return SHAPES.get(p_57944_.getValue(FACING));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_57923_) {
        Direction[] $$4;
        BlockState $$1 = this.defaultBlockState();
        Level $$2 = p_57923_.getLevel();
        BlockPos $$3 = p_57923_.getClickedPos();
        for (Direction $$5 : $$4 = p_57923_.getNearestLookingDirections()) {
            Direction $$6;
            if (!$$5.getAxis().isHorizontal() || !($$1 = (BlockState)$$1.setValue(FACING, $$6 = $$5.getOpposite())).canSurvive($$2, $$3)) continue;
            return $$1;
        }
        return null;
    }

    @Override
    protected BlockState rotate(BlockState p_57932_, Rotation p_57933_) {
        return (BlockState)p_57932_.setValue(FACING, p_57933_.rotate(p_57932_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_57929_, Mirror p_57930_) {
        return p_57929_.rotate(p_57930_.getRotation(p_57929_.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57942_) {
        p_57942_.add(FACING);
    }
}

