/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.TargetColorParticleOption;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.creaking.CreakingTransient;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class CreakingHeartBlockEntity
extends BlockEntity {
    private static final int PLAYER_DETECTION_RANGE = 32;
    public static final int CREAKING_ROAMING_RADIUS = 32;
    private static final int DISTANCE_CREAKING_TOO_FAR = 34;
    private static final int SPAWN_RANGE_XZ = 16;
    private static final int SPAWN_RANGE_Y = 8;
    private static final int ATTEMPTS_PER_SPAWN = 5;
    private static final int UPDATE_TICKS = 20;
    private static final int HURT_CALL_TOTAL_TICKS = 100;
    private static final int NUMBER_OF_HURT_CALLS = 10;
    private static final int HURT_CALL_INTERVAL = 10;
    private static final int HURT_CALL_PARTICLE_TICKS = 50;
    @Nullable
    private CreakingTransient creaking;
    private int ticker;
    private int emitter;
    @Nullable
    private Vec3 emitterTarget;
    private int outputSignal;

    public CreakingHeartBlockEntity(BlockPos p_380287_, BlockState p_379335_) {
        super(BlockEntityType.CREAKING_HEART, p_380287_, p_379335_);
    }

    public static void serverTick(Level p_379321_, BlockPos p_379679_, BlockState p_379831_, CreakingHeartBlockEntity p_379534_) {
        ServerLevel $$11;
        int $$4 = p_379534_.computeAnalogOutputSignal();
        if (p_379534_.outputSignal != $$4) {
            p_379534_.outputSignal = $$4;
            p_379321_.updateNeighbourForOutputSignal(p_379679_, Blocks.CREAKING_HEART);
        }
        if (p_379534_.emitter > 0) {
            if (p_379534_.emitter > 50) {
                p_379534_.emitParticles((ServerLevel)p_379321_, 1, true);
                p_379534_.emitParticles((ServerLevel)p_379321_, 1, false);
            }
            if (p_379534_.emitter % 10 == 0 && p_379321_ instanceof ServerLevel) {
                ServerLevel $$5 = (ServerLevel)p_379321_;
                if (p_379534_.emitterTarget != null) {
                    if (p_379534_.creaking != null) {
                        p_379534_.emitterTarget = p_379534_.creaking.getBoundingBox().getCenter();
                    }
                    Vec3 $$6 = Vec3.atCenterOf(p_379679_);
                    float $$7 = 0.2f + 0.8f * (float)(100 - p_379534_.emitter) / 100.0f;
                    Vec3 $$8 = $$6.subtract(p_379534_.emitterTarget).scale($$7).add(p_379534_.emitterTarget);
                    BlockPos $$9 = BlockPos.containing($$8);
                    float $$10 = (float)p_379534_.emitter / 2.0f / 100.0f + 0.5f;
                    $$5.playSound(null, $$9, SoundEvents.CREAKING_HEART_HURT, SoundSource.BLOCKS, $$10, 1.0f);
                }
            }
            --p_379534_.emitter;
        }
        if (p_379534_.ticker-- >= 0) {
            return;
        }
        p_379534_.ticker = 20;
        if (p_379534_.creaking != null) {
            if (!CreakingHeartBlock.canSummonCreaking(p_379321_) || p_379534_.distanceToCreaking() > 34.0) {
                p_379534_.removeProtector(null);
                return;
            }
            if (p_379534_.creaking.isRemoved()) {
                p_379534_.creaking = null;
            }
            if (!CreakingHeartBlock.hasRequiredLogs(p_379831_, p_379321_, p_379679_) && p_379534_.creaking == null) {
                p_379321_.setBlock(p_379679_, (BlockState)p_379831_.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DISABLED), 3);
            }
            return;
        }
        if (!CreakingHeartBlock.hasRequiredLogs(p_379831_, p_379321_, p_379679_)) {
            p_379321_.setBlock(p_379679_, (BlockState)p_379831_.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DISABLED), 3);
            return;
        }
        if (!CreakingHeartBlock.canSummonCreaking(p_379321_)) {
            if (p_379831_.getValue(CreakingHeartBlock.CREAKING) == CreakingHeartBlock.CreakingHeartState.ACTIVE) {
                p_379321_.setBlock(p_379679_, (BlockState)p_379831_.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DORMANT), 3);
                return;
            }
        } else if (p_379831_.getValue(CreakingHeartBlock.CREAKING) == CreakingHeartBlock.CreakingHeartState.DORMANT) {
            p_379321_.setBlock(p_379679_, (BlockState)p_379831_.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.ACTIVE), 3);
            return;
        }
        if (p_379831_.getValue(CreakingHeartBlock.CREAKING) != CreakingHeartBlock.CreakingHeartState.ACTIVE) {
            return;
        }
        if (p_379321_.getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        if (p_379321_ instanceof ServerLevel && !($$11 = (ServerLevel)p_379321_).getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return;
        }
        Player $$12 = p_379321_.getNearestPlayer((double)p_379679_.getX(), (double)p_379679_.getY(), (double)p_379679_.getZ(), 32.0, false);
        if ($$12 != null) {
            p_379534_.creaking = CreakingHeartBlockEntity.spawnProtector((ServerLevel)p_379321_, p_379534_);
            if (p_379534_.creaking != null) {
                p_379534_.creaking.makeSound(SoundEvents.CREAKING_SPAWN);
                p_379321_.playSound(null, p_379534_.getBlockPos(), SoundEvents.CREAKING_HEART_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private double distanceToCreaking() {
        if (this.creaking == null) {
            return 0.0;
        }
        return Math.sqrt(this.creaking.distanceToSqr(Vec3.atBottomCenterOf(this.getBlockPos())));
    }

    @Nullable
    private static CreakingTransient spawnProtector(ServerLevel p_379873_, CreakingHeartBlockEntity p_379806_) {
        BlockPos $$2 = p_379806_.getBlockPos();
        Optional<CreakingTransient> $$3 = SpawnUtil.trySpawnMob(EntityType.CREAKING_TRANSIENT, EntitySpawnReason.SPAWNER, p_379873_, $$2, 5, 16, 8, SpawnUtil.Strategy.ON_TOP_OF_COLLIDER_NO_LEAVES);
        if ($$3.isEmpty()) {
            return null;
        }
        CreakingTransient $$4 = $$3.get();
        p_379873_.gameEvent((Entity)$$4, GameEvent.ENTITY_PLACE, $$4.position());
        p_379873_.broadcastEntityEvent($$4, (byte)60);
        $$4.bindToCreakingHeart($$2);
        return $$4;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_379306_) {
        return this.saveCustomOnly(p_379306_);
    }

    /*
     * WARNING - void declaration
     */
    public void creakingHurt() {
        void $$1;
        if (this.creaking == null) {
            return;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$0 = (ServerLevel)level;
        this.emitParticles((ServerLevel)$$1, 20, false);
        this.emitter = 100;
        this.emitterTarget = this.creaking.getBoundingBox().getCenter();
    }

    private void emitParticles(ServerLevel p_379473_, int p_380023_, boolean p_379802_) {
        if (this.creaking == null) {
            return;
        }
        int $$3 = p_379802_ ? 16545810 : 0x5F5F5F;
        RandomSource $$4 = p_379473_.random;
        for (double $$5 = 0.0; $$5 < (double)p_380023_; $$5 += 1.0) {
            Vec3 $$6 = this.creaking.getBoundingBox().getMinPosition().add($$4.nextDouble() * this.creaking.getBoundingBox().getXsize(), $$4.nextDouble() * this.creaking.getBoundingBox().getYsize(), $$4.nextDouble() * this.creaking.getBoundingBox().getZsize());
            Vec3 $$7 = Vec3.atLowerCornerOf(this.getBlockPos()).add($$4.nextDouble(), $$4.nextDouble(), $$4.nextDouble());
            if (p_379802_) {
                Vec3 $$8 = $$6;
                $$6 = $$7;
                $$7 = $$8;
            }
            TargetColorParticleOption $$9 = new TargetColorParticleOption($$7, $$3);
            p_379473_.sendParticles($$9, $$6.x, $$6.y, $$6.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void removeProtector(@Nullable DamageSource p_379965_) {
        if (this.creaking != null) {
            this.creaking.tearDown(p_379965_);
            this.creaking = null;
        }
    }

    public boolean isProtector(Creaking p_380040_) {
        return this.creaking == p_380040_;
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    public int computeAnalogOutputSignal() {
        if (this.creaking == null) {
            return 0;
        }
        double $$0 = this.distanceToCreaking();
        double $$1 = Math.clamp($$0, 0.0, 32.0) / 32.0;
        return 15 - (int)Math.floor($$1 * 15.0);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

