/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class StateDefinition<O, S extends StateHolder<O, S>> {
    static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    private final O owner;
    private final ImmutableSortedMap<String, Property<?>> propertiesByName;
    private final ImmutableList<S> states;

    protected StateDefinition(Function<O, S> p_61052_, O p_61053_, Factory<O, S> p_61054_, Map<String, Property<?>> p_61055_) {
        this.owner = p_61053_;
        this.propertiesByName = ImmutableSortedMap.copyOf(p_61055_);
        Supplier<StateHolder> $$4 = () -> (StateHolder)p_61052_.apply(p_61053_);
        MapCodec<StateHolder> $$5 = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit($$4));
        for (Map.Entry $$6 : this.propertiesByName.entrySet()) {
            $$5 = StateDefinition.appendPropertyCodec($$5, $$4, (String)$$6.getKey(), (Property)$$6.getValue());
        }
        MapCodec<StateHolder> $$7 = $$5;
        LinkedHashMap $$8 = Maps.newLinkedHashMap();
        ArrayList $$9 = Lists.newArrayList();
        Stream<List<List<Object>>> $$10 = Stream.of(Collections.emptyList());
        for (Property $$11 : this.propertiesByName.values()) {
            $$10 = $$10.flatMap(p_372784_ -> $$11.getPossibleValues().stream().map(p_155961_ -> {
                ArrayList $$3 = Lists.newArrayList((Iterable)p_372784_);
                $$3.add(Pair.of((Object)$$11, (Object)p_155961_));
                return $$3;
            }));
        }
        $$10.forEach(p_325887_ -> {
            Reference2ObjectArrayMap $$6 = new Reference2ObjectArrayMap(p_325887_.size());
            for (Pair $$7 : p_325887_) {
                $$6.put((Object)((Property)$$7.getFirst()), (Object)((Comparable)$$7.getSecond()));
            }
            StateHolder $$8 = (StateHolder)p_61054_.create(p_61053_, $$6, $$7);
            $$8.put($$6, $$8);
            $$9.add($$8);
        });
        for (StateHolder $$12 : $$9) {
            $$12.populateNeighbours($$8);
        }
        this.states = ImmutableList.copyOf((Collection)$$9);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> MapCodec<S> appendPropertyCodec(MapCodec<S> p_61077_, Supplier<S> p_61078_, String p_61079_, Property<T> p_61080_) {
        return Codec.mapPair(p_61077_, (MapCodec)p_61080_.valueCodec().fieldOf(p_61079_).orElseGet(p_187541_ -> {}, () -> p_61080_.value((StateHolder)p_61078_.get()))).xmap(p_187536_ -> (StateHolder)((StateHolder)p_187536_.getFirst()).setValue(p_61080_, ((Property.Value)p_187536_.getSecond()).value()), p_187533_ -> Pair.of((Object)p_187533_, p_61080_.value((StateHolder<?, ?>)p_187533_)));
    }

    public ImmutableList<S> getPossibleStates() {
        return this.states;
    }

    public S any() {
        return (S)((StateHolder)this.states.get(0));
    }

    public O getOwner() {
        return this.owner;
    }

    public Collection<Property<?>> getProperties() {
        return this.propertiesByName.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.owner).add("properties", this.propertiesByName.values().stream().map(Property::getName).collect(Collectors.toList())).toString();
    }

    @Nullable
    public Property<?> getProperty(String p_61082_) {
        return (Property)this.propertiesByName.get((Object)p_61082_);
    }

    public static interface Factory<O, S> {
        public S create(O var1, Reference2ObjectArrayMap<Property<?>, Comparable<?>> var2, MapCodec<S> var3);
    }

    public static class Builder<O, S extends StateHolder<O, S>> {
        private final O owner;
        private final Map<String, Property<?>> properties = Maps.newHashMap();

        public Builder(O p_61098_) {
            this.owner = p_61098_;
        }

        public Builder<O, S> add(Property<?> ... p_61105_) {
            for (Property<?> $$1 : p_61105_) {
                this.validateProperty($$1);
                this.properties.put($$1.getName(), $$1);
            }
            return this;
        }

        private <T extends Comparable<T>> void validateProperty(Property<T> p_61100_) {
            String $$1 = p_61100_.getName();
            if (!NAME_PATTERN.matcher($$1).matches()) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has invalidly named property: " + $$1);
            }
            List<T> $$2 = p_61100_.getPossibleValues();
            if ($$2.size() <= 1) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " attempted use property " + $$1 + " with <= 1 possible values");
            }
            for (Comparable $$3 : $$2) {
                String $$4 = p_61100_.getName($$3);
                if (NAME_PATTERN.matcher($$4).matches()) continue;
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has property: " + $$1 + " with invalidly named value: " + $$4);
            }
            if (this.properties.containsKey($$1)) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has duplicate property: " + $$1);
            }
        }

        public StateDefinition<O, S> create(Function<O, S> p_61102_, Factory<O, S> p_61103_) {
            return new StateDefinition<O, S>(p_61102_, this.owner, p_61103_, this.properties);
        }
    }
}

